/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.io.UnicodeInputStream;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.util.ExtProperties;
import org.slf4j.Logger;

public abstract class ResourceLoader {
    protected boolean isCachingOn = false;
    protected long modificationCheckInterval = 2L;
    protected String className = null;
    protected RuntimeServices rsvc = null;
    protected Logger log = null;

    public void commonInit(RuntimeServices rs, ExtProperties configuration) {
        this.rsvc = rs;
        String loaderName = configuration.getString("_RESOURCE_LOADER_IDENTIFIER_");
        this.log = this.rsvc.getLog("loader." + (loaderName == null ? this.getClass().getSimpleName() : loaderName));
        try {
            this.isCachingOn = configuration.getBoolean("cache", false);
        }
        catch (Exception e2) {
            this.isCachingOn = false;
            String msg = "Exception parsing cache setting: " + configuration.getString("cache");
            this.log.error(msg, e2);
            throw new VelocityException(msg, e2);
        }
        try {
            this.modificationCheckInterval = configuration.getLong("modification_check_interval", 0L);
        }
        catch (Exception e3) {
            this.modificationCheckInterval = 0L;
            String msg = "Exception parsing modificationCheckInterval setting: modification_check_interval";
            this.log.error(msg, e3);
            throw new VelocityException(msg, e3);
        }
        this.className = ResourceCacheImpl.class.getName();
        try {
            this.className = configuration.getString("class", this.className);
        }
        catch (Exception e4) {
            String msg = "Exception retrieving resource cache class name";
            this.log.error(msg, e4);
            throw new VelocityException(msg, e4);
        }
    }

    public abstract void init(ExtProperties var1);

    public abstract Reader getResourceReader(String var1, String var2) throws ResourceNotFoundException;

    public abstract boolean isSourceModified(Resource var1);

    public abstract long getLastModified(Resource var1);

    public String getClassName() {
        return this.className;
    }

    public void setCachingOn(boolean value) {
        this.isCachingOn = value;
    }

    public boolean isCachingOn() {
        return this.isCachingOn;
    }

    public void setModificationCheckInterval(long modificationCheckInterval) {
        this.modificationCheckInterval = modificationCheckInterval;
    }

    public long getModificationCheckInterval() {
        return this.modificationCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceExists(String resourceName) {
        Reader reader = null;
        try {
            reader = this.getResourceReader(resourceName, null);
        }
        catch (ResourceNotFoundException e2) {
            this.log.debug("Could not load resource '{}' from ResourceLoader {}", (Object)resourceName, (Object)this.getClass().getName());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e3) {
                String msg = "While closing InputStream for resource '" + resourceName + "' from ResourceLoader " + this.getClass().getName();
                this.log.error(msg, e3);
                throw new VelocityException(msg, e3);
            }
        }
        return reader != null;
    }

    protected Reader buildReader(InputStream rawStream, String encoding) throws IOException {
        UnicodeInputStream inputStream = new UnicodeInputStream(rawStream);
        String foundEncoding = inputStream.getEncodingFromStream();
        if (foundEncoding != null && encoding != null && !UnicodeInputStream.sameEncoding(foundEncoding, encoding)) {
            this.log.warn("Found BOM encoding '{}' differs from asked encoding: '{}' - using BOM encoding to read resource.", (Object)foundEncoding, (Object)encoding);
            encoding = foundEncoding;
        }
        if (encoding == null) {
            encoding = foundEncoding == null ? this.rsvc.getString("resource.default_encoding") : foundEncoding;
        }
        try {
            return new InputStreamReader((InputStream)inputStream, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw uee;
        }
    }
}

