/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.slf4j.Logger;

public class MapSetExecutor
extends SetExecutor {
    private final String property;

    public MapSetExecutor(Logger log, Class clazz, String property) {
        this.log = log;
        this.property = property;
        this.discover(clazz);
    }

    protected void discover(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            if (!anInterface.equals(Map.class)) continue;
            try {
                if (this.property == null) break;
                this.setMethod(Map.class.getMethod("put", Object.class, Object.class));
                break;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                String msg = "Exception while looking for put('" + this.property + "') method";
                this.log.error(msg, e3);
                throw new VelocityException(msg, e3);
            }
        }
    }

    @Override
    public Object execute(Object o2, Object arg) {
        return ((Map)o2).put(this.property, arg);
    }
}

