/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.StringReader;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";

    public ASTStringLiteral(int id) {
        super(id);
    }

    public ASTStringLiteral(Parser p2, int id) {
        super(p2, id);
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        String img;
        super.init(context, data);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate_string_literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(this.rsvc.getParserConfiguration().getDollarChar()) != -1 || this.getFirstToken().image.indexOf(this.rsvc.getParserConfiguration().getHashChar()) != -1);
        this.literal = img = this.getFirstToken().image;
        this.image = img.substring(1, img.length() - 1);
        if (img.startsWith("\"")) {
            this.image = ASTStringLiteral.unescape(this.image);
        }
        if (img.charAt(0) == '\"' || img.charAt(0) == '\'') {
            this.image = this.replaceQuotes(this.image, img.charAt(0));
        }
        if (this.interpolate) {
            StringReader br = new StringReader(this.image);
            Template template = null;
            if (context != null) {
                template = (Template)context.getCurrentResource();
            }
            if (template == null) {
                template = new Template();
                template.setName("StringLiteral");
            }
            try {
                this.nodeTree = this.rsvc.parse(br, template);
            }
            catch (ParseException e2) {
                String msg = "Failed to parse String literal at " + StringUtils.formatFileString(template.getName(), this.getLine(), this.getColumn());
                throw new TemplateInitException(msg, e2, this.rsvc.getLogContext().getStackTrace(), template.getName(), this.getColumn(), this.getLine());
            }
            this.adjTokenLineNums(this.nodeTree);
            this.nodeTree.init(context, this.rsvc);
        }
        this.cleanupParserAndTokens();
        return data;
    }

    public void adjTokenLineNums(Node node) {
        Token tok = node.getFirstToken();
        while (tok != null && tok != node.getLastToken()) {
            if (tok.beginLine == 1) {
                tok.beginColumn += this.getColumn();
            }
            if (tok.endLine == 1) {
                tok.endColumn += this.getColumn();
            }
            tok.beginLine += this.getLine() - 1;
            tok.endLine += this.getLine() - 1;
            tok = tok.next;
        }
    }

    private String replaceQuotes(String s2, char literalQuoteChar) {
        if (literalQuoteChar == '\"' && !s2.contains("\"") || literalQuoteChar == '\'' && !s2.contains("'")) {
            return s2;
        }
        StringBuilder result = new StringBuilder(s2.length());
        int is = s2.length();
        for (int i2 = 0; i2 < is; ++i2) {
            char c2 = s2.charAt(i2);
            result.append(c2);
            if (i2 + 1 >= is) continue;
            char next = s2.charAt(i2 + 1);
            if ((literalQuoteChar != '\"' || next != '\"' || c2 != '\"') && (literalQuoteChar != '\'' || next != '\'' || c2 != '\'')) continue;
            ++i2;
        }
        return result.toString();
    }

    public static String unescape(String string) {
        int u = string.indexOf("\\u");
        if (u < 0) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        int lastCopied = 0;
        do {
            result.append(string.substring(lastCopied, u));
            char c2 = (char)Integer.parseInt(string.substring(u + 2, u + 6), 16);
            result.append(c2);
        } while ((u = string.indexOf("\\u", lastCopied = u + 6)) >= 0);
        result.append(string.substring(lastCopied));
        return result.toString();
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isConstant() {
        return !this.interpolate;
    }

    @Override
    public Object value(InternalContextAdapter context) {
        if (this.interpolate) {
            try {
                StringBuilderWriter writer = new StringBuilderWriter();
                this.nodeTree.render(context, writer);
                return ((Object)writer).toString();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (IOException e3) {
                String msg = "Error in interpolating string literal";
                this.log.error(msg, e3);
                throw new VelocityException(msg, e3, this.rsvc.getLogContext().getStackTrace());
            }
        }
        return this.image;
    }

    @Override
    public boolean evaluate(InternalContextAdapter context) {
        String str = (String)this.value(context);
        return str != null && (!this.rsvc.getBoolean("directive.if.empty_check", true) || !str.isEmpty());
    }
}

