/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.io.Filter;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.directive.Block;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTAndNode;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTIfStatement;
import org.apache.velocity.runtime.parser.node.ASTIndex;
import org.apache.velocity.runtime.parser.node.ASTMethod;
import org.apache.velocity.runtime.parser.node.ASTNotNode;
import org.apache.velocity.runtime.parser.node.ASTOrNode;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.DuckType;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertySet;

public class ASTReference
extends SimpleNode {
    private static final int NORMAL_REFERENCE = 1;
    private static final int FORMAL_REFERENCE = 2;
    private static final int QUIET_REFERENCE = 3;
    private static final int RUNT = 4;
    private int referenceType;
    private String nullString;
    private String alternateNullStringKey;
    private String rootString;
    private boolean escaped = false;
    private boolean computableReference = true;
    private boolean logOnNull = true;
    private boolean lookupAlternateLiteral = false;
    private String escPrefix = "";
    private String morePrefix = "";
    private String identifier = "";
    private boolean checkEmpty;
    public boolean strictRef = false;
    private ASTIndex astIndex = null;
    private ASTExpression astAlternateValue = null;
    public boolean strictEscape = false;
    private int numChildren = 0;
    private boolean warnInvalidQuietReferences = false;
    private boolean warnInvalidNullReferences = false;
    private boolean warnInvalidTestedReferences = false;
    protected Info uberInfo;

    public ASTReference(int id) {
        super(id);
    }

    public ASTReference(Parser p2, int id) {
        super(p2, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        super.init(context, data);
        this.strictEscape = this.rsvc.getBoolean("runtime.strict_mode.escape", false);
        this.strictRef = this.rsvc.getBoolean("runtime.strict_mode.enable", false);
        this.lookupAlternateLiteral = this.rsvc.getBoolean("velocimacro.enable_bc_mode", false);
        String string = this.rootString = this.rsvc.useStringInterning() ? this.getRoot().intern() : this.getRoot();
        if (this.lookupAlternateLiteral) {
            this.alternateNullStringKey = ".literal." + this.nullString;
        }
        this.numChildren = this.jjtGetNumChildren();
        this.literal();
        if (this.numChildren > 0) {
            Node lastNode = this.jjtGetChild(this.numChildren - 1);
            if (lastNode instanceof ASTIndex) {
                this.astIndex = (ASTIndex)lastNode;
            } else if (lastNode instanceof ASTExpression) {
                this.astAlternateValue = (ASTExpression)lastNode;
                --this.numChildren;
            } else {
                this.identifier = lastNode.getFirstTokenImage();
            }
        }
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
        this.logOnNull = this.rsvc.getBoolean("runtime.log.log_invalid_references", true);
        this.checkEmpty = this.rsvc.getBoolean("directive.if.empty_check", true);
        this.warnInvalidQuietReferences = this.rsvc.getBoolean("event_handler.invalid_references.quiet", false);
        this.warnInvalidNullReferences = this.rsvc.getBoolean("event_handler.invalid_references.null", false);
        this.warnInvalidTestedReferences = this.rsvc.getBoolean("event_handler.invalid_references.tested", false);
        if (this.strictRef && this.numChildren == 0) {
            this.logOnNull = false;
            Node node = this.jjtGetParent();
            if (node instanceof ASTNotNode || node instanceof ASTExpression || node instanceof ASTOrNode || node instanceof ASTAndNode) {
                while (node != null) {
                    if (node instanceof ASTIfStatement) {
                        this.strictRef = false;
                        break;
                    }
                    node = node.jjtGetParent();
                }
            }
        }
        this.saveTokenImages();
        this.cleanupParserAndTokens();
        return data;
    }

    public String getRootString() {
        return this.rootString;
    }

    @Override
    public Object execute(Object o2, InternalContextAdapter context) throws MethodInvocationException {
        try {
            boolean onlyTestingReference;
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            boolean bl = onlyTestingReference = o2 != null;
            if (this.referenceType == 4) {
                Object var4_4 = null;
                return var4_4;
            }
            Object result = this.getRootVariableValue(context);
            if (result == null && !this.strictRef) {
                if (!(this.referenceType == 3 && !this.warnInvalidQuietReferences || this.numChildren <= 0 && (context.containsKey(this.rootString) && !this.warnInvalidNullReferences || onlyTestingReference && !this.warnInvalidTestedReferences))) {
                    result = EventHandlerUtil.invalidGetMethod(this.rsvc, context, this.rsvc.getParserConfiguration().getDollarChar() + this.rootString, null, null, this.uberInfo);
                }
                if (this.astAlternateValue != null && !DuckType.asBoolean(result, true)) {
                    result = this.astAlternateValue.value(context);
                }
                Object object = result;
                return object;
            }
            Object previousResult = result;
            int failedChild = -1;
            for (int i2 = 0; i2 < this.numChildren; ++i2) {
                if (this.strictRef && result == null) {
                    String name = this.jjtGetChild(i2).getFirstTokenImage();
                    throw new VelocityException("Attempted to access '" + name + "' on a null value at " + StringUtils.formatFileString(this.uberInfo.getTemplateName(), this.jjtGetChild(i2).getLine(), this.jjtGetChild(i2).getColumn()), null, this.rsvc.getLogContext().getStackTrace());
                }
                previousResult = result;
                result = this.jjtGetChild(i2).execute(result, context);
                if (result != null || this.strictRef) continue;
                failedChild = i2;
                break;
            }
            if (result == null) {
                if (failedChild == -1) {
                    if (!(context.containsKey(this.rootString) && !this.warnInvalidNullReferences || this.referenceType == 3 && !this.warnInvalidQuietReferences || onlyTestingReference && !this.warnInvalidTestedReferences && this.numChildren <= 0)) {
                        result = EventHandlerUtil.invalidGetMethod(this.rsvc, context, this.rsvc.getParserConfiguration().getDollarChar() + this.rootString, previousResult, null, this.uberInfo);
                    }
                } else {
                    Node child = this.jjtGetChild(failedChild);
                    IntrospectionCacheData getter = context.icacheGet(child);
                    if (!(getter != null && !this.warnInvalidNullReferences || this.referenceType == 3 && !this.warnInvalidQuietReferences || onlyTestingReference && !this.warnInvalidTestedReferences && failedChild >= this.numChildren - 1)) {
                        StringBuilder name = new StringBuilder(String.valueOf(this.rsvc.getParserConfiguration().getDollarChar())).append(this.rootString);
                        for (int i3 = 0; i3 <= failedChild; ++i3) {
                            Node node = this.jjtGetChild(i3);
                            if (node instanceof ASTMethod) {
                                name.append(".").append(((ASTMethod)node).getMethodName()).append("()");
                                continue;
                            }
                            name.append(".").append(node.getFirstTokenImage());
                        }
                        if (child instanceof ASTMethod) {
                            String methodName = ((ASTMethod)this.jjtGetChild(failedChild)).getMethodName();
                            result = EventHandlerUtil.invalidMethod(this.rsvc, context, name.toString(), previousResult, methodName, this.uberInfo);
                        } else {
                            String property = this.jjtGetChild(failedChild).getFirstTokenImage();
                            result = EventHandlerUtil.invalidGetMethod(this.rsvc, context, name.toString(), previousResult, property, this.uberInfo);
                        }
                    }
                }
            }
            if (this.astAlternateValue != null && !DuckType.asBoolean(result, true)) {
                result = this.astAlternateValue.value(context);
            }
            Object object = result;
            return object;
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        try {
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            if (this.referenceType == 4) {
                writer.write(this.literal);
                boolean bl = true;
                return bl;
            }
            Object value = null;
            value = this.escaped && this.strictEscape ? Boolean.TRUE : this.execute(null, context);
            String localNullString = null;
            if (this.escaped) {
                localNullString = this.getNullString(context);
                if (value == null) {
                    writer.write(this.escPrefix);
                    writer.write("\\");
                    writer.write(localNullString);
                } else {
                    writer.write(this.escPrefix);
                    writer.write(localNullString);
                }
                boolean bl = true;
                return bl;
            }
            value = EventHandlerUtil.referenceInsert(this.rsvc, context, this.literal, value);
            String toString = null;
            if (value != null) {
                if (value instanceof Renderable) {
                    Renderable renderable = (Renderable)value;
                    try {
                        writer.write(this.escPrefix);
                        writer.write(this.morePrefix);
                        if (renderable.render(context, writer)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (RuntimeException e2) {
                        this.log.error("Exception rendering " + (renderable instanceof Block.Reference ? "block " : "Renderable ") + this.rootString + " at " + StringUtils.formatFileString(this));
                        throw e2;
                    }
                }
                toString = DuckType.asString(value);
            }
            if (value == null || toString == null) {
                if (this.strictRef) {
                    if (this.referenceType != 3) {
                        this.log.error("Prepend the reference with '$!' e.g., $!{} if you want Velocity to ignore the reference when it evaluates to null", (Object)this.literal().substring(1));
                        if (value == null) {
                            throw new VelocityException("Reference " + this.literal() + " evaluated to null when attempting to render at " + StringUtils.formatFileString(this), null, this.rsvc.getLogContext().getStackTrace());
                        }
                        throw new VelocityException("Reference " + this.literal() + " evaluated to object " + value.getClass().getName() + " whose toString() method returned null at " + StringUtils.formatFileString(this), null, this.rsvc.getLogContext().getStackTrace());
                    }
                    boolean bl = true;
                    return bl;
                }
                localNullString = this.getNullString(context);
                if (!this.strictEscape) {
                    writer.write(this.escPrefix);
                }
                writer.write(this.escPrefix);
                writer.write(this.morePrefix);
                writer.write(localNullString);
                if (this.logOnNull && this.referenceType != 3) {
                    this.log.debug("Null reference [template '{}', line {}, column {}]: {} cannot be resolved.", this.getTemplateName(), this.getLine(), this.getColumn(), this.literal());
                }
            } else {
                writer.write(this.escPrefix);
                writer.write(this.morePrefix);
                if (writer instanceof Filter) {
                    ((Filter)((Object)writer)).writeReference(toString);
                } else {
                    writer.write(toString);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    private String getNullString(InternalContextAdapter context) {
        Deque alternateLiteralsStack;
        String ret = this.nullString;
        if (this.lookupAlternateLiteral && (alternateLiteralsStack = (Deque)context.get(this.alternateNullStringKey)) != null && alternateLiteralsStack.size() > 0) {
            ret = (String)alternateLiteralsStack.peekFirst();
        }
        return ret;
    }

    @Override
    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        Object value = this.execute(this, context);
        if (value == null) {
            return false;
        }
        try {
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            boolean bl = DuckType.asBoolean(value, this.checkEmpty);
            return bl;
        }
        catch (Exception e2) {
            throw new VelocityException("Reference evaluation threw an exception at " + StringUtils.formatFileString(this), e2, this.rsvc.getLogContext().getStackTrace());
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    @Override
    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        return this.computableReference ? this.execute(null, context) : null;
    }

    public static String printClass(Class<?> clazz) {
        return clazz == null ? "null" : clazz.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(InternalContextAdapter context, Object value) throws MethodInvocationException {
        try {
            this.rsvc.getLogContext().pushLogContext(this, this.uberInfo);
            if (this.astAlternateValue != null) {
                this.log.error("reference set cannot have a default value {}", (Object)StringUtils.formatFileString(this.uberInfo));
                boolean bl = false;
                return bl;
            }
            if (this.numChildren == 0) {
                context.put(this.rootString, value);
                boolean bl = true;
                return bl;
            }
            Object result = this.getRootVariableValue(context);
            if (result == null) {
                this.log.error("reference set is not a valid reference at {}", (Object)StringUtils.formatFileString(this.uberInfo));
                boolean bl = false;
                return bl;
            }
            for (int i2 = 0; i2 < this.numChildren - 1; ++i2) {
                result = this.jjtGetChild(i2).execute(result, context);
                if (result != null) continue;
                if (this.strictRef) {
                    String name = this.jjtGetChild(i2 + 1).getFirstTokenImage();
                    throw new MethodInvocationException("Attempted to access '" + name + "' on a null value", null, this.rsvc.getLogContext().getStackTrace(), name, this.uberInfo.getTemplateName(), this.jjtGetChild(i2 + 1).getLine(), this.jjtGetChild(i2 + 1).getColumn());
                }
                this.log.error("reference set is not a valid reference at {}", (Object)StringUtils.formatFileString(this.uberInfo));
                boolean name = false;
                return name;
            }
            if (this.astIndex != null) {
                Object argument = this.astIndex.jjtGetChild(0).value(context);
                argument = ASTIndex.adjMinusIndexArg(argument, result, context, this.astIndex);
                Object[] params = new Object[]{argument, value};
                String methodName = "set";
                Class[] paramClasses = new Class[]{params[0] == null ? null : params[0].getClass(), params[1] == null ? null : params[1].getClass()};
                VelMethod method = ClassUtils.getMethod(methodName, params, paramClasses, result, context, this.astIndex, false);
                if (method == null) {
                    methodName = "put";
                    method = ClassUtils.getMethod(methodName, params, paramClasses, result, context, this.astIndex, false);
                }
                if (method == null) {
                    if (this.strictRef) {
                        throw new VelocityException("Found neither a 'set' or 'put' method with param types '(" + ASTReference.printClass(paramClasses[0]) + "," + ASTReference.printClass(paramClasses[1]) + ")' on class '" + result.getClass().getName() + "' at " + StringUtils.formatFileString(this.astIndex), null, this.rsvc.getLogContext().getStackTrace());
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                    method.invoke(result, params);
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new MethodInvocationException("Exception calling method '" + methodName + "(" + ASTReference.printClass(paramClasses[0]) + "," + ASTReference.printClass(paramClasses[1]) + ")' in  " + result.getClass(), e3.getCause(), this.rsvc.getLogContext().getStackTrace(), this.identifier, this.astIndex.getTemplateName(), this.astIndex.getLine(), this.astIndex.getColumn());
                }
                boolean bl = true;
                return bl;
            }
            VelPropertySet vs = this.rsvc.getUberspect().getPropertySet(result, this.identifier, value, this.uberInfo);
            if (vs == null) {
                if (this.strictRef) {
                    throw new MethodInvocationException("Object '" + result.getClass().getName() + "' does not contain property '" + this.identifier + "'", null, this.rsvc.getLogContext().getStackTrace(), this.identifier, this.uberInfo.getTemplateName(), this.uberInfo.getLine(), this.uberInfo.getColumn());
                }
                boolean params = false;
                return params;
            }
            try {
                vs.invoke(result, value);
            }
            catch (InvocationTargetException ite) {
                throw new MethodInvocationException("ASTReference: Invocation of method '" + this.identifier + "' in  " + result.getClass() + " threw exception " + ite.getTargetException().toString(), ite.getTargetException(), this.rsvc.getLogContext().getStackTrace(), this.identifier, this.getTemplateName(), this.getLine(), this.getColumn());
            }
            catch (RuntimeException e4) {
                throw e4;
            }
            catch (Exception e5) {
                String msg = "ASTReference setValue(): exception: " + e5 + " template at " + StringUtils.formatFileString(this.uberInfo);
                this.log.error(msg, e5);
                throw new VelocityException(msg, e5, this.rsvc.getLogContext().getStackTrace());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rsvc.getLogContext().popLogContext();
        }
    }

    private String getRoot() {
        int loc1;
        Token t = this.getFirstToken();
        int slashbang = t.image.indexOf("\\!");
        if (slashbang != -1) {
            if (this.strictEscape) {
                this.nullString = this.literal();
                this.escaped = true;
                return this.nullString;
            }
            int i2 = 0;
            int len = t.image.length();
            i2 = t.image.indexOf(this.rsvc.getParserConfiguration().getDollarChar());
            if (i2 == -1) {
                this.log.error("ASTReference.getRoot(): internal error: no $ found for slashbang.");
                this.computableReference = false;
                this.nullString = t.image;
                return this.nullString;
            }
            while (i2 < len && t.image.charAt(i2) != '\\') {
                ++i2;
            }
            int start = i2;
            int count = 0;
            while (i2 < len && t.image.charAt(i2++) == '\\') {
                ++count;
            }
            this.nullString = t.image.substring(0, start);
            this.nullString = this.nullString + t.image.substring(start, start + count - 1);
            this.nullString = this.nullString + t.image.substring(start + count);
            this.computableReference = false;
            return this.nullString;
        }
        this.escaped = false;
        if (t.image.startsWith("\\")) {
            int i3;
            int len = t.image.length();
            for (i3 = 0; i3 < len && t.image.charAt(i3) == '\\'; ++i3) {
            }
            if (i3 % 2 != 0) {
                this.escaped = true;
            }
            if (i3 > 0) {
                this.escPrefix = t.image.substring(0, i3 / 2);
            }
            t.image = t.image.substring(i3);
        }
        if ((loc1 = t.image.lastIndexOf(this.rsvc.getParserConfiguration().getDollarChar())) > 0) {
            this.morePrefix = this.morePrefix + t.image.substring(0, loc1);
            t.image = t.image.substring(loc1);
        }
        this.nullString = this.literal();
        if (t.image.startsWith("$!")) {
            this.referenceType = 3;
            if (!this.escaped) {
                this.nullString = "";
            }
            if (t.image.startsWith("$!{")) {
                return t.next.image;
            }
            return t.image.substring(2);
        }
        if (t.image.equals("${")) {
            this.referenceType = 2;
            return t.next.image;
        }
        if (t.image.startsWith("$")) {
            this.referenceType = 1;
            return t.image.substring(1);
        }
        this.referenceType = 4;
        return t.image;
    }

    public Object getRootVariableValue(InternalContextAdapter context) {
        Object obj = null;
        try {
            obj = context.get(this.rootString);
        }
        catch (RuntimeException e2) {
            this.log.error("Exception calling reference ${} at {}", (Object)this.rootString, (Object)StringUtils.formatFileString(this.uberInfo));
            throw e2;
        }
        if (obj == null && this.strictRef && this.astAlternateValue == null && !context.containsKey(this.rootString)) {
            this.log.error("Variable ${} has not been set at {}", (Object)this.rootString, (Object)StringUtils.formatFileString(this.uberInfo));
            throw new MethodInvocationException("Variable $" + this.rootString + " has not been set", null, this.rsvc.getLogContext().getStackTrace(), this.identifier, this.uberInfo.getTemplateName(), this.uberInfo.getLine(), this.uberInfo.getColumn());
        }
        return obj;
    }
}

