/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Arrays;

final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] v) {
        int i2;
        double r2 = 0.0;
        double m3 = 0.0;
        double s2 = 0.0;
        int iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += v[i2];
        }
        m3 = s2 / (double)v.length;
        s2 = 0.0;
        iSize = v.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += Math.abs(v[i2] - m3);
        }
        r2 = s2 / (double)v.length;
        return r2;
    }

    public static double stdev(double[] v) {
        double r2 = Double.NaN;
        if (v != null && v.length > 1) {
            r2 = Math.sqrt(StatsLib.devsq(v) / (double)(v.length - 1));
        }
        return r2;
    }

    public static double var(double[] v) {
        double r2 = Double.NaN;
        if (v != null && v.length > 1) {
            r2 = StatsLib.devsq(v) / (double)(v.length - 1);
        }
        return r2;
    }

    public static double varp(double[] v) {
        double r2 = Double.NaN;
        if (v != null && v.length > 1) {
            r2 = StatsLib.devsq(v) / (double)v.length;
        }
        return r2;
    }

    public static double median(double[] v) {
        double r2 = Double.NaN;
        if (v != null && v.length >= 1) {
            int n2 = v.length;
            Arrays.sort(v);
            r2 = n2 % 2 == 0 ? (v[n2 / 2] + v[n2 / 2 - 1]) / 2.0 : v[n2 / 2];
        }
        return r2;
    }

    public static double devsq(double[] v) {
        double r2 = Double.NaN;
        if (v != null && v.length >= 1) {
            int i2;
            double m3 = 0.0;
            double s2 = 0.0;
            int n2 = v.length;
            for (i2 = 0; i2 < n2; ++i2) {
                s2 += v[i2];
            }
            m3 = s2 / (double)n2;
            s2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                s2 += (v[i2] - m3) * (v[i2] - m3);
            }
            r2 = n2 == 1 ? 0.0 : s2;
        }
        return r2;
    }

    public static double kthLargest(double[] v, int k2) {
        double r2 = Double.NaN;
        int index = k2 - 1;
        if (v != null && v.length > index && index >= 0) {
            Arrays.sort(v);
            r2 = v[v.length - index - 1];
        }
        return r2;
    }

    public static double kthSmallest(double[] v, int k2) {
        double r2 = Double.NaN;
        int index = k2 - 1;
        if (v != null && v.length > index && index >= 0) {
            Arrays.sort(v);
            r2 = v[index];
        }
        return r2;
    }
}

