/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

public final class FinanceLib {
    private FinanceLib() {
    }

    public static double fv(double r2, double n2, double y, double p2, boolean t) {
        if (r2 == 0.0) {
            return -1.0 * (p2 + n2 * y);
        }
        double r1 = r2 + 1.0;
        return (1.0 - Math.pow(r1, n2)) * (t ? r1 : 1.0) * y / r2 - p2 * Math.pow(r1, n2);
    }

    public static double pv(double r2, double n2, double y, double f2, boolean t) {
        if (r2 == 0.0) {
            return -1.0 * (n2 * y + f2);
        }
        double r1 = r2 + 1.0;
        return ((1.0 - Math.pow(r1, n2)) / r2 * (t ? r1 : 1.0) * y - f2) / Math.pow(r1, n2);
    }

    public static double npv(double r2, double[] cfs) {
        double r1;
        double npv = 0.0;
        double trate = r1 = r2 + 1.0;
        for (double cf : cfs) {
            npv += cf / trate;
            trate *= r1;
        }
        return npv;
    }

    public static double pmt(double r2, double n2, double p2, double f2, boolean t) {
        if (r2 == 0.0) {
            return -1.0 * (f2 + p2) / n2;
        }
        double r1 = r2 + 1.0;
        return (f2 + p2 * Math.pow(r1, n2)) * r2 / ((t ? r1 : 1.0) * (1.0 - Math.pow(r1, n2)));
    }

    public static double nper(double r2, double y, double p2, double f2, boolean t) {
        if (r2 == 0.0) {
            return -1.0 * (f2 + p2) / y;
        }
        double r1 = r2 + 1.0;
        double ryr = (t ? r1 : 1.0) * y / r2;
        double a1 = ryr - f2 < 0.0 ? Math.log(f2 - ryr) : Math.log(ryr - f2);
        double a2 = ryr - f2 < 0.0 ? Math.log(-p2 - ryr) : Math.log(p2 + ryr);
        double a3 = Math.log(r1);
        return (a1 - a2) / a3;
    }
}

