/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.CountUtils;
import org.apache.poi.ss.formula.functions.Countif;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

abstract class Baseifs
implements FreeRefFunction {
    Baseifs() {
    }

    protected abstract boolean hasInitialRange();

    protected abstract Aggregator createAggregator();

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        int firstCriteria;
        boolean hasInitialRange = this.hasInitialRange();
        int n2 = firstCriteria = hasInitialRange ? 1 : 0;
        if (args.length < 2 + firstCriteria || args.length % 2 != firstCriteria) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            AreaEval sumRange = null;
            if (hasInitialRange) {
                sumRange = Baseifs.convertRangeArg(args[0]);
            }
            AreaEval[] ae = new AreaEval[(args.length - firstCriteria) / 2];
            CountUtils.I_MatchPredicate[] mp = new CountUtils.I_MatchPredicate[ae.length];
            int i2 = firstCriteria;
            int k2 = 0;
            while (i2 < args.length) {
                ae[k2] = Baseifs.convertRangeArg(args[i2]);
                mp[k2] = Countif.createCriteriaPredicate(args[i2 + 1], ec.getRowIndex(), ec.getColumnIndex());
                i2 += 2;
                ++k2;
            }
            Baseifs.validateCriteriaRanges(sumRange, ae);
            Baseifs.validateCriteria(mp);
            return Baseifs.aggregateMatchingCells(this.createAggregator(), sumRange, ae, mp);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    private static void validateCriteriaRanges(AreaEval sumRange, AreaEval[] criteriaRanges) throws EvaluationException {
        int h2 = criteriaRanges[0].getHeight();
        int w = criteriaRanges[0].getWidth();
        if (sumRange != null && (sumRange.getHeight() != h2 || sumRange.getWidth() != w)) {
            throw EvaluationException.invalidValue();
        }
        for (AreaEval r2 : criteriaRanges) {
            if (r2.getHeight() == h2 && r2.getWidth() == w) continue;
            throw EvaluationException.invalidValue();
        }
    }

    private static void validateCriteria(CountUtils.I_MatchPredicate[] criteria) throws EvaluationException {
        for (CountUtils.I_MatchPredicate predicate : criteria) {
            if (!(predicate instanceof Countif.ErrorMatcher)) continue;
            throw new EvaluationException(ErrorEval.valueOf(((Countif.ErrorMatcher)predicate).getValue()));
        }
    }

    private static ValueEval aggregateMatchingCells(Aggregator aggregator, AreaEval sumRange, AreaEval[] ranges, CountUtils.I_MatchPredicate[] predicates) throws EvaluationException {
        int height = ranges[0].getHeight();
        int width = ranges[0].getWidth();
        for (int r2 = 0; r2 < height; ++r2) {
            for (int c2 = 0; c2 < width; ++c2) {
                boolean matches = true;
                for (int i2 = 0; i2 < ranges.length; ++i2) {
                    AreaEval aeRange = ranges[i2];
                    CountUtils.I_MatchPredicate mp = predicates[i2];
                    if (mp != null && mp.matches(aeRange.getRelativeValue(r2, c2))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                if (sumRange != null) {
                    ValueEval value = sumRange.getRelativeValue(r2, c2);
                    if (value instanceof ErrorEval) {
                        throw new EvaluationException((ErrorEval)value);
                    }
                    aggregator.addValue(value);
                    continue;
                }
                aggregator.addValue(null);
            }
        }
        return aggregator.getResult();
    }

    protected static AreaEval convertRangeArg(ValueEval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    protected static interface Aggregator {
        public void addValue(ValueEval var1);

        public ValueEval getResult();
    }
}

