/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.chart.AreaFormatRecord;
import org.apache.poi.hssf.record.chart.AxisLineFormatRecord;
import org.apache.poi.hssf.record.chart.AxisOptionsRecord;
import org.apache.poi.hssf.record.chart.AxisParentRecord;
import org.apache.poi.hssf.record.chart.AxisRecord;
import org.apache.poi.hssf.record.chart.AxisUsedRecord;
import org.apache.poi.hssf.record.chart.BarRecord;
import org.apache.poi.hssf.record.chart.BeginRecord;
import org.apache.poi.hssf.record.chart.CategorySeriesAxisRecord;
import org.apache.poi.hssf.record.chart.ChartFormatRecord;
import org.apache.poi.hssf.record.chart.ChartRecord;
import org.apache.poi.hssf.record.chart.ChartTitleFormatRecord;
import org.apache.poi.hssf.record.chart.DataFormatRecord;
import org.apache.poi.hssf.record.chart.DefaultDataLabelTextPropertiesRecord;
import org.apache.poi.hssf.record.chart.EndRecord;
import org.apache.poi.hssf.record.chart.FontBasisRecord;
import org.apache.poi.hssf.record.chart.FontIndexRecord;
import org.apache.poi.hssf.record.chart.FrameRecord;
import org.apache.poi.hssf.record.chart.LegendRecord;
import org.apache.poi.hssf.record.chart.LineFormatRecord;
import org.apache.poi.hssf.record.chart.LinkedDataRecord;
import org.apache.poi.hssf.record.chart.PlotAreaRecord;
import org.apache.poi.hssf.record.chart.PlotGrowthRecord;
import org.apache.poi.hssf.record.chart.SeriesChartGroupIndexRecord;
import org.apache.poi.hssf.record.chart.SeriesIndexRecord;
import org.apache.poi.hssf.record.chart.SeriesRecord;
import org.apache.poi.hssf.record.chart.SeriesTextRecord;
import org.apache.poi.hssf.record.chart.SheetPropertiesRecord;
import org.apache.poi.hssf.record.chart.TextRecord;
import org.apache.poi.hssf.record.chart.TickRecord;
import org.apache.poi.hssf.record.chart.UnitsRecord;
import org.apache.poi.hssf.record.chart.ValueRangeRecord;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.AreaPtgBase;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressBase;

public final class HSSFChart {
    private HSSFSheet sheet;
    private ChartRecord chartRecord;
    private LegendRecord legendRecord;
    private ChartTitleFormatRecord chartTitleFormat;
    private SeriesTextRecord chartTitleText;
    private List<ValueRangeRecord> valueRanges = new ArrayList<ValueRangeRecord>();
    private HSSFChartType type = HSSFChartType.Unknown;
    private List<HSSFSeries> series = new ArrayList<HSSFSeries>();

    private HSSFChart(HSSFSheet sheet, ChartRecord chartRecord) {
        this.chartRecord = chartRecord;
        this.sheet = sheet;
    }

    public void createBarChart(HSSFWorkbook workbook, HSSFSheet parentSheet) {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(this.createMSDrawingObjectRecord());
        records.add(this.createOBJRecord());
        records.add(this.createBOFRecord());
        records.add(new HeaderRecord(""));
        records.add(new FooterRecord(""));
        records.add(this.createHCenterRecord());
        records.add(this.createVCenterRecord());
        records.add(this.createPrintSetupRecord());
        records.add(this.createFontBasisRecord1());
        records.add(this.createFontBasisRecord2());
        records.add(new ProtectRecord(false));
        records.add(this.createUnitsRecord());
        records.add(this.createChartRecord(0, 0, 30434904, 19031616));
        records.add(this.createBeginRecord());
        records.add(this.createSCLRecord((short)1, (short)1));
        records.add(this.createPlotGrowthRecord(65536, 65536));
        records.add(this.createFrameRecord1());
        records.add(this.createBeginRecord());
        records.add(this.createLineFormatRecord(true));
        records.add(this.createAreaFormatRecord1());
        records.add(this.createEndRecord());
        records.add(this.createSeriesRecord());
        records.add(this.createBeginRecord());
        records.add(this.createTitleLinkedDataRecord());
        records.add(this.createValuesLinkedDataRecord());
        records.add(this.createCategoriesLinkedDataRecord());
        records.add(this.createDataFormatRecord());
        records.add(this.createSeriesToChartGroupRecord());
        records.add(this.createEndRecord());
        records.add(this.createSheetPropsRecord());
        records.add(this.createDefaultTextRecord((short)2));
        records.add(this.createAllTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createFontIndexRecord(5));
        records.add(this.createDirectLinkRecord());
        records.add(this.createEndRecord());
        records.add(this.createDefaultTextRecord((short)3));
        records.add(this.createUnknownTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createFontIndexRecord(6));
        records.add(this.createDirectLinkRecord());
        records.add(this.createEndRecord());
        records.add(this.createAxisUsedRecord((short)1));
        this.createAxisRecords(records);
        records.add(this.createEndRecord());
        records.add(this.createDimensionsRecord());
        records.add(this.createSeriesIndexRecord(2));
        records.add(this.createSeriesIndexRecord(1));
        records.add(this.createSeriesIndexRecord(3));
        records.add(EOFRecord.instance);
        parentSheet.insertChartRecords(records);
        workbook.insertChartRecord();
    }

    public static HSSFChart[] getSheetCharts(HSSFSheet sheet) {
        ArrayList<HSSFChart> charts = new ArrayList<HSSFChart>();
        HSSFChart lastChart = null;
        HSSFSeries lastSeries = null;
        List<RecordBase> records = sheet.getSheet().getRecords();
        block0: for (RecordBase r2 : records) {
            if (r2 instanceof ChartRecord) {
                lastSeries = null;
                lastChart = new HSSFChart(sheet, (ChartRecord)r2);
                charts.add(lastChart);
            } else if (r2 instanceof LinkedDataRecord) {
                LinkedDataRecord linkedDataRecord = (LinkedDataRecord)r2;
                if (lastSeries != null) {
                    lastSeries.insertData(linkedDataRecord);
                }
            }
            if (lastChart == null) continue;
            if (r2 instanceof LegendRecord) {
                lastChart.legendRecord = (LegendRecord)r2;
                continue;
            }
            if (r2 instanceof SeriesRecord) {
                HSSFSeries series = new HSSFSeries((SeriesRecord)r2);
                lastChart.series.add(series);
                lastSeries = series;
                continue;
            }
            if (r2 instanceof ChartTitleFormatRecord) {
                lastChart.chartTitleFormat = (ChartTitleFormatRecord)r2;
                continue;
            }
            if (r2 instanceof SeriesTextRecord) {
                SeriesTextRecord str = (SeriesTextRecord)r2;
                if (lastChart.legendRecord == null && !lastChart.series.isEmpty()) {
                    HSSFSeries series = lastChart.series.get(lastChart.series.size() - 1);
                    series.seriesTitleText = str;
                    continue;
                }
                lastChart.chartTitleText = str;
                continue;
            }
            if (r2 instanceof ValueRangeRecord) {
                lastChart.valueRanges.add((ValueRangeRecord)r2);
                continue;
            }
            if (!(r2 instanceof Record)) continue;
            Record record = (Record)r2;
            for (HSSFChartType type : HSSFChartType.values()) {
                if (type == HSSFChartType.Unknown || record.getSid() != type.getSid()) continue;
                lastChart.type = type;
                continue block0;
            }
        }
        return charts.toArray(new HSSFChart[0]);
    }

    public int getChartX() {
        return this.chartRecord.getX();
    }

    public int getChartY() {
        return this.chartRecord.getY();
    }

    public int getChartWidth() {
        return this.chartRecord.getWidth();
    }

    public int getChartHeight() {
        return this.chartRecord.getHeight();
    }

    public void setChartX(int x) {
        this.chartRecord.setX(x);
    }

    public void setChartY(int y) {
        this.chartRecord.setY(y);
    }

    public void setChartWidth(int width) {
        this.chartRecord.setWidth(width);
    }

    public void setChartHeight(int height) {
        this.chartRecord.setHeight(height);
    }

    public HSSFSeries[] getSeries() {
        return this.series.toArray(new HSSFSeries[0]);
    }

    public String getChartTitle() {
        if (this.chartTitleText != null) {
            return this.chartTitleText.getText();
        }
        return null;
    }

    public void setChartTitle(String title) {
        if (this.chartTitleText == null) {
            throw new IllegalStateException("No chart title found to change");
        }
        this.chartTitleText.setText(title);
    }

    public void setValueRange(int axisIndex, Double minimum, Double maximum, Double majorUnit, Double minorUnit) {
        ValueRangeRecord valueRange = this.valueRanges.get(axisIndex);
        if (valueRange == null) {
            return;
        }
        if (minimum != null) {
            valueRange.setAutomaticMinimum(minimum.isNaN());
            valueRange.setMinimumAxisValue(minimum);
        }
        if (maximum != null) {
            valueRange.setAutomaticMaximum(maximum.isNaN());
            valueRange.setMaximumAxisValue(maximum);
        }
        if (majorUnit != null) {
            valueRange.setAutomaticMajor(majorUnit.isNaN());
            valueRange.setMajorIncrement(majorUnit);
        }
        if (minorUnit != null) {
            valueRange.setAutomaticMinor(minorUnit.isNaN());
            valueRange.setMinorIncrement(minorUnit);
        }
    }

    private SeriesIndexRecord createSeriesIndexRecord(int index) {
        SeriesIndexRecord r2 = new SeriesIndexRecord();
        r2.setIndex((short)index);
        return r2;
    }

    private DimensionsRecord createDimensionsRecord() {
        DimensionsRecord r2 = new DimensionsRecord();
        r2.setFirstRow(0);
        r2.setLastRow(31);
        r2.setFirstCol((short)0);
        r2.setLastCol((short)1);
        return r2;
    }

    private HCenterRecord createHCenterRecord() {
        HCenterRecord r2 = new HCenterRecord();
        r2.setHCenter(false);
        return r2;
    }

    private VCenterRecord createVCenterRecord() {
        VCenterRecord r2 = new VCenterRecord();
        r2.setVCenter(false);
        return r2;
    }

    private PrintSetupRecord createPrintSetupRecord() {
        PrintSetupRecord r2 = new PrintSetupRecord();
        r2.setPaperSize((short)0);
        r2.setScale((short)18);
        r2.setPageStart((short)1);
        r2.setFitWidth((short)1);
        r2.setFitHeight((short)1);
        r2.setLeftToRight(false);
        r2.setLandscape(false);
        r2.setValidSettings(true);
        r2.setNoColor(false);
        r2.setDraft(false);
        r2.setNotes(false);
        r2.setNoOrientation(false);
        r2.setUsePage(false);
        r2.setHResolution((short)0);
        r2.setVResolution((short)0);
        r2.setHeaderMargin(0.5);
        r2.setFooterMargin(0.5);
        r2.setCopies((short)15);
        return r2;
    }

    private FontBasisRecord createFontBasisRecord1() {
        FontBasisRecord r2 = new FontBasisRecord();
        r2.setXBasis((short)9120);
        r2.setYBasis((short)5640);
        r2.setHeightBasis((short)200);
        r2.setScale((short)0);
        r2.setIndexToFontTable((short)5);
        return r2;
    }

    private FontBasisRecord createFontBasisRecord2() {
        FontBasisRecord r2 = this.createFontBasisRecord1();
        r2.setIndexToFontTable((short)6);
        return r2;
    }

    private BOFRecord createBOFRecord() {
        BOFRecord r2 = new BOFRecord();
        r2.setVersion(600);
        r2.setType(20);
        r2.setBuild(7422);
        r2.setBuildYear(1997);
        r2.setHistoryBitMask(16585);
        r2.setRequiredVersion(106);
        return r2;
    }

    private UnknownRecord createOBJRecord() {
        byte[] data = new byte[]{21, 0, 18, 0, 5, 0, 2, 0, 17, 96, 0, 0, 0, 0, -72, 3, -121, 3, 0, 0, 0, 0, 0, 0, 0, 0};
        return new UnknownRecord(93, data);
    }

    private UnknownRecord createMSDrawingObjectRecord() {
        byte[] data = new byte[]{15, 0, 2, -16, -64, 0, 0, 0, 16, 0, 8, -16, 8, 0, 0, 0, 2, 0, 0, 0, 2, 4, 0, 0, 15, 0, 3, -16, -88, 0, 0, 0, 15, 0, 4, -16, 40, 0, 0, 0, 1, 0, 9, -16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 10, -16, 8, 0, 0, 0, 0, 4, 0, 0, 5, 0, 0, 0, 15, 0, 4, -16, 112, 0, 0, 0, -110, 12, 10, -16, 8, 0, 0, 0, 2, 4, 0, 0, 0, 10, 0, 0, -109, 0, 11, -16, 54, 0, 0, 0, 127, 0, 4, 1, 4, 1, -65, 0, 8, 0, 8, 0, -127, 1, 78, 0, 0, 8, -125, 1, 77, 0, 0, 8, -65, 1, 16, 0, 17, 0, -64, 1, 77, 0, 0, 8, -1, 1, 8, 0, 8, 0, 63, 2, 0, 0, 2, 0, -65, 3, 0, 0, 8, 0, 0, 0, 16, -16, 18, 0, 0, 0, 0, 0, 4, 0, -64, 2, 10, 0, -12, 0, 14, 0, 102, 1, 32, 0, -23, 0, 0, 0, 17, -16, 0, 0, 0, 0};
        return new UnknownRecord(236, data);
    }

    private void createAxisRecords(List<Record> records) {
        records.add(this.createAxisParentRecord());
        records.add(this.createBeginRecord());
        records.add(this.createAxisRecord((short)0));
        records.add(this.createBeginRecord());
        records.add(this.createCategorySeriesAxisRecord());
        records.add(this.createAxisOptionsRecord());
        records.add(this.createTickRecord1());
        records.add(this.createEndRecord());
        records.add(this.createAxisRecord((short)1));
        records.add(this.createBeginRecord());
        records.add(this.createValueRangeRecord());
        records.add(this.createTickRecord2());
        records.add(this.createAxisLineFormatRecord((short)1));
        records.add(this.createLineFormatRecord(false));
        records.add(this.createEndRecord());
        records.add(this.createPlotAreaRecord());
        records.add(this.createFrameRecord2());
        records.add(this.createBeginRecord());
        records.add(this.createLineFormatRecord2());
        records.add(this.createAreaFormatRecord2());
        records.add(this.createEndRecord());
        records.add(this.createChartFormatRecord());
        records.add(this.createBeginRecord());
        records.add(this.createBarRecord());
        records.add(this.createLegendRecord());
        records.add(this.createBeginRecord());
        records.add(this.createTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createLinkedDataRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
    }

    private LinkedDataRecord createLinkedDataRecord() {
        LinkedDataRecord r2 = new LinkedDataRecord();
        r2.setLinkType((byte)0);
        r2.setReferenceType((byte)1);
        r2.setCustomNumberFormat(false);
        r2.setIndexNumberFmtRecord((short)0);
        r2.setFormulaOfLink(null);
        return r2;
    }

    private TextRecord createTextRecord() {
        TextRecord r2 = new TextRecord();
        r2.setHorizontalAlignment((byte)2);
        r2.setVerticalAlignment((byte)2);
        r2.setDisplayMode((short)1);
        r2.setRgbColor(0);
        r2.setX(-37);
        r2.setY(-60);
        r2.setWidth(0);
        r2.setHeight(0);
        r2.setAutoColor(true);
        r2.setShowKey(false);
        r2.setShowValue(false);
        r2.setVertical(false);
        r2.setAutoGeneratedText(true);
        r2.setGenerated(true);
        r2.setAutoLabelDeleted(false);
        r2.setAutoBackground(true);
        r2.setRotation((short)0);
        r2.setShowCategoryLabelAsPercentage(false);
        r2.setShowValueAsPercentage(false);
        r2.setShowBubbleSizes(false);
        r2.setShowLabel(false);
        r2.setIndexOfColorValue((short)77);
        r2.setDataLabelPlacement((short)0);
        r2.setTextRotation((short)0);
        return r2;
    }

    private LegendRecord createLegendRecord() {
        LegendRecord r2 = new LegendRecord();
        r2.setXAxisUpperLeft(3542);
        r2.setYAxisUpperLeft(1566);
        r2.setXSize(437);
        r2.setYSize(213);
        r2.setType((byte)3);
        r2.setSpacing((byte)1);
        r2.setAutoPosition(true);
        r2.setAutoSeries(true);
        r2.setAutoXPositioning(true);
        r2.setAutoYPositioning(true);
        r2.setVertical(true);
        r2.setDataTable(false);
        return r2;
    }

    private BarRecord createBarRecord() {
        BarRecord r2 = new BarRecord();
        r2.setBarSpace((short)0);
        r2.setCategorySpace((short)150);
        r2.setHorizontal(false);
        r2.setStacked(false);
        r2.setDisplayAsPercentage(false);
        r2.setShadow(false);
        return r2;
    }

    private ChartFormatRecord createChartFormatRecord() {
        ChartFormatRecord r2 = new ChartFormatRecord();
        r2.setXPosition(0);
        r2.setYPosition(0);
        r2.setWidth(0);
        r2.setHeight(0);
        r2.setVaryDisplayPattern(false);
        return r2;
    }

    private PlotAreaRecord createPlotAreaRecord() {
        return new PlotAreaRecord();
    }

    private AxisLineFormatRecord createAxisLineFormatRecord(short format) {
        AxisLineFormatRecord r2 = new AxisLineFormatRecord();
        r2.setAxisType(format);
        return r2;
    }

    private ValueRangeRecord createValueRangeRecord() {
        ValueRangeRecord r2 = new ValueRangeRecord();
        r2.setMinimumAxisValue(0.0);
        r2.setMaximumAxisValue(0.0);
        r2.setMajorIncrement(0.0);
        r2.setMinorIncrement(0.0);
        r2.setCategoryAxisCross(0.0);
        r2.setAutomaticMinimum(true);
        r2.setAutomaticMaximum(true);
        r2.setAutomaticMajor(true);
        r2.setAutomaticMinor(true);
        r2.setAutomaticCategoryCrossing(true);
        r2.setLogarithmicScale(false);
        r2.setValuesInReverse(false);
        r2.setCrossCategoryAxisAtMaximum(false);
        r2.setReserved(true);
        return r2;
    }

    private TickRecord createTickRecord1() {
        TickRecord r2 = new TickRecord();
        r2.setMajorTickType((byte)2);
        r2.setMinorTickType((byte)0);
        r2.setLabelPosition((byte)3);
        r2.setBackground((byte)1);
        r2.setLabelColorRgb(0);
        r2.setZero1(0);
        r2.setZero2(0);
        r2.setZero3((short)45);
        r2.setAutorotate(true);
        r2.setAutoTextBackground(true);
        r2.setRotation((short)0);
        r2.setAutorotate(true);
        r2.setTickColor((short)77);
        return r2;
    }

    private TickRecord createTickRecord2() {
        TickRecord r2 = this.createTickRecord1();
        r2.setZero3((short)0);
        return r2;
    }

    private AxisOptionsRecord createAxisOptionsRecord() {
        AxisOptionsRecord r2 = new AxisOptionsRecord();
        r2.setMinimumCategory((short)-28644);
        r2.setMaximumCategory((short)-28715);
        r2.setMajorUnitValue((short)2);
        r2.setMajorUnit((short)0);
        r2.setMinorUnitValue((short)1);
        r2.setMinorUnit((short)0);
        r2.setBaseUnit((short)0);
        r2.setCrossingPoint((short)-28644);
        r2.setDefaultMinimum(true);
        r2.setDefaultMaximum(true);
        r2.setDefaultMajor(true);
        r2.setDefaultMinorUnit(true);
        r2.setIsDate(true);
        r2.setDefaultBase(true);
        r2.setDefaultCross(true);
        r2.setDefaultDateSettings(true);
        return r2;
    }

    private CategorySeriesAxisRecord createCategorySeriesAxisRecord() {
        CategorySeriesAxisRecord r2 = new CategorySeriesAxisRecord();
        r2.setCrossingPoint((short)1);
        r2.setLabelFrequency((short)1);
        r2.setTickMarkFrequency((short)1);
        r2.setValueAxisCrossing(true);
        r2.setCrossesFarRight(false);
        r2.setReversed(false);
        return r2;
    }

    private AxisRecord createAxisRecord(short axisType) {
        AxisRecord r2 = new AxisRecord();
        r2.setAxisType(axisType);
        return r2;
    }

    private AxisParentRecord createAxisParentRecord() {
        AxisParentRecord r2 = new AxisParentRecord();
        r2.setAxisType((short)0);
        r2.setX(479);
        r2.setY(221);
        r2.setWidth(2995);
        r2.setHeight(2902);
        return r2;
    }

    private AxisUsedRecord createAxisUsedRecord(short numAxis) {
        AxisUsedRecord r2 = new AxisUsedRecord();
        r2.setNumAxis(numAxis);
        return r2;
    }

    private LinkedDataRecord createDirectLinkRecord() {
        LinkedDataRecord r2 = new LinkedDataRecord();
        r2.setLinkType((byte)0);
        r2.setReferenceType((byte)1);
        r2.setCustomNumberFormat(false);
        r2.setIndexNumberFmtRecord((short)0);
        r2.setFormulaOfLink(null);
        return r2;
    }

    private FontIndexRecord createFontIndexRecord(int index) {
        FontIndexRecord r2 = new FontIndexRecord();
        r2.setFontIndex((short)index);
        return r2;
    }

    private TextRecord createAllTextRecord() {
        TextRecord r2 = new TextRecord();
        r2.setHorizontalAlignment((byte)2);
        r2.setVerticalAlignment((byte)2);
        r2.setDisplayMode((short)1);
        r2.setRgbColor(0);
        r2.setX(-37);
        r2.setY(-60);
        r2.setWidth(0);
        r2.setHeight(0);
        r2.setAutoColor(true);
        r2.setShowKey(false);
        r2.setShowValue(true);
        r2.setVertical(false);
        r2.setAutoGeneratedText(true);
        r2.setGenerated(true);
        r2.setAutoLabelDeleted(false);
        r2.setAutoBackground(true);
        r2.setRotation((short)0);
        r2.setShowCategoryLabelAsPercentage(false);
        r2.setShowValueAsPercentage(false);
        r2.setShowBubbleSizes(false);
        r2.setShowLabel(false);
        r2.setIndexOfColorValue((short)77);
        r2.setDataLabelPlacement((short)0);
        r2.setTextRotation((short)0);
        return r2;
    }

    private TextRecord createUnknownTextRecord() {
        TextRecord r2 = new TextRecord();
        r2.setHorizontalAlignment((byte)2);
        r2.setVerticalAlignment((byte)2);
        r2.setDisplayMode((short)1);
        r2.setRgbColor(0);
        r2.setX(-37);
        r2.setY(-60);
        r2.setWidth(0);
        r2.setHeight(0);
        r2.setAutoColor(true);
        r2.setShowKey(false);
        r2.setShowValue(false);
        r2.setVertical(false);
        r2.setAutoGeneratedText(true);
        r2.setGenerated(true);
        r2.setAutoLabelDeleted(false);
        r2.setAutoBackground(true);
        r2.setRotation((short)0);
        r2.setShowCategoryLabelAsPercentage(false);
        r2.setShowValueAsPercentage(false);
        r2.setShowBubbleSizes(false);
        r2.setShowLabel(false);
        r2.setIndexOfColorValue((short)77);
        r2.setDataLabelPlacement((short)11088);
        r2.setTextRotation((short)0);
        return r2;
    }

    private DefaultDataLabelTextPropertiesRecord createDefaultTextRecord(short categoryDataType) {
        DefaultDataLabelTextPropertiesRecord r2 = new DefaultDataLabelTextPropertiesRecord();
        r2.setCategoryDataType(categoryDataType);
        return r2;
    }

    private SheetPropertiesRecord createSheetPropsRecord() {
        SheetPropertiesRecord r2 = new SheetPropertiesRecord();
        r2.setChartTypeManuallyFormatted(false);
        r2.setPlotVisibleOnly(true);
        r2.setDoNotSizeWithWindow(false);
        r2.setDefaultPlotDimensions(true);
        r2.setAutoPlotArea(false);
        return r2;
    }

    private SeriesChartGroupIndexRecord createSeriesToChartGroupRecord() {
        return new SeriesChartGroupIndexRecord();
    }

    private DataFormatRecord createDataFormatRecord() {
        DataFormatRecord r2 = new DataFormatRecord();
        r2.setPointNumber((short)-1);
        r2.setSeriesIndex((short)0);
        r2.setSeriesNumber((short)0);
        r2.setUseExcel4Colors(false);
        return r2;
    }

    private LinkedDataRecord createCategoriesLinkedDataRecord() {
        LinkedDataRecord r2 = new LinkedDataRecord();
        r2.setLinkType((byte)2);
        r2.setReferenceType((byte)2);
        r2.setCustomNumberFormat(false);
        r2.setIndexNumberFmtRecord((short)0);
        Area3DPtg p2 = new Area3DPtg(0, 31, 1, 1, false, false, false, false, 0);
        r2.setFormulaOfLink(new Ptg[]{p2});
        return r2;
    }

    private LinkedDataRecord createValuesLinkedDataRecord() {
        LinkedDataRecord r2 = new LinkedDataRecord();
        r2.setLinkType((byte)1);
        r2.setReferenceType((byte)2);
        r2.setCustomNumberFormat(false);
        r2.setIndexNumberFmtRecord((short)0);
        Area3DPtg p2 = new Area3DPtg(0, 31, 0, 0, false, false, false, false, 0);
        r2.setFormulaOfLink(new Ptg[]{p2});
        return r2;
    }

    private LinkedDataRecord createTitleLinkedDataRecord() {
        LinkedDataRecord r2 = new LinkedDataRecord();
        r2.setLinkType((byte)0);
        r2.setReferenceType((byte)1);
        r2.setCustomNumberFormat(false);
        r2.setIndexNumberFmtRecord((short)0);
        r2.setFormulaOfLink(null);
        return r2;
    }

    private SeriesRecord createSeriesRecord() {
        SeriesRecord r2 = new SeriesRecord();
        r2.setCategoryDataType((short)1);
        r2.setValuesDataType((short)1);
        r2.setNumCategories((short)32);
        r2.setNumValues((short)31);
        r2.setBubbleSeriesType((short)1);
        r2.setNumBubbleValues((short)0);
        return r2;
    }

    private EndRecord createEndRecord() {
        return new EndRecord();
    }

    private AreaFormatRecord createAreaFormatRecord1() {
        AreaFormatRecord r2 = new AreaFormatRecord();
        r2.setForegroundColor(0xFFFFFF);
        r2.setBackgroundColor(0);
        r2.setPattern((short)1);
        r2.setAutomatic(true);
        r2.setInvert(false);
        r2.setForecolorIndex((short)78);
        r2.setBackcolorIndex((short)77);
        return r2;
    }

    private AreaFormatRecord createAreaFormatRecord2() {
        AreaFormatRecord r2 = new AreaFormatRecord();
        r2.setForegroundColor(0xC0C0C0);
        r2.setBackgroundColor(0);
        r2.setPattern((short)1);
        r2.setAutomatic(false);
        r2.setInvert(false);
        r2.setForecolorIndex((short)22);
        r2.setBackcolorIndex((short)79);
        return r2;
    }

    private LineFormatRecord createLineFormatRecord(boolean drawTicks) {
        LineFormatRecord r2 = new LineFormatRecord();
        r2.setLineColor(0);
        r2.setLinePattern((short)0);
        r2.setWeight((short)-1);
        r2.setAuto(true);
        r2.setDrawTicks(drawTicks);
        r2.setColourPaletteIndex((short)77);
        return r2;
    }

    private LineFormatRecord createLineFormatRecord2() {
        LineFormatRecord r2 = new LineFormatRecord();
        r2.setLineColor(0x808080);
        r2.setLinePattern((short)0);
        r2.setWeight((short)0);
        r2.setAuto(false);
        r2.setDrawTicks(false);
        r2.setUnknown(false);
        r2.setColourPaletteIndex((short)23);
        return r2;
    }

    private FrameRecord createFrameRecord1() {
        FrameRecord r2 = new FrameRecord();
        r2.setBorderType((short)0);
        r2.setAutoSize(false);
        r2.setAutoPosition(true);
        return r2;
    }

    private FrameRecord createFrameRecord2() {
        FrameRecord r2 = new FrameRecord();
        r2.setBorderType((short)0);
        r2.setAutoSize(true);
        r2.setAutoPosition(true);
        return r2;
    }

    private PlotGrowthRecord createPlotGrowthRecord(int horizScale, int vertScale) {
        PlotGrowthRecord r2 = new PlotGrowthRecord();
        r2.setHorizontalScale(horizScale);
        r2.setVerticalScale(vertScale);
        return r2;
    }

    private SCLRecord createSCLRecord(short numerator, short denominator) {
        SCLRecord r2 = new SCLRecord();
        r2.setDenominator(denominator);
        r2.setNumerator(numerator);
        return r2;
    }

    private BeginRecord createBeginRecord() {
        return new BeginRecord();
    }

    private ChartRecord createChartRecord(int x, int y, int width, int height) {
        ChartRecord r2 = new ChartRecord();
        r2.setX(x);
        r2.setY(y);
        r2.setWidth(width);
        r2.setHeight(height);
        return r2;
    }

    private UnitsRecord createUnitsRecord() {
        UnitsRecord r2 = new UnitsRecord();
        r2.setUnits((short)0);
        return r2;
    }

    public HSSFSeries createSeries() throws Exception {
        ArrayList<RecordBase> seriesTemplate = new ArrayList<RecordBase>();
        boolean seriesTemplateFilled = false;
        int idx = 0;
        int deep = 0;
        int chartRecordIdx = -1;
        int chartDeep = -1;
        int lastSeriesDeep = -1;
        int endSeriesRecordIdx = -1;
        int seriesIdx = 0;
        List<RecordBase> records = this.sheet.getSheet().getRecords();
        for (RecordBase record : records) {
            ++idx;
            if (record instanceof BeginRecord) {
                ++deep;
            } else if (record instanceof EndRecord) {
                if (lastSeriesDeep == --deep) {
                    lastSeriesDeep = -1;
                    endSeriesRecordIdx = idx;
                    if (!seriesTemplateFilled) {
                        seriesTemplate.add(record);
                        seriesTemplateFilled = true;
                    }
                }
                if (chartDeep == deep) break;
            }
            if (record instanceof ChartRecord) {
                if (record == this.chartRecord) {
                    chartRecordIdx = idx;
                    chartDeep = deep;
                }
            } else if (record instanceof SeriesRecord && chartRecordIdx != -1) {
                ++seriesIdx;
                lastSeriesDeep = deep;
            }
            if (lastSeriesDeep == -1 || seriesTemplateFilled) continue;
            seriesTemplate.add(record);
        }
        if (endSeriesRecordIdx == -1) {
            return null;
        }
        idx = endSeriesRecordIdx + 1;
        HSSFSeries newSeries = null;
        ArrayList<BeginRecord> clonedRecords = new ArrayList<BeginRecord>();
        for (RecordBase recordBase : seriesTemplate) {
            Record newRecord = null;
            if (recordBase instanceof BeginRecord) {
                newRecord = new BeginRecord();
            } else if (recordBase instanceof EndRecord) {
                newRecord = new EndRecord();
            } else if (recordBase instanceof SeriesRecord) {
                SeriesRecord seriesRecord = ((SeriesRecord)recordBase).copy();
                newSeries = new HSSFSeries(seriesRecord);
                newRecord = seriesRecord;
            } else if (recordBase instanceof LinkedDataRecord) {
                LinkedDataRecord linkedDataRecord = ((LinkedDataRecord)recordBase).copy();
                if (newSeries != null) {
                    newSeries.insertData(linkedDataRecord);
                }
                newRecord = linkedDataRecord;
            } else if (recordBase instanceof DataFormatRecord) {
                DataFormatRecord dataFormatRecord = ((DataFormatRecord)recordBase).copy();
                dataFormatRecord.setSeriesIndex((short)seriesIdx);
                dataFormatRecord.setSeriesNumber((short)seriesIdx);
                newRecord = dataFormatRecord;
            } else if (recordBase instanceof SeriesTextRecord) {
                SeriesTextRecord seriesTextRecord = ((SeriesTextRecord)recordBase).copy();
                if (newSeries != null) {
                    newSeries.setSeriesTitleText(seriesTextRecord);
                }
                newRecord = seriesTextRecord;
            } else if (recordBase instanceof Record) {
                newRecord = ((Record)recordBase).copy();
            }
            if (newRecord == null) continue;
            clonedRecords.add((BeginRecord)newRecord);
        }
        if (newSeries == null) {
            return null;
        }
        for (RecordBase recordBase : clonedRecords) {
            records.add(idx++, recordBase);
        }
        return newSeries;
    }

    public boolean removeSeries(HSSFSeries remSeries) {
        int deep = 0;
        int chartDeep = -1;
        int lastSeriesDeep = -1;
        int seriesIdx = -1;
        boolean removeSeries = false;
        boolean chartEntered = false;
        boolean result = false;
        List<RecordBase> records = this.sheet.getSheet().getRecords();
        Iterator<RecordBase> iter = records.iterator();
        while (iter.hasNext()) {
            RecordBase record = iter.next();
            if (record instanceof BeginRecord) {
                ++deep;
            } else if (record instanceof EndRecord) {
                if (lastSeriesDeep == --deep) {
                    lastSeriesDeep = -1;
                    if (removeSeries) {
                        removeSeries = false;
                        result = true;
                        iter.remove();
                    }
                }
                if (chartDeep == deep) break;
            }
            if (record instanceof ChartRecord) {
                if (record == this.chartRecord) {
                    chartDeep = deep;
                    chartEntered = true;
                }
            } else if (record instanceof SeriesRecord) {
                if (chartEntered) {
                    if (remSeries.series == record) {
                        lastSeriesDeep = deep;
                        removeSeries = true;
                    } else {
                        ++seriesIdx;
                    }
                }
            } else if (record instanceof DataFormatRecord && chartEntered && !removeSeries) {
                DataFormatRecord dataFormatRecord = (DataFormatRecord)record;
                dataFormatRecord.setSeriesIndex((short)seriesIdx);
                dataFormatRecord.setSeriesNumber((short)seriesIdx);
            }
            if (!removeSeries) continue;
            iter.remove();
        }
        return result;
    }

    public HSSFChartType getType() {
        return this.type;
    }

    public static class HSSFSeries {
        private SeriesRecord series;
        private SeriesTextRecord seriesTitleText;
        private LinkedDataRecord dataName;
        private LinkedDataRecord dataValues;
        private LinkedDataRecord dataCategoryLabels;
        private LinkedDataRecord dataSecondaryCategoryLabels;

        HSSFSeries(SeriesRecord series) {
            this.series = series;
        }

        void insertData(LinkedDataRecord data) {
            switch (data.getLinkType()) {
                case 0: {
                    this.dataName = data;
                    break;
                }
                case 1: {
                    this.dataValues = data;
                    break;
                }
                case 2: {
                    this.dataCategoryLabels = data;
                    break;
                }
                case 3: {
                    this.dataSecondaryCategoryLabels = data;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid link type: " + data.getLinkType());
                }
            }
        }

        void setSeriesTitleText(SeriesTextRecord seriesTitleText) {
            this.seriesTitleText = seriesTitleText;
        }

        public short getNumValues() {
            return this.series.getNumValues();
        }

        public short getValueType() {
            return this.series.getValuesDataType();
        }

        public String getSeriesTitle() {
            if (this.seriesTitleText != null) {
                return this.seriesTitleText.getText();
            }
            return null;
        }

        public void setSeriesTitle(String title) {
            if (this.seriesTitleText == null) {
                throw new IllegalStateException("No series title found to change");
            }
            this.seriesTitleText.setText(title);
        }

        public LinkedDataRecord getDataName() {
            return this.dataName;
        }

        public LinkedDataRecord getDataValues() {
            return this.dataValues;
        }

        public LinkedDataRecord getDataCategoryLabels() {
            return this.dataCategoryLabels;
        }

        public LinkedDataRecord getDataSecondaryCategoryLabels() {
            return this.dataSecondaryCategoryLabels;
        }

        public SeriesRecord getSeries() {
            return this.series;
        }

        private CellRangeAddressBase getCellRange(LinkedDataRecord linkedDataRecord) {
            if (linkedDataRecord == null) {
                return null;
            }
            int firstRow = 0;
            int lastRow = 0;
            int firstCol = 0;
            int lastCol = 0;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtg = (AreaPtgBase)ptg;
                firstRow = areaPtg.getFirstRow();
                lastRow = areaPtg.getLastRow();
                firstCol = areaPtg.getFirstColumn();
                lastCol = areaPtg.getLastColumn();
            }
            return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        }

        public CellRangeAddressBase getValuesCellRange() {
            return this.getCellRange(this.dataValues);
        }

        public CellRangeAddressBase getCategoryLabelsCellRange() {
            return this.getCellRange(this.dataCategoryLabels);
        }

        private Integer setVerticalCellRange(LinkedDataRecord linkedDataRecord, CellRangeAddressBase range) {
            if (linkedDataRecord == null) {
                return null;
            }
            ArrayList<AreaPtgBase> ptgList = new ArrayList<AreaPtgBase>();
            int rowCount = range.getLastRow() - range.getFirstRow() + 1;
            int colCount = range.getLastColumn() - range.getFirstColumn() + 1;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtg = (AreaPtgBase)ptg;
                areaPtg.setFirstRow(range.getFirstRow());
                areaPtg.setLastRow(range.getLastRow());
                areaPtg.setFirstColumn(range.getFirstColumn());
                areaPtg.setLastColumn(range.getLastColumn());
                ptgList.add(areaPtg);
            }
            linkedDataRecord.setFormulaOfLink(ptgList.toArray(new Ptg[0]));
            return rowCount * colCount;
        }

        public void setValuesCellRange(CellRangeAddressBase range) {
            Integer count = this.setVerticalCellRange(this.dataValues, range);
            if (count == null) {
                return;
            }
            this.series.setNumValues((short)count.intValue());
        }

        public void setCategoryLabelsCellRange(CellRangeAddressBase range) {
            Integer count = this.setVerticalCellRange(this.dataCategoryLabels, range);
            if (count == null) {
                return;
            }
            this.series.setNumCategories((short)count.intValue());
        }
    }

    public static enum HSSFChartType {
        Area{

            @Override
            public short getSid() {
                return 4122;
            }
        }
        ,
        Bar{

            @Override
            public short getSid() {
                return 4119;
            }
        }
        ,
        Line{

            @Override
            public short getSid() {
                return 4120;
            }
        }
        ,
        Pie{

            @Override
            public short getSid() {
                return 4121;
            }
        }
        ,
        Scatter{

            @Override
            public short getSid() {
                return 4123;
            }
        }
        ,
        Unknown{

            @Override
            public short getSid() {
                return 0;
            }
        };


        public abstract short getSid();
    }
}

