/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.util.Unbox;
import org.apache.poi.hssf.record.CFRuleBase;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import org.apache.poi.hssf.record.cf.DataBarFormatting;
import org.apache.poi.hssf.record.cf.DataBarThreshold;
import org.apache.poi.hssf.record.cf.IconMultiStateFormatting;
import org.apache.poi.hssf.record.cf.IconMultiStateThreshold;
import org.apache.poi.hssf.record.cf.Threshold;
import org.apache.poi.hssf.record.common.ExtendedColor;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.hssf.record.common.FutureRecord;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianOutput;

public final class CFRule12Record
extends CFRuleBase
implements FutureRecord {
    public static final short sid = 2170;
    private FtrHeader futureHeader;
    private int ext_formatting_length;
    private byte[] ext_formatting_data;
    private Formula formula_scale;
    private byte ext_opts;
    private int priority;
    private int template_type;
    private byte template_param_length;
    private byte[] template_params;
    private DataBarFormatting data_bar;
    private IconMultiStateFormatting multistate;
    private ColorGradientFormatting color_gradient;
    private byte[] filter_data;

    public CFRule12Record(CFRule12Record other) {
        super(other);
        this.futureHeader = other.futureHeader == null ? null : other.futureHeader.copy();
        this.ext_formatting_length = Math.min(other.ext_formatting_length, other.ext_formatting_data.length);
        this.ext_formatting_data = (byte[])other.ext_formatting_data.clone();
        this.formula_scale = other.formula_scale.copy();
        this.ext_opts = other.ext_opts;
        this.priority = other.priority;
        this.template_type = other.template_type;
        this.template_param_length = other.template_param_length;
        this.template_params = other.template_params == null ? null : (byte[])other.template_params.clone();
        this.color_gradient = other.color_gradient == null ? null : other.color_gradient.copy();
        this.multistate = other.multistate == null ? null : other.multistate.copy();
        this.data_bar = other.data_bar == null ? null : other.data_bar.copy();
        this.filter_data = other.filter_data == null ? null : (byte[])other.filter_data.clone();
    }

    private CFRule12Record(byte conditionType, byte comparisonOperation) {
        super(conditionType, comparisonOperation);
        this.setDefaults();
    }

    private CFRule12Record(byte conditionType, byte comparisonOperation, Ptg[] formula1, Ptg[] formula2, Ptg[] formulaScale) {
        super(conditionType, comparisonOperation, formula1, formula2);
        this.setDefaults();
        this.formula_scale = Formula.create(formulaScale);
    }

    private void setDefaults() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2170);
        this.ext_formatting_length = 0;
        this.ext_formatting_data = new byte[4];
        this.formula_scale = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.ext_opts = 0;
        this.priority = 0;
        this.template_type = this.getConditionType();
        this.template_param_length = (byte)16;
        this.template_params = IOUtils.safelyAllocate(this.template_param_length, HSSFWorkbook.getMaxRecordLength());
    }

    public static CFRule12Record create(HSSFSheet sheet, String formulaText) {
        Ptg[] formula1 = CFRule12Record.parseFormula(formulaText, sheet);
        return new CFRule12Record(2, 0, formula1, null, null);
    }

    public static CFRule12Record create(HSSFSheet sheet, byte comparisonOperation, String formulaText1, String formulaText2) {
        Ptg[] formula1 = CFRule12Record.parseFormula(formulaText1, sheet);
        Ptg[] formula2 = CFRule12Record.parseFormula(formulaText2, sheet);
        return new CFRule12Record(1, comparisonOperation, formula1, formula2, null);
    }

    public static CFRule12Record create(HSSFSheet sheet, byte comparisonOperation, String formulaText1, String formulaText2, String formulaTextScale) {
        Ptg[] formula1 = CFRule12Record.parseFormula(formulaText1, sheet);
        Ptg[] formula2 = CFRule12Record.parseFormula(formulaText2, sheet);
        Ptg[] formula3 = CFRule12Record.parseFormula(formulaTextScale, sheet);
        return new CFRule12Record(1, comparisonOperation, formula1, formula2, formula3);
    }

    public static CFRule12Record create(HSSFSheet sheet, ExtendedColor color) {
        CFRule12Record r2 = new CFRule12Record(4, 0);
        DataBarFormatting dbf = r2.createDataBarFormatting();
        dbf.setColor(color);
        dbf.setPercentMin((byte)0);
        dbf.setPercentMax((byte)100);
        DataBarThreshold min2 = new DataBarThreshold();
        min2.setType(ConditionalFormattingThreshold.RangeType.MIN.id);
        dbf.setThresholdMin(min2);
        DataBarThreshold max = new DataBarThreshold();
        max.setType(ConditionalFormattingThreshold.RangeType.MAX.id);
        dbf.setThresholdMax(max);
        return r2;
    }

    public static CFRule12Record create(HSSFSheet sheet, IconMultiStateFormatting.IconSet iconSet) {
        Threshold[] ts = new Threshold[iconSet.num];
        for (int i2 = 0; i2 < ts.length; ++i2) {
            ts[i2] = new IconMultiStateThreshold();
        }
        CFRule12Record r2 = new CFRule12Record(6, 0);
        IconMultiStateFormatting imf = r2.createMultiStateFormatting();
        imf.setIconSet(iconSet);
        imf.setThresholds(ts);
        return r2;
    }

    public static CFRule12Record createColorScale(HSSFSheet sheet) {
        int numPoints = 3;
        ExtendedColor[] colors = new ExtendedColor[numPoints];
        ColorGradientThreshold[] ts = new ColorGradientThreshold[numPoints];
        for (int i2 = 0; i2 < ts.length; ++i2) {
            ts[i2] = new ColorGradientThreshold();
            colors[i2] = new ExtendedColor();
        }
        CFRule12Record r2 = new CFRule12Record(3, 0);
        ColorGradientFormatting cgf = r2.createColorGradientFormatting();
        cgf.setNumControlPoints(numPoints);
        cgf.setThresholds(ts);
        cgf.setColors(colors);
        return r2;
    }

    public CFRule12Record(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.setConditionType(in.readByte());
        this.setComparisonOperation(in.readByte());
        int field_3_formula1_len = in.readUShort();
        int field_4_formula2_len = in.readUShort();
        this.ext_formatting_length = in.readInt();
        this.ext_formatting_data = new byte[0];
        if (this.ext_formatting_length == 0) {
            in.readUShort();
        } else {
            long len = this.readFormatOptions(in);
            if (len < (long)this.ext_formatting_length) {
                this.ext_formatting_data = IOUtils.safelyAllocate((long)this.ext_formatting_length - len, HSSFWorkbook.getMaxRecordLength());
                in.readFully(this.ext_formatting_data);
            }
        }
        this.setFormula1(Formula.read(field_3_formula1_len, in));
        this.setFormula2(Formula.read(field_4_formula2_len, in));
        int formula_scale_len = in.readUShort();
        this.formula_scale = Formula.read(formula_scale_len, in);
        this.ext_opts = in.readByte();
        this.priority = in.readUShort();
        this.template_type = in.readUShort();
        this.template_param_length = in.readByte();
        if (this.template_param_length == 0 || this.template_param_length == 16) {
            this.template_params = IOUtils.safelyAllocate(this.template_param_length, HSSFWorkbook.getMaxRecordLength());
            in.readFully(this.template_params);
        } else {
            LOG.atWarn().log("CF Rule v12 template params length should be 0 or 16, found {}", (Object)Unbox.box(this.template_param_length));
            in.readRemainder();
        }
        byte type = this.getConditionType();
        if (type == 3) {
            this.color_gradient = new ColorGradientFormatting(in);
        } else if (type == 4) {
            this.data_bar = new DataBarFormatting(in);
        } else if (type == 5) {
            this.filter_data = in.readRemainder();
        } else if (type == 6) {
            this.multistate = new IconMultiStateFormatting(in);
        }
    }

    public boolean containsDataBarBlock() {
        return this.data_bar != null;
    }

    public DataBarFormatting getDataBarFormatting() {
        return this.data_bar;
    }

    public DataBarFormatting createDataBarFormatting() {
        if (this.data_bar != null) {
            return this.data_bar;
        }
        this.setConditionType((byte)4);
        this.data_bar = new DataBarFormatting();
        return this.data_bar;
    }

    public boolean containsMultiStateBlock() {
        return this.multistate != null;
    }

    public IconMultiStateFormatting getMultiStateFormatting() {
        return this.multistate;
    }

    public IconMultiStateFormatting createMultiStateFormatting() {
        if (this.multistate != null) {
            return this.multistate;
        }
        this.setConditionType((byte)6);
        this.multistate = new IconMultiStateFormatting();
        return this.multistate;
    }

    public boolean containsColorGradientBlock() {
        return this.color_gradient != null;
    }

    public ColorGradientFormatting getColorGradientFormatting() {
        return this.color_gradient;
    }

    public ColorGradientFormatting createColorGradientFormatting() {
        if (this.color_gradient != null) {
            return this.color_gradient;
        }
        this.setConditionType((byte)3);
        this.color_gradient = new ColorGradientFormatting();
        return this.color_gradient;
    }

    public Ptg[] getParsedExpressionScale() {
        return this.formula_scale.getTokens();
    }

    public void setParsedExpressionScale(Ptg[] ptgs) {
        this.formula_scale = Formula.create(ptgs);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public short getSid() {
        return 2170;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        int formula1Len = CFRule12Record.getFormulaSize(this.getFormula1());
        int formula2Len = CFRule12Record.getFormulaSize(this.getFormula2());
        out.writeByte(this.getConditionType());
        out.writeByte(this.getComparisonOperation());
        out.writeShort(formula1Len);
        out.writeShort(formula2Len);
        if (this.ext_formatting_length == 0) {
            out.writeInt(0);
            out.writeShort(0);
        } else {
            out.writeInt(this.ext_formatting_length);
            this.serializeFormattingBlock(out);
            out.write(this.ext_formatting_data);
        }
        this.getFormula1().serializeTokens(out);
        this.getFormula2().serializeTokens(out);
        out.writeShort(CFRule12Record.getFormulaSize(this.formula_scale));
        this.formula_scale.serializeTokens(out);
        out.writeByte(this.ext_opts);
        out.writeShort(this.priority);
        out.writeShort(this.template_type);
        out.writeByte(this.template_param_length);
        out.write(this.template_params);
        byte type = this.getConditionType();
        if (type == 3) {
            this.color_gradient.serialize(out);
        } else if (type == 4) {
            this.data_bar.serialize(out);
        } else if (type == 5) {
            out.write(this.filter_data);
        } else if (type == 6) {
            this.multistate.serialize(out);
        }
    }

    @Override
    protected int getDataSize() {
        int len = FtrHeader.getDataSize() + 6;
        len = this.ext_formatting_length == 0 ? (len += 6) : (len += 4 + this.getFormattingBlockSize() + this.ext_formatting_data.length);
        len += CFRule12Record.getFormulaSize(this.getFormula1());
        len += CFRule12Record.getFormulaSize(this.getFormula2());
        len += 2 + CFRule12Record.getFormulaSize(this.formula_scale);
        len += 6 + this.template_params.length;
        byte type = this.getConditionType();
        if (type == 3) {
            len += this.color_gradient.getDataLength();
        } else if (type == 4) {
            len += this.data_bar.getDataLength();
        } else if (type == 5) {
            len += this.filter_data.length;
        } else if (type == 6) {
            len += this.multistate.getDataLength();
        }
        return len;
    }

    @Override
    public CFRule12Record copy() {
        return new CFRule12Record(this);
    }

    @Override
    public short getFutureRecordType() {
        return this.futureHeader.getRecordType();
    }

    @Override
    public FtrHeader getFutureHeader() {
        return this.futureHeader;
    }

    @Override
    public CellRangeAddress getAssociatedRange() {
        return this.futureHeader.getAssociatedRange();
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.CF_RULE_12;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        LinkedHashMap m3 = new LinkedHashMap(super.getGenericProperties());
        m3.put("dxFn12Length", () -> this.ext_formatting_length);
        m3.put("futureHeader", this::getFutureHeader);
        m3.put("dxFn12Ext", () -> this.ext_formatting_data);
        m3.put("formulaScale", this::getParsedExpressionScale);
        m3.put("extOptions", () -> this.ext_opts);
        m3.put("priority", this::getPriority);
        m3.put("templateType", () -> this.template_type);
        m3.put("templateParams", () -> this.template_params);
        m3.put("filterData", () -> this.filter_data);
        m3.put("dataBar", this::getDataBarFormatting);
        m3.put("multiState", this::getMultiStateFormatting);
        m3.put("colorGradient", this::getColorGradientFormatting);
        return Collections.unmodifiableMap(m3);
    }
}

