/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;

public class ConvertAnchor {
    public static EscherRecord createAnchor(HSSFAnchor userAnchor) {
        if (userAnchor instanceof HSSFClientAnchor) {
            HSSFClientAnchor a2 = (HSSFClientAnchor)userAnchor;
            EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
            anchor.setRecordId(EscherClientAnchorRecord.RECORD_ID);
            anchor.setOptions((short)0);
            anchor.setFlag(a2.getAnchorType().value);
            anchor.setCol1((short)Math.min(a2.getCol1(), a2.getCol2()));
            anchor.setDx1((short)a2.getDx1());
            anchor.setRow1((short)Math.min(a2.getRow1(), a2.getRow2()));
            anchor.setDy1((short)a2.getDy1());
            anchor.setCol2((short)Math.max(a2.getCol1(), a2.getCol2()));
            anchor.setDx2((short)a2.getDx2());
            anchor.setRow2((short)Math.max(a2.getRow1(), a2.getRow2()));
            anchor.setDy2((short)a2.getDy2());
            return anchor;
        }
        HSSFChildAnchor a3 = (HSSFChildAnchor)userAnchor;
        EscherChildAnchorRecord anchor = new EscherChildAnchorRecord();
        anchor.setRecordId(EscherChildAnchorRecord.RECORD_ID);
        anchor.setOptions((short)0);
        anchor.setDx1((short)Math.min(a3.getDx1(), a3.getDx2()));
        anchor.setDy1((short)Math.min(a3.getDy1(), a3.getDy2()));
        anchor.setDx2((short)Math.max(a3.getDx2(), a3.getDx1()));
        anchor.setDy2((short)Math.max(a3.getDy2(), a3.getDy1()));
        return anchor;
    }
}

