/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.EmptyFileException;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MissingSectionException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.NoSingleSectionException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.util.CodePageUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.NotImplemented;

public class PropertySet {
    public static final int OS_WIN16 = 0;
    public static final int OS_MACINTOSH = 1;
    public static final int OS_WIN32 = 2;
    static final int BYTE_ORDER_ASSERTION = 65534;
    static final int FORMAT_ASSERTION = 0;
    static final int OFFSET_HEADER = 28;
    private int byteOrder;
    private int format;
    private int osVersion;
    private ClassID classID;
    private final List<Section> sections = new ArrayList<Section>();

    public PropertySet() {
        this.byteOrder = 65534;
        this.format = 0;
        this.osVersion = 133636;
        this.classID = new ClassID();
        this.addSection(new Section());
    }

    public PropertySet(InputStream stream) throws NoPropertySetStreamException, IOException {
        if (!PropertySet.isPropertySetStream(stream)) {
            throw new NoPropertySetStreamException();
        }
        byte[] buffer = IOUtils.toByteArray(stream);
        this.init(buffer, 0, buffer.length);
    }

    public PropertySet(byte[] stream, int offset, int length) throws NoPropertySetStreamException, UnsupportedEncodingException {
        if (!PropertySet.isPropertySetStream(stream, offset, length)) {
            throw new NoPropertySetStreamException();
        }
        this.init(stream, offset, length);
    }

    public PropertySet(byte[] stream) throws NoPropertySetStreamException, UnsupportedEncodingException {
        this(stream, 0, stream.length);
    }

    public PropertySet(PropertySet ps) {
        this.setByteOrder(ps.getByteOrder());
        this.setFormat(ps.getFormat());
        this.setOSVersion(ps.getOSVersion());
        this.setClassID(ps.getClassID());
        for (Section section : ps.getSections()) {
            this.sections.add(new Section(section));
        }
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getOSVersion() {
        return this.osVersion;
    }

    public void setOSVersion(int osVersion) {
        this.osVersion = osVersion;
    }

    public ClassID getClassID() {
        return this.classID;
    }

    public void setClassID(ClassID classID) {
        this.classID = classID;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public void addSection(Section section) {
        this.sections.add(section);
    }

    public void clearSections() {
        this.sections.clear();
    }

    public PropertyIDMap getPropertySetIDMap() {
        return null;
    }

    public static boolean isPropertySetStream(InputStream stream) throws IOException {
        int BUFFER_SIZE = 50;
        try {
            byte[] buffer = IOUtils.peekFirstNBytes(stream, 50);
            return PropertySet.isPropertySetStream(buffer, 0, buffer.length);
        }
        catch (EmptyFileException e2) {
            return false;
        }
    }

    public static boolean isPropertySetStream(byte[] src, int offset, int length) {
        LittleEndianByteArrayInputStream leis = new LittleEndianByteArrayInputStream(src, offset, length);
        try {
            int byteOrder = leis.readUShort();
            if (byteOrder != 65534) {
                return false;
            }
            int format = leis.readUShort();
            if (format != 0) {
                return false;
            }
            long osVersion = leis.readUInt();
            if (leis.skip(16L) != 16L) {
                return false;
            }
            long sectionCount = leis.readUInt();
            return sectionCount >= 0L;
        }
        catch (RuntimeException e2) {
            return false;
        }
    }

    private void init(byte[] src, int offset, int length) throws UnsupportedEncodingException {
        int o2 = offset;
        this.byteOrder = LittleEndian.getUShort(src, o2);
        this.format = LittleEndian.getUShort(src, o2 += 2);
        this.osVersion = (int)LittleEndian.getUInt(src, o2 += 2);
        this.classID = new ClassID(src, o2 += 4);
        int sectionCount = LittleEndian.getInt(src, o2 += 16);
        o2 += 4;
        if (sectionCount < 0) {
            throw new HPSFRuntimeException("Section count " + sectionCount + " is negative.");
        }
        for (int i2 = 0; i2 < sectionCount; ++i2) {
            Section s2 = new Section(src, o2);
            o2 += 20;
            this.sections.add(s2);
        }
    }

    public void write(OutputStream out) throws IOException, WritingNotSupportedException {
        out.write(this.toBytes());
        out.close();
    }

    /*
     * Exception decompiling
     */
    private byte[] toBytes() throws WritingNotSupportedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(DirectoryEntry dir, String name) throws WritingNotSupportedException, IOException {
        if (dir.hasEntry(name)) {
            Entry e2 = dir.getEntry(name);
            e2.delete();
        }
        dir.createDocument(name, this.toInputStream());
    }

    public InputStream toInputStream() throws WritingNotSupportedException, IOException {
        return new UnsynchronizedByteArrayInputStream(this.toBytes());
    }

    String getPropertyStringValue(int propertyId) {
        Object propertyValue = this.getProperty(propertyId);
        return PropertySet.getPropertyStringValue(propertyValue);
    }

    public static String getPropertyStringValue(Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof String) {
            return (String)propertyValue;
        }
        if (propertyValue instanceof byte[]) {
            byte[] b2 = (byte[])propertyValue;
            switch (b2.length) {
                case 0: {
                    return "";
                }
                case 1: {
                    return Byte.toString(b2[0]);
                }
                case 2: {
                    return Integer.toString(LittleEndian.getUShort(b2));
                }
                case 4: {
                    return Long.toString(LittleEndian.getUInt(b2));
                }
            }
            try {
                return CodePageUtil.getStringFromCodePage(b2, 1252);
            }
            catch (UnsupportedEncodingException e2) {
                return "";
            }
        }
        return propertyValue.toString();
    }

    public boolean isSummaryInformation() {
        return !this.sections.isEmpty() && PropertySet.matchesSummary(this.getFirstSection().getFormatID(), SummaryInformation.FORMAT_ID);
    }

    public boolean isDocumentSummaryInformation() {
        return !this.sections.isEmpty() && PropertySet.matchesSummary(this.getFirstSection().getFormatID(), DocumentSummaryInformation.FORMAT_ID);
    }

    static boolean matchesSummary(ClassID actual, ClassID ... expected) {
        for (ClassID sum : expected) {
            if (!sum.equals(actual) && !sum.equalsInverted(actual)) continue;
            return true;
        }
        return false;
    }

    public Property[] getProperties() throws NoSingleSectionException {
        return this.getFirstSection().getProperties();
    }

    protected Object getProperty(int id) throws NoSingleSectionException {
        return this.getFirstSection().getProperty(id);
    }

    boolean getPropertyBooleanValue(int id) throws NoSingleSectionException {
        return this.getFirstSection().getPropertyBooleanValue(id);
    }

    int getPropertyIntValue(int id) throws NoSingleSectionException {
        return this.getFirstSection().getPropertyIntValue(id);
    }

    public boolean wasNull() throws NoSingleSectionException {
        return this.getFirstSection().wasNull();
    }

    public Section getFirstSection() {
        if (this.sections.isEmpty()) {
            throw new MissingSectionException("Property set does not contain any sections.");
        }
        return this.sections.get(0);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof PropertySet)) {
            return false;
        }
        PropertySet ps = (PropertySet)o2;
        int byteOrder1 = ps.getByteOrder();
        int byteOrder2 = this.getByteOrder();
        ClassID classID1 = ps.getClassID();
        ClassID classID2 = this.getClassID();
        int format1 = ps.getFormat();
        int format2 = this.getFormat();
        int osVersion1 = ps.getOSVersion();
        int osVersion2 = this.getOSVersion();
        int sectionCount1 = ps.getSectionCount();
        int sectionCount2 = this.getSectionCount();
        if (byteOrder1 != byteOrder2 || !classID1.equals(classID2) || format1 != format2 || osVersion1 != osVersion2 || sectionCount1 != sectionCount2) {
            return false;
        }
        return this.getSections().containsAll(ps.getSections());
    }

    @NotImplemented
    public int hashCode() {
        throw new UnsupportedOperationException("FIXME: Not yet implemented.");
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        int sectionCount = this.getSectionCount();
        b2.append(this.getClass().getName());
        b2.append('[');
        b2.append("byteOrder: ");
        b2.append(this.getByteOrder());
        b2.append(", classID: ");
        b2.append(this.getClassID());
        b2.append(", format: ");
        b2.append(this.getFormat());
        b2.append(", OSVersion: ");
        b2.append(this.getOSVersion());
        b2.append(", sectionCount: ");
        b2.append(sectionCount);
        b2.append(", sections: [\n");
        for (Section section : this.getSections()) {
            b2.append(section.toString(this.getPropertySetIDMap()));
        }
        b2.append(']');
        b2.append(']');
        return b2.toString();
    }

    void remove1stProperty(long id) {
        this.getFirstSection().removeProperty(id);
    }

    void set1stProperty(long id, String value) {
        this.getFirstSection().setProperty((int)id, value);
    }

    void set1stProperty(long id, int value) {
        this.getFirstSection().setProperty((int)id, value);
    }

    void set1stProperty(long id, boolean value) {
        this.getFirstSection().setProperty((int)id, value);
    }

    void set1stProperty(long id, byte[] value) {
        this.getFirstSection().setProperty((int)id, value);
    }

    private static void putClassId(UnsynchronizedByteArrayOutputStream out, ClassID n2) {
        byte[] b2 = new byte[16];
        n2.write(b2, 0);
        out.write(b2, 0, b2.length);
    }
}

