/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.Point2D;

class CubicBezierCurve {
    private final Point2D[] controlPoints;
    private final int level;
    private final Point2D[] curve;

    CubicBezierCurve(Point2D[] ctrlPnts, int l2) {
        this.controlPoints = (Point2D[])ctrlPnts.clone();
        this.level = l2;
        this.curve = this.getPoints(this.level);
    }

    int getLevel() {
        return this.level;
    }

    private Point2D[] getPoints(int l2) {
        if (l2 < 0) {
            l2 = 0;
        }
        int sz = (1 << l2) + 1;
        Point2D[] res = new Point2D[sz];
        double step = 1.0 / (double)(sz - 1);
        double t = -step;
        for (int i2 = 0; i2 < sz; ++i2) {
            double tmpX = (1.0 - (t += step)) * (1.0 - t) * (1.0 - t) * this.controlPoints[0].getX() + 3.0 * t * (1.0 - t) * (1.0 - t) * this.controlPoints[1].getX() + 3.0 * t * t * (1.0 - t) * this.controlPoints[2].getX() + t * t * t * this.controlPoints[3].getX();
            double tmpY = (1.0 - t) * (1.0 - t) * (1.0 - t) * this.controlPoints[0].getY() + 3.0 * t * (1.0 - t) * (1.0 - t) * this.controlPoints[1].getY() + 3.0 * t * t * (1.0 - t) * this.controlPoints[2].getY() + t * t * t * this.controlPoints[3].getY();
            res[i2] = new Point2D.Double(tmpX, tmpY);
        }
        return res;
    }

    Point2D[] getCubicBezierCurve() {
        return this.curve;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Point2D p2 : this.controlPoints) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(p2);
        }
        return "Cubic Bezier curve{control points p0, p1, p2, p3: " + sb + "}";
    }
}

