/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDAttributeObject;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDUserProperty;

public class PDUserAttributeObject
extends PDAttributeObject {
    public static final String OWNER_USER_PROPERTIES = "UserProperties";

    public PDUserAttributeObject() {
        this.setOwner(OWNER_USER_PROPERTIES);
    }

    public PDUserAttributeObject(COSDictionary dictionary) {
        super(dictionary);
    }

    public List<PDUserProperty> getOwnerUserProperties() {
        COSArray p2 = (COSArray)this.getCOSObject().getDictionaryObject(COSName.P);
        ArrayList<PDUserProperty> properties = new ArrayList<PDUserProperty>(p2.size());
        for (int i2 = 0; i2 < p2.size(); ++i2) {
            properties.add(new PDUserProperty((COSDictionary)p2.getObject(i2), this));
        }
        return properties;
    }

    public void setUserProperties(List<PDUserProperty> userProperties) {
        COSArray p2 = new COSArray();
        for (PDUserProperty userProperty : userProperties) {
            p2.add(userProperty);
        }
        this.getCOSObject().setItem(COSName.P, (COSBase)p2);
    }

    public void addUserProperty(PDUserProperty userProperty) {
        COSArray p2 = (COSArray)this.getCOSObject().getDictionaryObject(COSName.P);
        p2.add(userProperty);
        this.notifyChanged();
    }

    public void removeUserProperty(PDUserProperty userProperty) {
        if (userProperty == null) {
            return;
        }
        COSArray p2 = (COSArray)this.getCOSObject().getDictionaryObject(COSName.P);
        p2.remove(userProperty.getCOSObject());
        this.notifyChanged();
    }

    public void userPropertyChanged(PDUserProperty userProperty) {
    }

    @Override
    public String toString() {
        return super.toString() + ", userProperties=" + this.getOwnerUserProperties();
    }
}

