/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginDescriptorBuilder {
    public PluginDescriptor build(Reader reader) throws PlexusConfigurationException {
        return this.build(reader, null);
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        PlexusConfiguration[] mojoConfigurations;
        String inheritedByDefault;
        PlexusConfiguration c2 = this.buildConfiguration(reader);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setSource(source);
        pluginDescriptor.setGroupId(c2.getChild("groupId").getValue());
        pluginDescriptor.setArtifactId(c2.getChild("artifactId").getValue());
        pluginDescriptor.setVersion(c2.getChild("version").getValue());
        pluginDescriptor.setGoalPrefix(c2.getChild("goalPrefix").getValue());
        pluginDescriptor.setName(c2.getChild("name").getValue());
        pluginDescriptor.setDescription(c2.getChild("description").getValue());
        String isolatedRealm = c2.getChild("isolatedRealm").getValue();
        if (isolatedRealm != null) {
            pluginDescriptor.setIsolatedRealm(Boolean.parseBoolean(isolatedRealm));
        }
        if ((inheritedByDefault = c2.getChild("inheritedByDefault").getValue()) != null) {
            pluginDescriptor.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        for (PlexusConfiguration component : mojoConfigurations = c2.getChild("mojos").getChildren("mojo")) {
            MojoDescriptor mojoDescriptor = this.buildComponentDescriptor(component, pluginDescriptor);
            pluginDescriptor.addMojo(mojoDescriptor);
        }
        PlexusConfiguration[] dependencyConfigurations = c2.getChild("dependencies").getChildren("dependency");
        ArrayList<ComponentDependency> dependencies = new ArrayList<ComponentDependency>();
        for (PlexusConfiguration d2 : dependencyConfigurations) {
            ComponentDependency cd2 = new ComponentDependency();
            cd2.setArtifactId(d2.getChild("artifactId").getValue());
            cd2.setGroupId(d2.getChild("groupId").getValue());
            cd2.setType(d2.getChild("type").getValue());
            cd2.setVersion(d2.getChild("version").getValue());
            dependencies.add(cd2);
        }
        pluginDescriptor.setDependencies(dependencies);
        return pluginDescriptor;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c2, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        PlexusConfiguration[] requirements;
        String threadSafe;
        String inheritedByDefault;
        String requiresOnline;
        String aggregator;
        String requiresReports;
        String requiresProject;
        String directInvocationOnly;
        PlexusConfiguration dependencyCollection;
        String executeLifecycle;
        String executeMojo;
        String executePhase;
        String phase;
        PlexusConfiguration deprecated;
        String since;
        PlexusConfiguration composerConfig;
        PlexusConfiguration configuratorConfig;
        MojoDescriptor mojo = new MojoDescriptor();
        mojo.setPluginDescriptor(pluginDescriptor);
        mojo.setGoal(c2.getChild("goal").getValue());
        mojo.setImplementation(c2.getChild("implementation").getValue());
        PlexusConfiguration langConfig = c2.getChild("language");
        if (langConfig != null) {
            mojo.setLanguage(langConfig.getValue());
        }
        if ((configuratorConfig = c2.getChild("configurator")) != null) {
            mojo.setComponentConfigurator(configuratorConfig.getValue());
        }
        if ((composerConfig = c2.getChild("composer")) != null) {
            mojo.setComponentComposer(composerConfig.getValue());
        }
        if ((since = c2.getChild("since").getValue()) != null) {
            mojo.setSince(since);
        }
        if ((deprecated = c2.getChild("deprecated", false)) != null) {
            mojo.setDeprecated(deprecated.getValue());
        }
        if ((phase = c2.getChild("phase").getValue()) != null) {
            mojo.setPhase(phase);
        }
        if ((executePhase = c2.getChild("executePhase").getValue()) != null) {
            mojo.setExecutePhase(executePhase);
        }
        if ((executeMojo = c2.getChild("executeGoal").getValue()) != null) {
            mojo.setExecuteGoal(executeMojo);
        }
        if ((executeLifecycle = c2.getChild("executeLifecycle").getValue()) != null) {
            mojo.setExecuteLifecycle(executeLifecycle);
        }
        mojo.setInstantiationStrategy(c2.getChild("instantiationStrategy").getValue());
        mojo.setDescription(c2.getChild("description").getValue());
        PlexusConfiguration dependencyResolution = c2.getChild("requiresDependencyResolution", false);
        if (dependencyResolution != null) {
            mojo.setDependencyResolutionRequired(dependencyResolution.getValue());
        }
        if ((dependencyCollection = c2.getChild("requiresDependencyCollection", false)) != null) {
            mojo.setDependencyCollectionRequired(dependencyCollection.getValue());
        }
        if ((directInvocationOnly = c2.getChild("requiresDirectInvocation").getValue()) != null) {
            mojo.setDirectInvocationOnly(Boolean.parseBoolean(directInvocationOnly));
        }
        if ((requiresProject = c2.getChild("requiresProject").getValue()) != null) {
            mojo.setProjectRequired(Boolean.parseBoolean(requiresProject));
        }
        if ((requiresReports = c2.getChild("requiresReports").getValue()) != null) {
            mojo.setRequiresReports(Boolean.parseBoolean(requiresReports));
        }
        if ((aggregator = c2.getChild("aggregator").getValue()) != null) {
            mojo.setAggregator(Boolean.parseBoolean(aggregator));
        }
        if ((requiresOnline = c2.getChild("requiresOnline").getValue()) != null) {
            mojo.setOnlineRequired(Boolean.parseBoolean(requiresOnline));
        }
        if ((inheritedByDefault = c2.getChild("inheritedByDefault").getValue()) != null) {
            mojo.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        if ((threadSafe = c2.getChild("threadSafe").getValue()) != null) {
            mojo.setThreadSafe(Boolean.parseBoolean(threadSafe));
        }
        PlexusConfiguration mojoConfig = c2.getChild("configuration");
        mojo.setMojoConfiguration(mojoConfig);
        PlexusConfiguration[] parameterConfigurations = c2.getChild("parameters").getChildren("parameter");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PlexusConfiguration d2 : parameterConfigurations) {
            Parameter parameter = new Parameter();
            parameter.setName(d2.getChild("name").getValue());
            parameter.setAlias(d2.getChild("alias").getValue());
            parameter.setType(d2.getChild("type").getValue());
            String required = d2.getChild("required").getValue();
            parameter.setRequired(Boolean.parseBoolean(required));
            PlexusConfiguration editableConfig = d2.getChild("editable");
            if (editableConfig != null) {
                String editable = d2.getChild("editable").getValue();
                parameter.setEditable(editable == null || Boolean.parseBoolean(editable));
            }
            parameter.setDescription(d2.getChild("description").getValue());
            parameter.setDeprecated(d2.getChild("deprecated").getValue());
            parameter.setImplementation(d2.getChild("implementation").getValue());
            parameter.setSince(d2.getChild("since").getValue());
            PlexusConfiguration paramConfig = mojoConfig.getChild(parameter.getName(), false);
            if (paramConfig != null) {
                parameter.setExpression(paramConfig.getValue(null));
                parameter.setDefaultValue(paramConfig.getAttribute("default-value"));
            }
            parameters.add(parameter);
        }
        mojo.setParameters(parameters);
        for (PlexusConfiguration requirement : requirements = c2.getChild("requirements").getChildren("requirement")) {
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            mojo.addRequirement(cr);
        }
        return mojo;
    }

    public PlexusConfiguration buildConfiguration(Reader configuration) throws PlexusConfigurationException {
        try {
            return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
        }
        catch (IOException | XmlPullParserException e2) {
            throw new PlexusConfigurationException(e2.getMessage(), e2);
        }
    }
}

