/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.TTFDataStream;

public class GlyfSimpleDescript
extends GlyfDescript {
    private static final Log LOG = LogFactory.getLog(GlyfSimpleDescript.class);
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private final int pointCount;

    GlyfSimpleDescript() throws IOException {
        super((short)0, null);
        this.pointCount = 0;
    }

    GlyfSimpleDescript(short numberOfContours, TTFDataStream bais, short x0) throws IOException {
        super(numberOfContours, bais);
        if (numberOfContours == 0) {
            this.pointCount = 0;
            return;
        }
        this.endPtsOfContours = bais.readUnsignedShortArray(numberOfContours);
        int lastEndPt = this.endPtsOfContours[numberOfContours - 1];
        if (numberOfContours == 1 && lastEndPt == 65535) {
            this.pointCount = 0;
            return;
        }
        this.pointCount = lastEndPt + 1;
        this.flags = new byte[this.pointCount];
        this.xCoordinates = new short[this.pointCount];
        this.yCoordinates = new short[this.pointCount];
        int instructionCount = bais.readUnsignedShort();
        this.readInstructions(bais, instructionCount);
        this.readFlags(this.pointCount, bais);
        this.readCoords(this.pointCount, bais, x0);
    }

    @Override
    public int getEndPtOfContours(int i2) {
        return this.endPtsOfContours[i2];
    }

    @Override
    public byte getFlags(int i2) {
        return this.flags[i2];
    }

    @Override
    public short getXCoordinate(int i2) {
        return this.xCoordinates[i2];
    }

    @Override
    public short getYCoordinate(int i2) {
        return this.yCoordinates[i2];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this.pointCount;
    }

    private void readCoords(int count, TTFDataStream bais, short x0) throws IOException {
        int i2;
        short x = x0;
        short y = 0;
        for (i2 = 0; i2 < count; ++i2) {
            if ((this.flags[i2] & 0x10) != 0) {
                if ((this.flags[i2] & 2) != 0) {
                    x = (short)(x + (short)bais.readUnsignedByte());
                }
            } else {
                x = (this.flags[i2] & 2) != 0 ? (short)(x - (short)bais.readUnsignedByte()) : (short)(x + bais.readSignedShort());
            }
            this.xCoordinates[i2] = x;
        }
        for (i2 = 0; i2 < count; ++i2) {
            if ((this.flags[i2] & 0x20) != 0) {
                if ((this.flags[i2] & 4) != 0) {
                    y = (short)(y + (short)bais.readUnsignedByte());
                }
            } else {
                y = (this.flags[i2] & 4) != 0 ? (short)(y - (short)bais.readUnsignedByte()) : (short)(y + bais.readSignedShort());
            }
            this.yCoordinates[i2] = y;
        }
    }

    private void readFlags(int flagCount, TTFDataStream bais) throws IOException {
        for (int index = 0; index < flagCount; ++index) {
            this.flags[index] = (byte)bais.readUnsignedByte();
            if ((this.flags[index] & 8) == 0) continue;
            int repeats = bais.readUnsignedByte();
            for (int i2 = 1; i2 <= repeats; ++i2) {
                if (index + i2 >= this.flags.length) {
                    LOG.error("repeat count (" + repeats + ") higher than remaining space");
                    return;
                }
                this.flags[index + i2] = this.flags[index];
            }
            index += repeats;
        }
    }
}

