/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Arrays;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_SQUARED = Math.PI * Math.PI;

    private MathUtils() {
    }

    public static int hash(double value) {
        return new Double(value).hashCode();
    }

    public static boolean equals(double x, double y) {
        return new Double(x).equals(new Double(y));
    }

    public static int hash(double[] value) {
        return Arrays.hashCode(value);
    }

    public static double normalizeAngle(double a2, double center) {
        return a2 - Math.PI * 2 * FastMath.floor((a2 + Math.PI - center) / (Math.PI * 2));
    }

    public static <T extends RealFieldElement<T>> T max(T e1, T e2) {
        return e1.subtract(e2).getReal() >= 0.0 ? e1 : e2;
    }

    public static <T extends RealFieldElement<T>> T min(T e1, T e2) {
        return e1.subtract(e2).getReal() >= 0.0 ? e2 : e1;
    }

    public static double reduce(double a2, double period, double offset) {
        double p2 = FastMath.abs(period);
        return a2 - p2 * FastMath.floor((a2 - offset) / p2) - offset;
    }

    public static byte copySign(byte magnitude, byte sign) throws MathArithmeticException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == -128) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static short copySign(short magnitude, short sign) throws MathArithmeticException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == Short.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static int copySign(int magnitude, int sign) throws MathArithmeticException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static long copySign(long magnitude, long sign) throws MathArithmeticException {
        if (magnitude >= 0L && sign >= 0L || magnitude < 0L && sign < 0L) {
            return magnitude;
        }
        if (sign >= 0L && magnitude == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static void checkFinite(double x) throws NotFiniteNumberException {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new NotFiniteNumberException(x, new Object[0]);
        }
    }

    public static void checkFinite(double[] val) throws NotFiniteNumberException {
        for (int i2 = 0; i2 < val.length; ++i2) {
            double x = val[i2];
            if (!Double.isInfinite(x) && !Double.isNaN(x)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, x, i2);
        }
    }

    public static void checkNotNull(Object o2, Localizable pattern, Object ... args) throws NullArgumentException {
        if (o2 == null) {
            throw new NullArgumentException(pattern, args);
        }
    }

    public static void checkNotNull(Object o2) throws NullArgumentException {
        if (o2 == null) {
            throw new NullArgumentException();
        }
    }
}

