/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class VectorialCovariance
implements Serializable {
    private static final long serialVersionUID = 4118372414238930270L;
    private final double[] sums;
    private final double[] productsSums;
    private final boolean isBiasCorrected;
    private long n;

    public VectorialCovariance(int dimension, boolean isBiasCorrected) {
        this.sums = new double[dimension];
        this.productsSums = new double[dimension * (dimension + 1) / 2];
        this.n = 0L;
        this.isBiasCorrected = isBiasCorrected;
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.sums.length) {
            throw new DimensionMismatchException(v.length, this.sums.length);
        }
        int k2 = 0;
        for (int i2 = 0; i2 < v.length; ++i2) {
            int n2 = i2;
            this.sums[n2] = this.sums[n2] + v[i2];
            for (int j2 = 0; j2 <= i2; ++j2) {
                int n3 = k2++;
                this.productsSums[n3] = this.productsSums[n3] + v[i2] * v[j2];
            }
        }
        ++this.n;
    }

    public RealMatrix getResult() {
        int dimension = this.sums.length;
        RealMatrix result = MatrixUtils.createRealMatrix(dimension, dimension);
        if (this.n > 1L) {
            double c2 = 1.0 / (double)(this.n * (this.isBiasCorrected ? this.n - 1L : this.n));
            int k2 = 0;
            for (int i2 = 0; i2 < dimension; ++i2) {
                for (int j2 = 0; j2 <= i2; ++j2) {
                    double e2 = c2 * ((double)this.n * this.productsSums[k2++] - this.sums[i2] * this.sums[j2]);
                    result.setEntry(i2, j2, e2);
                    result.setEntry(j2, i2, e2);
                }
            }
        }
        return result;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.n = 0L;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.productsSums, 0.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBiasCorrected ? 1231 : 1237);
        result = 31 * result + (int)(this.n ^ this.n >>> 32);
        result = 31 * result + Arrays.hashCode(this.productsSums);
        result = 31 * result + Arrays.hashCode(this.sums);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialCovariance)) {
            return false;
        }
        VectorialCovariance other = (VectorialCovariance)obj;
        if (this.isBiasCorrected != other.isBiasCorrected) {
            return false;
        }
        if (this.n != other.n) {
            return false;
        }
        if (!Arrays.equals(this.productsSums, other.productsSums)) {
            return false;
        }
        return Arrays.equals(this.sums, other.sums);
    }
}

