/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.primes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.primes.SmallPrimes;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PollardRho {
    private PollardRho() {
    }

    public static List<Integer> primeFactors(int n2) {
        ArrayList<Integer> factors = new ArrayList<Integer>();
        if (1 == (n2 = SmallPrimes.smallTrialDivision(n2, factors))) {
            return factors;
        }
        if (SmallPrimes.millerRabinPrimeTest(n2)) {
            factors.add(n2);
            return factors;
        }
        int divisor = PollardRho.rhoBrent(n2);
        factors.add(divisor);
        factors.add(n2 / divisor);
        return factors;
    }

    static int rhoBrent(int n2) {
        int x0 = 2;
        int m3 = 25;
        int cst = SmallPrimes.PRIMES_LAST;
        int y = 2;
        int r2 = 1;
        while (true) {
            int x = y;
            for (int i2 = 0; i2 < r2; ++i2) {
                long y2 = (long)y * (long)y;
                y = (int)((y2 + (long)cst) % (long)n2);
            }
            int k2 = 0;
            do {
                int out;
                int bound = FastMath.min(25, r2 - k2);
                int q2 = 1;
                for (int i3 = -3; i3 < bound; ++i3) {
                    long y2 = (long)y * (long)y;
                    long divisor = FastMath.abs(x - (y = (int)((y2 + (long)cst) % (long)n2)));
                    if (0L == divisor) {
                        cst += SmallPrimes.PRIMES_LAST;
                        k2 = -25;
                        y = 2;
                        r2 = 1;
                        break;
                    }
                    long prod = divisor * (long)q2;
                    if (0 != (q2 = (int)(prod % (long)n2))) continue;
                    return PollardRho.gcdPositive(FastMath.abs((int)divisor), n2);
                }
                if (1 == (out = PollardRho.gcdPositive(FastMath.abs(q2), n2))) continue;
                return out;
            } while ((k2 += 25) < r2);
            r2 = 2 * r2;
        }
    }

    static int gcdPositive(int a2, int b2) {
        if (a2 == 0) {
            return b2;
        }
        if (b2 == 0) {
            return a2;
        }
        int aTwos = Integer.numberOfTrailingZeros(a2);
        a2 >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b2);
        b2 >>= bTwos;
        int shift = FastMath.min(aTwos, bTwos);
        while (a2 != b2) {
            int delta = a2 - b2;
            b2 = FastMath.min(a2, b2);
            a2 = FastMath.abs(delta);
            a2 >>= Integer.numberOfTrailingZeros(a2);
        }
        return a2 << shift;
    }
}

