/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckFieldTransformer<T extends RealFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field, int n2) {
        this.field = field;
        int rows = n2 - 1;
        FieldMatrix<T> bigP = this.buildP(rows);
        FieldDecompositionSolver<T> pSolver = new FieldLUDecomposition<T>(bigP).getSolver();
        Object[] u = (RealFieldElement[])MathArrays.buildArray(field, rows);
        Arrays.fill(u, field.getOne());
        this.c1 = (RealFieldElement[])pSolver.solve(new ArrayFieldVector((FieldElement[])u, false)).toArray();
        FieldElement[][] shiftedP = (RealFieldElement[][])bigP.getData();
        for (int i2 = shiftedP.length - 1; i2 > 0; --i2) {
            shiftedP[i2] = shiftedP[i2 - 1];
        }
        shiftedP[0] = (RealFieldElement[])MathArrays.buildArray(field, rows);
        Arrays.fill(shiftedP[0], field.getZero());
        this.update = new Array2DRowFieldMatrix(pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false)).getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RealFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field, int nSteps) {
        Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> map = CACHE;
        synchronized (map) {
            AdamsNordsieckFieldTransformer<RealFieldElement<Object>> t;
            Map<Field<RealFieldElement<?>>, AdamsNordsieckFieldTransformer<RealFieldElement<?>>> map2 = CACHE.get(nSteps);
            if (map2 == null) {
                map2 = new HashMap();
                CACHE.put(nSteps, map2);
            }
            if ((t = map2.get(field)) == null) {
                t = new AdamsNordsieckFieldTransformer<T>(field, nSteps);
                map2.put(field, t);
            }
            return t;
        }
    }

    private FieldMatrix<T> buildP(int rows) {
        FieldElement[][] pData = (RealFieldElement[][])MathArrays.buildArray(this.field, rows, rows);
        for (int i2 = 1; i2 <= pData.length; ++i2) {
            RealFieldElement[] pI = pData[i2 - 1];
            int factor = -i2;
            RealFieldElement aj = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(factor);
            for (int j2 = 1; j2 <= pI.length; ++j2) {
                pI[j2 - 1] = (RealFieldElement)aj.multiply(j2 + 1);
                aj = (RealFieldElement)aj.multiply(factor);
            }
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T h2, T[] t, T[][] y, T[][] yDot) {
        FieldElement[][] a2 = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, this.c1.length + 1);
        FieldElement[][] b2 = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, y[0].length);
        T[] y0 = y[0];
        T[] yDot0 = yDot[0];
        for (int i2 = 1; i2 < y.length; ++i2) {
            RealFieldElement di = (RealFieldElement)t[i2].subtract(t[0]);
            RealFieldElement ratio = (RealFieldElement)di.divide(h2);
            RealFieldElement dikM1Ohk = (RealFieldElement)h2.reciprocal();
            FieldElement[] aI = a2[2 * i2 - 2];
            FieldElement[] aDotI = 2 * i2 - 1 < a2.length ? a2[2 * i2 - 1] : null;
            for (int j2 = 0; j2 < aI.length; ++j2) {
                dikM1Ohk = dikM1Ohk.multiply(ratio);
                aI[j2] = di.multiply(dikM1Ohk);
                if (aDotI == null) continue;
                aDotI[j2] = (RealFieldElement)dikM1Ohk.multiply(j2 + 2);
            }
            T[] yI = y[i2];
            T[] yDotI = yDot[i2];
            FieldElement[] bI = b2[2 * i2 - 2];
            FieldElement[] bDotI = 2 * i2 - 1 < b2.length ? b2[2 * i2 - 1] : null;
            for (int j3 = 0; j3 < yI.length; ++j3) {
                bI[j3] = (RealFieldElement)((RealFieldElement)yI[j3].subtract(y0[j3])).subtract(di.multiply(yDot0[j3]));
                if (bDotI == null) continue;
                bDotI[j3] = (RealFieldElement)yDotI[j3].subtract(yDot0[j3]);
            }
        }
        FieldLUDecomposition decomposition = new FieldLUDecomposition(new Array2DRowFieldMatrix(a2, false));
        FieldMatrix x = decomposition.getSolver().solve(new Array2DRowFieldMatrix(b2, false));
        Array2DRowFieldMatrix truncatedX = new Array2DRowFieldMatrix(this.field, x.getRowDimension() - 1, x.getColumnDimension());
        for (int i3 = 0; i3 < truncatedX.getRowDimension(); ++i3) {
            for (int j4 = 0; j4 < truncatedX.getColumnDimension(); ++j4) {
                truncatedX.setEntry(i3, j4, x.getEntry(i3, j4));
            }
        }
        return truncatedX;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(T[] start, T[] end, Array2DRowFieldMatrix<T> highOrder) {
        RealFieldElement[][] data = (RealFieldElement[][])highOrder.getDataRef();
        for (int i2 = 0; i2 < data.length; ++i2) {
            RealFieldElement[] dataI = data[i2];
            T c1I = this.c1[i2];
            for (int j2 = 0; j2 < dataI.length; ++j2) {
                dataI[j2] = (RealFieldElement)dataI[j2].add(c1I.multiply(start[j2].subtract(end[j2])));
            }
        }
    }
}

