/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Add;
import org.apache.commons.math3.analysis.function.Divide;
import org.apache.commons.math3.analysis.function.Multiply;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVectorChangingVisitor;
import org.apache.commons.math3.linear.RealVectorPreservingVisitor;
import org.apache.commons.math3.linear.SparseRealVector;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealVector {
    public abstract int getDimension();

    public abstract double getEntry(int var1) throws OutOfRangeException;

    public abstract void setEntry(int var1, double var2) throws OutOfRangeException;

    public void addToEntry(int index, double increment) throws OutOfRangeException {
        this.setEntry(index, this.getEntry(index) + increment);
    }

    public abstract RealVector append(RealVector var1);

    public abstract RealVector append(double var1);

    public abstract RealVector getSubVector(int var1, int var2) throws NotPositiveException, OutOfRangeException;

    public abstract void setSubVector(int var1, RealVector var2) throws OutOfRangeException;

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    protected void checkVectorDimensions(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n2) throws DimensionMismatchException {
        int d2 = this.getDimension();
        if (d2 != n2) {
            throw new DimensionMismatchException(d2, n2);
        }
    }

    protected void checkIndex(int index) throws OutOfRangeException {
        if (index < 0 || index >= this.getDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)index, 0, this.getDimension() - 1);
        }
    }

    protected void checkIndices(int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        int dim = this.getDimension();
        if (start < 0 || start >= dim) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)start, 0, dim - 1);
        }
        if (end < 0 || end >= dim) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)end, 0, dim - 1);
        }
        if (end < start) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)end, start, false);
        }
    }

    public RealVector add(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        RealVector result = v.copy();
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            int index = e2.getIndex();
            result.setEntry(index, e2.getValue() + result.getEntry(index));
        }
        return result;
    }

    public RealVector subtract(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        RealVector result = v.mapMultiply(-1.0);
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            int index = e2.getIndex();
            result.setEntry(index, e2.getValue() + result.getEntry(index));
        }
        return result;
    }

    public RealVector mapAdd(double d2) {
        return this.copy().mapAddToSelf(d2);
    }

    public RealVector mapAddToSelf(double d2) {
        if (d2 != 0.0) {
            return this.mapToSelf(FunctionUtils.fix2ndArgument(new Add(), d2));
        }
        return this;
    }

    public abstract RealVector copy();

    public double dotProduct(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        double d2 = 0.0;
        int n2 = this.getDimension();
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.getEntry(i2) * v.getEntry(i2);
        }
        return d2;
    }

    public double cosine(RealVector v) throws DimensionMismatchException, MathArithmeticException {
        double norm = this.getNorm();
        double vNorm = v.getNorm();
        if (norm == 0.0 || vNorm == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.dotProduct(v) / (norm * vNorm);
    }

    public abstract RealVector ebeDivide(RealVector var1) throws DimensionMismatchException;

    public abstract RealVector ebeMultiply(RealVector var1) throws DimensionMismatchException;

    public double getDistance(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        double d2 = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            double diff = e2.getValue() - v.getEntry(e2.getIndex());
            d2 += diff * diff;
        }
        return FastMath.sqrt(d2);
    }

    public double getNorm() {
        double sum = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            double value = e2.getValue();
            sum += value * value;
        }
        return FastMath.sqrt(sum);
    }

    public double getL1Norm() {
        double norm = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            norm += FastMath.abs(e2.getValue());
        }
        return norm;
    }

    public double getLInfNorm() {
        double norm = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            norm = FastMath.max(norm, FastMath.abs(e2.getValue()));
        }
        return norm;
    }

    public double getL1Distance(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        double d2 = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            d2 += FastMath.abs(e2.getValue() - v.getEntry(e2.getIndex()));
        }
        return d2;
    }

    public double getLInfDistance(RealVector v) throws DimensionMismatchException {
        this.checkVectorDimensions(v);
        double d2 = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            d2 = FastMath.max(FastMath.abs(e2.getValue() - v.getEntry(e2.getIndex())), d2);
        }
        return d2;
    }

    public int getMinIndex() {
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() <= minValue)) continue;
            minIndex = entry.getIndex();
            minValue = entry.getValue();
        }
        return minIndex;
    }

    public double getMinValue() {
        int minIndex = this.getMinIndex();
        return minIndex < 0 ? Double.NaN : this.getEntry(minIndex);
    }

    public int getMaxIndex() {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() >= maxValue)) continue;
            maxIndex = entry.getIndex();
            maxValue = entry.getValue();
        }
        return maxIndex;
    }

    public double getMaxValue() {
        int maxIndex = this.getMaxIndex();
        return maxIndex < 0 ? Double.NaN : this.getEntry(maxIndex);
    }

    public RealVector mapMultiply(double d2) {
        return this.copy().mapMultiplyToSelf(d2);
    }

    public RealVector mapMultiplyToSelf(double d2) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Multiply(), d2));
    }

    public RealVector mapSubtract(double d2) {
        return this.copy().mapSubtractToSelf(d2);
    }

    public RealVector mapSubtractToSelf(double d2) {
        return this.mapAddToSelf(-d2);
    }

    public RealVector mapDivide(double d2) {
        return this.copy().mapDivideToSelf(d2);
    }

    public RealVector mapDivideToSelf(double d2) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Divide(), d2));
    }

    public RealMatrix outerProduct(RealVector v) {
        int m3 = this.getDimension();
        int n2 = v.getDimension();
        AbstractRealMatrix product = v instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(m3, n2) : new Array2DRowRealMatrix(m3, n2);
        for (int i2 = 0; i2 < m3; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                product.setEntry(i2, j2, this.getEntry(i2) * v.getEntry(j2));
            }
        }
        return product;
    }

    public RealVector projection(RealVector v) throws DimensionMismatchException, MathArithmeticException {
        double norm2 = v.dotProduct(v);
        if (norm2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return v.mapMultiply(this.dotProduct(v) / v.dotProduct(v));
    }

    public void set(double value) {
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            e2.setValue(value);
        }
    }

    public double[] toArray() {
        int dim = this.getDimension();
        double[] values = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            values[i2] = this.getEntry(i2);
        }
        return values;
    }

    public RealVector unitVector() throws MathArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.mapDivide(norm);
    }

    public void unitize() throws MathArithmeticException {
        double norm = this.getNorm();
        if (norm == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.mapDivideToSelf(this.getNorm());
    }

    public Iterator<Entry> sparseIterator() {
        return new SparseEntryIterator();
    }

    public Iterator<Entry> iterator() {
        final int dim = this.getDimension();
        return new Iterator<Entry>(){
            private int i = 0;
            private Entry e = new Entry();

            @Override
            public boolean hasNext() {
                return this.i < dim;
            }

            @Override
            public Entry next() {
                if (this.i < dim) {
                    this.e.setIndex(this.i++);
                    return this.e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }
        };
    }

    public RealVector map(UnivariateFunction function) {
        return this.copy().mapToSelf(function);
    }

    public RealVector mapToSelf(UnivariateFunction function) {
        Iterator<Entry> it = this.iterator();
        while (it.hasNext()) {
            Entry e2 = it.next();
            e2.setValue(function.value(e2.getValue()));
        }
        return this;
    }

    public RealVector combine(double a2, double b2, RealVector y) throws DimensionMismatchException {
        return this.copy().combineToSelf(a2, b2, y);
    }

    public RealVector combineToSelf(double a2, double b2, RealVector y) throws DimensionMismatchException {
        this.checkVectorDimensions(y);
        for (int i2 = 0; i2 < this.getDimension(); ++i2) {
            double xi = this.getEntry(i2);
            double yi = y.getEntry(i2);
            this.setEntry(i2, a2 * xi + b2 * yi);
        }
        return this;
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor visitor) {
        int dim = this.getDimension();
        visitor.start(dim, 0, dim - 1);
        for (int i2 = 0; i2 < dim; ++i2) {
            visitor.visit(i2, this.getEntry(i2));
        }
        return visitor.end();
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor.start(this.getDimension(), start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            visitor.visit(i2, this.getEntry(i2));
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor visitor) {
        return this.walkInDefaultOrder(visitor);
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor, start, end);
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor visitor) {
        int dim = this.getDimension();
        visitor.start(dim, 0, dim - 1);
        for (int i2 = 0; i2 < dim; ++i2) {
            this.setEntry(i2, visitor.visit(i2, this.getEntry(i2)));
        }
        return visitor.end();
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor.start(this.getDimension(), start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            this.setEntry(i2, visitor.visit(i2, this.getEntry(i2)));
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor visitor) {
        return this.walkInDefaultOrder(visitor);
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor visitor, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor, start, end);
    }

    public boolean equals(Object other) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public int hashCode() throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public static RealVector unmodifiableRealVector(final RealVector v) {
        return new RealVector(){

            @Override
            public RealVector mapToSelf(UnivariateFunction function) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector map(UnivariateFunction function) {
                return v.map(function);
            }

            @Override
            public Iterator<Entry> iterator() {
                final Iterator<Entry> i2 = v.iterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return i2.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)i2.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() throws MathUnsupportedOperationException {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterator<Entry> sparseIterator() {
                final Iterator<Entry> i2 = v.sparseIterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return i2.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)i2.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() throws MathUnsupportedOperationException {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public RealVector copy() {
                return v.copy();
            }

            @Override
            public RealVector add(RealVector w) throws DimensionMismatchException {
                return v.add(w);
            }

            @Override
            public RealVector subtract(RealVector w) throws DimensionMismatchException {
                return v.subtract(w);
            }

            @Override
            public RealVector mapAdd(double d2) {
                return v.mapAdd(d2);
            }

            @Override
            public RealVector mapAddToSelf(double d2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapSubtract(double d2) {
                return v.mapSubtract(d2);
            }

            @Override
            public RealVector mapSubtractToSelf(double d2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapMultiply(double d2) {
                return v.mapMultiply(d2);
            }

            @Override
            public RealVector mapMultiplyToSelf(double d2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapDivide(double d2) {
                return v.mapDivide(d2);
            }

            @Override
            public RealVector mapDivideToSelf(double d2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector ebeMultiply(RealVector w) throws DimensionMismatchException {
                return v.ebeMultiply(w);
            }

            @Override
            public RealVector ebeDivide(RealVector w) throws DimensionMismatchException {
                return v.ebeDivide(w);
            }

            @Override
            public double dotProduct(RealVector w) throws DimensionMismatchException {
                return v.dotProduct(w);
            }

            @Override
            public double cosine(RealVector w) throws DimensionMismatchException, MathArithmeticException {
                return v.cosine(w);
            }

            @Override
            public double getNorm() {
                return v.getNorm();
            }

            @Override
            public double getL1Norm() {
                return v.getL1Norm();
            }

            @Override
            public double getLInfNorm() {
                return v.getLInfNorm();
            }

            @Override
            public double getDistance(RealVector w) throws DimensionMismatchException {
                return v.getDistance(w);
            }

            @Override
            public double getL1Distance(RealVector w) throws DimensionMismatchException {
                return v.getL1Distance(w);
            }

            @Override
            public double getLInfDistance(RealVector w) throws DimensionMismatchException {
                return v.getLInfDistance(w);
            }

            @Override
            public RealVector unitVector() throws MathArithmeticException {
                return v.unitVector();
            }

            @Override
            public void unitize() throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealMatrix outerProduct(RealVector w) {
                return v.outerProduct(w);
            }

            @Override
            public double getEntry(int index) throws OutOfRangeException {
                return v.getEntry(index);
            }

            @Override
            public void setEntry(int index, double value) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void addToEntry(int index, double value) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public int getDimension() {
                return v.getDimension();
            }

            @Override
            public RealVector append(RealVector w) {
                return v.append(w);
            }

            @Override
            public RealVector append(double d2) {
                return v.append(d2);
            }

            @Override
            public RealVector getSubVector(int index, int n2) throws OutOfRangeException, NotPositiveException {
                return v.getSubVector(index, n2);
            }

            @Override
            public void setSubVector(int index, RealVector w) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void set(double value) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public double[] toArray() {
                return v.toArray();
            }

            @Override
            public boolean isNaN() {
                return v.isNaN();
            }

            @Override
            public boolean isInfinite() {
                return v.isInfinite();
            }

            @Override
            public RealVector combine(double a2, double b2, RealVector y) throws DimensionMismatchException {
                return v.combine(a2, b2, y);
            }

            @Override
            public RealVector combineToSelf(double a2, double b2, RealVector y) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            class UnmodifiableEntry
            extends Entry {
                UnmodifiableEntry() {
                }

                public double getValue() {
                    return v.getEntry(this.getIndex());
                }

                public void setValue(double value) throws MathUnsupportedOperationException {
                    throw new MathUnsupportedOperationException();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SparseEntryIterator
    implements Iterator<Entry> {
        private final int dim;
        private Entry current;
        private Entry next;

        protected SparseEntryIterator() {
            this.dim = RealVector.this.getDimension();
            this.current = new Entry();
            this.next = new Entry();
            if (this.next.getValue() == 0.0) {
                this.advance(this.next);
            }
        }

        protected void advance(Entry e2) {
            if (e2 == null) {
                return;
            }
            do {
                e2.setIndex(e2.getIndex() + 1);
            } while (e2.getIndex() < this.dim && e2.getValue() == 0.0);
            if (e2.getIndex() >= this.dim) {
                e2.setIndex(-1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next.getIndex() >= 0;
        }

        @Override
        public Entry next() {
            int index = this.next.getIndex();
            if (index < 0) {
                throw new NoSuchElementException();
            }
            this.current.setIndex(index);
            this.advance(this.next);
            return this.current;
        }

        @Override
        public void remove() throws MathUnsupportedOperationException {
            throw new MathUnsupportedOperationException();
        }
    }

    protected class Entry {
        private int index;

        public Entry() {
            this.setIndex(0);
        }

        public double getValue() {
            return RealVector.this.getEntry(this.getIndex());
        }

        public void setValue(double value) {
            RealVector.this.setEntry(this.getIndex(), value);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

