/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int r2, double p2) throws NotStrictlyPositiveException, OutOfRangeException {
        this(new Well19937c(), r2, p2);
    }

    public PascalDistribution(RandomGenerator rng, int r2, double p2) throws NotStrictlyPositiveException, OutOfRangeException {
        super(rng);
        if (r2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, r2);
        }
        if (p2 < 0.0 || p2 > 1.0) {
            throw new OutOfRangeException(p2, (Number)0, 1);
        }
        this.numberOfSuccesses = r2;
        this.probabilityOfSuccess = p2;
        this.logProbabilityOfSuccess = FastMath.log(p2);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-p2);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int x) {
        double ret = x < 0 ? 0.0 : CombinatoricsUtils.binomialCoefficientDouble(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, x);
        return ret;
    }

    public double logProbability(int x) {
        double ret = x < 0 ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)x;
        return ret;
    }

    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)x + 1.0);
        return ret;
    }

    public double getNumericalMean() {
        double p2 = this.getProbabilityOfSuccess();
        double r2 = this.getNumberOfSuccesses();
        return r2 * (1.0 - p2) / p2;
    }

    public double getNumericalVariance() {
        double p2 = this.getProbabilityOfSuccess();
        double r2 = this.getNumberOfSuccesses();
        return r2 * (1.0 - p2) / (p2 * p2);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

