/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;

public class DfpDec
extends Dfp {
    protected DfpDec(DfpField factory) {
        super(factory);
    }

    protected DfpDec(DfpField factory, byte x) {
        super(factory, x);
    }

    protected DfpDec(DfpField factory, int x) {
        super(factory, x);
    }

    protected DfpDec(DfpField factory, long x) {
        super(factory, x);
    }

    protected DfpDec(DfpField factory, double x) {
        super(factory, x);
        this.round(0);
    }

    public DfpDec(Dfp d2) {
        super(d2);
        this.round(0);
    }

    protected DfpDec(DfpField factory, String s2) {
        super(factory, s2);
        this.round(0);
    }

    protected DfpDec(DfpField factory, byte sign, byte nans) {
        super(factory, sign, nans);
    }

    public Dfp newInstance() {
        return new DfpDec(this.getField());
    }

    public Dfp newInstance(byte x) {
        return new DfpDec(this.getField(), x);
    }

    public Dfp newInstance(int x) {
        return new DfpDec(this.getField(), x);
    }

    public Dfp newInstance(long x) {
        return new DfpDec(this.getField(), x);
    }

    public Dfp newInstance(double x) {
        return new DfpDec(this.getField(), x);
    }

    public Dfp newInstance(Dfp d2) {
        if (this.getField().getRadixDigits() != d2.getField().getRadixDigits()) {
            this.getField().setIEEEFlagsBits(1);
            Dfp result = this.newInstance(this.getZero());
            result.nans = (byte)3;
            return this.dotrap(1, "newInstance", d2, result);
        }
        return new DfpDec(d2);
    }

    public Dfp newInstance(String s2) {
        return new DfpDec(this.getField(), s2);
    }

    public Dfp newInstance(byte sign, byte nans) {
        return new DfpDec(this.getField(), sign, nans);
    }

    protected int getDecimalDigits() {
        return this.getRadixDigits() * 4 - 3;
    }

    protected int round(int in) {
        boolean inc;
        int n2;
        int msb = this.mant[this.mant.length - 1];
        if (msb == 0) {
            return 0;
        }
        int cmaxdigits = this.mant.length * 4;
        int lsbthreshold = 1000;
        while (lsbthreshold > msb) {
            lsbthreshold /= 10;
            --cmaxdigits;
        }
        int digits = this.getDecimalDigits();
        int lsbshift = cmaxdigits - digits;
        int lsd = lsbshift / 4;
        lsbthreshold = 1;
        for (int i2 = 0; i2 < lsbshift % 4; ++i2) {
            lsbthreshold *= 10;
        }
        int lsb = this.mant[lsd];
        if (lsbthreshold <= 1 && digits == 4 * this.mant.length - 3) {
            return super.round(in);
        }
        int discarded = in;
        if (lsbthreshold == 1) {
            n2 = this.mant[lsd - 1] / 1000 % 10;
            int n3 = lsd - 1;
            this.mant[n3] = this.mant[n3] % 1000;
            discarded |= this.mant[lsd - 1];
        } else {
            n2 = lsb * 10 / lsbthreshold % 10;
            discarded |= lsb % (lsbthreshold / 10);
        }
        for (int i3 = 0; i3 < lsd; ++i3) {
            discarded |= this.mant[i3];
            this.mant[i3] = 0;
        }
        this.mant[lsd] = lsb / lsbthreshold * lsbthreshold;
        switch (this.getField().getRoundingMode()) {
            case ROUND_DOWN: {
                inc = false;
                break;
            }
            case ROUND_UP: {
                inc = n2 != 0 || discarded != 0;
                break;
            }
            case ROUND_HALF_UP: {
                inc = n2 >= 5;
                break;
            }
            case ROUND_HALF_DOWN: {
                inc = n2 > 5;
                break;
            }
            case ROUND_HALF_EVEN: {
                inc = n2 > 5 || n2 == 5 && discarded != 0 || n2 == 5 && discarded == 0 && (lsb / lsbthreshold & 1) == 1;
                break;
            }
            case ROUND_HALF_ODD: {
                inc = n2 > 5 || n2 == 5 && discarded != 0 || n2 == 5 && discarded == 0 && (lsb / lsbthreshold & 1) == 0;
                break;
            }
            case ROUND_CEIL: {
                inc = this.sign == 1 && (n2 != 0 || discarded != 0);
                break;
            }
            default: {
                boolean bl = inc = this.sign == -1 && (n2 != 0 || discarded != 0);
            }
        }
        if (inc) {
            int rh = lsbthreshold;
            for (int i4 = lsd; i4 < this.mant.length; ++i4) {
                int r2 = this.mant[i4] + rh;
                rh = r2 / 10000;
                this.mant[i4] = r2 % 10000;
            }
            if (rh != 0) {
                this.shiftRight();
                this.mant[this.mant.length - 1] = rh;
            }
        }
        if (this.exp < -32767) {
            this.getField().setIEEEFlagsBits(8);
            return 8;
        }
        if (this.exp > 32768) {
            this.getField().setIEEEFlagsBits(4);
            return 4;
        }
        if (n2 != 0 || discarded != 0) {
            this.getField().setIEEEFlagsBits(16);
            return 16;
        }
        return 0;
    }

    public Dfp nextAfter(Dfp x) {
        Dfp result;
        String trapName = "nextAfter";
        if (this.getField().getRadixDigits() != x.getField().getRadixDigits()) {
            this.getField().setIEEEFlagsBits(1);
            Dfp result2 = this.newInstance(this.getZero());
            result2.nans = (byte)3;
            return this.dotrap(1, "nextAfter", x, result2);
        }
        boolean up = false;
        if (this.lessThan(x)) {
            up = true;
        }
        if (this.equals(x)) {
            return this.newInstance(x);
        }
        if (this.lessThan(this.getZero())) {
            boolean bl = up = !up;
        }
        if (up) {
            Dfp inc = this.power10(this.intLog10() - this.getDecimalDigits() + 1);
            inc = DfpDec.copysign(inc, this);
            if (this.equals(this.getZero())) {
                inc = this.power10K(-32767 - this.mant.length - 1);
            }
            result = inc.equals(this.getZero()) ? DfpDec.copysign(this.newInstance(this.getZero()), this) : this.add(inc);
        } else {
            Dfp inc = this.power10(this.intLog10());
            inc = this.equals(inc = DfpDec.copysign(inc, this)) ? inc.divide(this.power10(this.getDecimalDigits())) : inc.divide(this.power10(this.getDecimalDigits() - 1));
            if (this.equals(this.getZero())) {
                inc = this.power10K(-32767 - this.mant.length - 1);
            }
            result = inc.equals(this.getZero()) ? DfpDec.copysign(this.newInstance(this.getZero()), this) : this.subtract(inc);
        }
        if (result.classify() == 1 && this.classify() != 1) {
            this.getField().setIEEEFlagsBits(16);
            result = this.dotrap(16, "nextAfter", x, result);
        }
        if (result.equals(this.getZero()) && !this.equals(this.getZero())) {
            this.getField().setIEEEFlagsBits(16);
            result = this.dotrap(16, "nextAfter", x, result);
        }
        return result;
    }
}

