/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class PolynomialFunctionLagrangeForm
implements UnivariateFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
        if (!PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, false)) {
            MathArrays.sortInPlace(this.x, new double[][]{this.y});
            PolynomialFunctionLagrangeForm.verifyInterpolationArray(this.x, this.y, true);
        }
    }

    public double value(double z) {
        return PolynomialFunctionLagrangeForm.evaluateInternal(this.x, this.y, z);
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x, double[] y, double z) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, false)) {
            return PolynomialFunctionLagrangeForm.evaluateInternal(x, y, z);
        }
        double[] xNew = new double[x.length];
        double[] yNew = new double[y.length];
        System.arraycopy(x, 0, xNew, 0, x.length);
        System.arraycopy(y, 0, yNew, 0, y.length);
        MathArrays.sortInPlace(xNew, new double[][]{yNew});
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(xNew, yNew, true);
        return PolynomialFunctionLagrangeForm.evaluateInternal(xNew, yNew, z);
    }

    private static double evaluateInternal(double[] x, double[] y, double z) {
        int nearest = 0;
        int n2 = x.length;
        double[] c2 = new double[n2];
        double[] d2 = new double[n2];
        double min_dist = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < n2; ++i2) {
            c2[i2] = y[i2];
            d2[i2] = y[i2];
            double dist = FastMath.abs(z - x[i2]);
            if (!(dist < min_dist)) continue;
            nearest = i2;
            min_dist = dist;
        }
        double value = y[nearest];
        for (int i3 = 1; i3 < n2; ++i3) {
            for (int j2 = 0; j2 < n2 - i3; ++j2) {
                double tc = x[j2] - z;
                double td = x[i3 + j2] - z;
                double divider = x[j2] - x[i3 + j2];
                double w = (c2[j2 + 1] - d2[j2]) / divider;
                c2[j2] = tc * w;
                d2[j2] = td * w;
            }
            if ((double)nearest < 0.5 * (double)(n2 - i3 + 1)) {
                value += c2[nearest];
                continue;
            }
            value += d2[--nearest];
        }
        return value;
    }

    protected void computeCoefficients() {
        int n2 = this.degree() + 1;
        this.coefficients = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.coefficients[i2] = 0.0;
        }
        double[] c2 = new double[n2 + 1];
        c2[0] = 1.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int j2 = i3; j2 > 0; --j2) {
                c2[j2] = c2[j2 - 1] - c2[j2] * this.x[i3];
            }
            c2[0] = c2[0] * -this.x[i3];
            c2[i3 + 1] = 1.0;
        }
        double[] tc = new double[n2];
        for (int i4 = 0; i4 < n2; ++i4) {
            double d2 = 1.0;
            for (int j3 = 0; j3 < n2; ++j3) {
                if (i4 == j3) continue;
                d2 *= this.x[i4] - this.x[j3];
            }
            double t = this.y[i4] / d2;
            tc[n2 - 1] = c2[n2];
            int n3 = n2 - 1;
            this.coefficients[n3] = this.coefficients[n3] + t * tc[n2 - 1];
            for (int j4 = n2 - 2; j4 >= 0; --j4) {
                tc[j4] = c2[j4 + 1] + tc[j4 + 1] * this.x[i4];
                int n4 = j4;
                this.coefficients[n4] = this.coefficients[n4] + t * tc[j4];
            }
        }
        this.coefficientsComputed = true;
    }

    public static boolean verifyInterpolationArray(double[] x, double[] y, boolean abort) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)2, x.length, true);
        }
        return MathArrays.checkOrder(x, MathArrays.OrderDirection.INCREASING, true, abort);
    }
}

