/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseGradient
implements RealFieldElement<SparseGradient>,
Serializable {
    private static final long serialVersionUID = 20131025L;
    private double value;
    private final Map<Integer, Double> derivatives;

    private SparseGradient(double value, Map<Integer, Double> derivatives) {
        this.value = value;
        this.derivatives = new HashMap<Integer, Double>();
        if (derivatives != null) {
            this.derivatives.putAll(derivatives);
        }
    }

    private SparseGradient(double value, double scale, Map<Integer, Double> derivatives) {
        this.value = value;
        this.derivatives = new HashMap<Integer, Double>();
        if (derivatives != null) {
            for (Map.Entry<Integer, Double> entry : derivatives.entrySet()) {
                this.derivatives.put(entry.getKey(), scale * entry.getValue());
            }
        }
    }

    public static SparseGradient createConstant(double value) {
        return new SparseGradient(value, Collections.<Integer, Double>emptyMap());
    }

    public static SparseGradient createVariable(int idx, double value) {
        return new SparseGradient(value, Collections.singletonMap(idx, 1.0));
    }

    public int numVars() {
        return this.derivatives.size();
    }

    public double getDerivative(int index) {
        Double out = this.derivatives.get(index);
        return out == null ? 0.0 : out;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getReal() {
        return this.value;
    }

    @Override
    public SparseGradient add(SparseGradient a2) {
        SparseGradient out = new SparseGradient(this.value + a2.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, entry.getValue());
                continue;
            }
            out.derivatives.put(id, old + entry.getValue());
        }
        return out;
    }

    public void addInPlace(SparseGradient a2) {
        this.value += a2.value;
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = this.derivatives.get(id);
            if (old == null) {
                this.derivatives.put(id, entry.getValue());
                continue;
            }
            this.derivatives.put(id, old + entry.getValue());
        }
    }

    @Override
    public SparseGradient add(double c2) {
        SparseGradient out = new SparseGradient(this.value + c2, this.derivatives);
        return out;
    }

    @Override
    public SparseGradient subtract(SparseGradient a2) {
        SparseGradient out = new SparseGradient(this.value - a2.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, -entry.getValue().doubleValue());
                continue;
            }
            out.derivatives.put(id, old - entry.getValue());
        }
        return out;
    }

    @Override
    public SparseGradient subtract(double c2) {
        return new SparseGradient(this.value - c2, this.derivatives);
    }

    @Override
    public SparseGradient multiply(SparseGradient a2) {
        SparseGradient out = new SparseGradient(this.value * a2.value, Collections.<Integer, Double>emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), a2.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, this.value * entry.getValue());
                continue;
            }
            out.derivatives.put(id, old + this.value * entry.getValue());
        }
        return out;
    }

    public void multiplyInPlace(SparseGradient a2) {
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            this.derivatives.put(entry.getKey(), a2.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = this.derivatives.get(id);
            if (old == null) {
                this.derivatives.put(id, this.value * entry.getValue());
                continue;
            }
            this.derivatives.put(id, old + this.value * entry.getValue());
        }
        this.value *= a2.value;
    }

    @Override
    public SparseGradient multiply(double c2) {
        return new SparseGradient(this.value * c2, c2, this.derivatives);
    }

    @Override
    public SparseGradient multiply(int n2) {
        return new SparseGradient(this.value * (double)n2, n2, this.derivatives);
    }

    @Override
    public SparseGradient divide(SparseGradient a2) {
        SparseGradient out = new SparseGradient(this.value / a2.value, Collections.<Integer, Double>emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), entry.getValue() / a2.value);
        }
        for (Map.Entry<Integer, Double> entry : a2.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, -out.value / a2.value * entry.getValue());
                continue;
            }
            out.derivatives.put(id, old - out.value / a2.value * entry.getValue());
        }
        return out;
    }

    @Override
    public SparseGradient divide(double c2) {
        return new SparseGradient(this.value / c2, 1.0 / c2, this.derivatives);
    }

    @Override
    public SparseGradient negate() {
        return new SparseGradient(-this.value, -1.0, this.derivatives);
    }

    @Override
    public Field<SparseGradient> getField() {
        return new Field<SparseGradient>(){

            @Override
            public SparseGradient getZero() {
                return SparseGradient.createConstant(0.0);
            }

            @Override
            public SparseGradient getOne() {
                return SparseGradient.createConstant(1.0);
            }

            @Override
            public Class<? extends FieldElement<SparseGradient>> getRuntimeClass() {
                return SparseGradient.class;
            }
        };
    }

    @Override
    public SparseGradient remainder(double a2) {
        return new SparseGradient(FastMath.IEEEremainder(this.value, a2), this.derivatives);
    }

    @Override
    public SparseGradient remainder(SparseGradient a2) {
        double rem = FastMath.IEEEremainder(this.value, a2.value);
        double k2 = FastMath.rint((this.value - rem) / a2.value);
        return this.subtract(a2.multiply(k2));
    }

    @Override
    public SparseGradient abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public SparseGradient ceil() {
        return SparseGradient.createConstant(FastMath.ceil(this.value));
    }

    @Override
    public SparseGradient floor() {
        return SparseGradient.createConstant(FastMath.floor(this.value));
    }

    @Override
    public SparseGradient rint() {
        return SparseGradient.createConstant(FastMath.rint(this.value));
    }

    @Override
    public long round() {
        return FastMath.round(this.value);
    }

    @Override
    public SparseGradient signum() {
        return SparseGradient.createConstant(FastMath.signum(this.value));
    }

    @Override
    public SparseGradient copySign(SparseGradient sign) {
        long m3 = Double.doubleToLongBits(this.value);
        long s2 = Double.doubleToLongBits(sign.value);
        if (m3 >= 0L && s2 >= 0L || m3 < 0L && s2 < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public SparseGradient copySign(double sign) {
        long m3 = Double.doubleToLongBits(this.value);
        long s2 = Double.doubleToLongBits(sign);
        if (m3 >= 0L && s2 >= 0L || m3 < 0L && s2 < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public SparseGradient scalb(int n2) {
        SparseGradient out = new SparseGradient(FastMath.scalb(this.value, n2), Collections.<Integer, Double>emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), FastMath.scalb(entry.getValue(), n2));
        }
        return out;
    }

    @Override
    public SparseGradient hypot(SparseGradient y) {
        int expY;
        if (Double.isInfinite(this.value) || Double.isInfinite(y.value)) {
            return SparseGradient.createConstant(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value) || Double.isNaN(y.value)) {
            return SparseGradient.createConstant(Double.NaN);
        }
        int expX = FastMath.getExponent(this.value);
        if (expX > (expY = FastMath.getExponent(y.value)) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        SparseGradient scaledX = this.scalb(-middleExp);
        SparseGradient scaledY = y.scalb(-middleExp);
        SparseGradient scaledH = scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    public static SparseGradient hypot(SparseGradient x, SparseGradient y) {
        return x.hypot(y);
    }

    @Override
    public SparseGradient reciprocal() {
        return new SparseGradient(1.0 / this.value, -1.0 / (this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient sqrt() {
        double sqrt = FastMath.sqrt(this.value);
        return new SparseGradient(sqrt, 0.5 / sqrt, this.derivatives);
    }

    @Override
    public SparseGradient cbrt() {
        double cbrt = FastMath.cbrt(this.value);
        return new SparseGradient(cbrt, 1.0 / (3.0 * cbrt * cbrt), this.derivatives);
    }

    @Override
    public SparseGradient rootN(int n2) {
        if (n2 == 2) {
            return this.sqrt();
        }
        if (n2 == 3) {
            return this.cbrt();
        }
        double root = FastMath.pow(this.value, 1.0 / (double)n2);
        return new SparseGradient(root, 1.0 / ((double)n2 * FastMath.pow(root, n2 - 1)), this.derivatives);
    }

    @Override
    public SparseGradient pow(double p2) {
        return new SparseGradient(FastMath.pow(this.value, p2), p2 * FastMath.pow(this.value, p2 - 1.0), this.derivatives);
    }

    @Override
    public SparseGradient pow(int n2) {
        if (n2 == 0) {
            return this.getField().getOne();
        }
        double valueNm1 = FastMath.pow(this.value, n2 - 1);
        return new SparseGradient(this.value * valueNm1, (double)n2 * valueNm1, this.derivatives);
    }

    @Override
    public SparseGradient pow(SparseGradient e2) {
        return this.log().multiply(e2).exp();
    }

    public static SparseGradient pow(double a2, SparseGradient x) {
        if (a2 == 0.0) {
            if (x.value == 0.0) {
                return x.compose(1.0, Double.NEGATIVE_INFINITY);
            }
            if (x.value < 0.0) {
                return x.compose(Double.NaN, Double.NaN);
            }
            return x.getField().getZero();
        }
        double ax = FastMath.pow(a2, x.value);
        return new SparseGradient(ax, ax * FastMath.log(a2), x.derivatives);
    }

    @Override
    public SparseGradient exp() {
        double e2 = FastMath.exp(this.value);
        return new SparseGradient(e2, e2, this.derivatives);
    }

    @Override
    public SparseGradient expm1() {
        return new SparseGradient(FastMath.expm1(this.value), FastMath.exp(this.value), this.derivatives);
    }

    @Override
    public SparseGradient log() {
        return new SparseGradient(FastMath.log(this.value), 1.0 / this.value, this.derivatives);
    }

    public SparseGradient log10() {
        return new SparseGradient(FastMath.log10(this.value), 1.0 / (FastMath.log(10.0) * this.value), this.derivatives);
    }

    @Override
    public SparseGradient log1p() {
        return new SparseGradient(FastMath.log1p(this.value), 1.0 / (1.0 + this.value), this.derivatives);
    }

    @Override
    public SparseGradient cos() {
        return new SparseGradient(FastMath.cos(this.value), -FastMath.sin(this.value), this.derivatives);
    }

    @Override
    public SparseGradient sin() {
        return new SparseGradient(FastMath.sin(this.value), FastMath.cos(this.value), this.derivatives);
    }

    @Override
    public SparseGradient tan() {
        double t = FastMath.tan(this.value);
        return new SparseGradient(t, 1.0 + t * t, this.derivatives);
    }

    @Override
    public SparseGradient acos() {
        return new SparseGradient(FastMath.acos(this.value), -1.0 / FastMath.sqrt(1.0 - this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient asin() {
        return new SparseGradient(FastMath.asin(this.value), 1.0 / FastMath.sqrt(1.0 - this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient atan() {
        return new SparseGradient(FastMath.atan(this.value), 1.0 / (1.0 + this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient atan2(SparseGradient x) {
        SparseGradient a2;
        SparseGradient r2 = this.multiply(this).add(x.multiply(x)).sqrt();
        if (x.value >= 0.0) {
            a2 = this.divide(r2.add(x)).atan().multiply(2);
        } else {
            SparseGradient tmp = this.divide(r2.subtract(x)).atan().multiply(-2);
            a2 = tmp.add(tmp.value <= 0.0 ? -Math.PI : Math.PI);
        }
        a2.value = FastMath.atan2(this.value, x.value);
        return a2;
    }

    public static SparseGradient atan2(SparseGradient y, SparseGradient x) {
        return y.atan2(x);
    }

    @Override
    public SparseGradient cosh() {
        return new SparseGradient(FastMath.cosh(this.value), FastMath.sinh(this.value), this.derivatives);
    }

    @Override
    public SparseGradient sinh() {
        return new SparseGradient(FastMath.sinh(this.value), FastMath.cosh(this.value), this.derivatives);
    }

    @Override
    public SparseGradient tanh() {
        double t = FastMath.tanh(this.value);
        return new SparseGradient(t, 1.0 - t * t, this.derivatives);
    }

    @Override
    public SparseGradient acosh() {
        return new SparseGradient(FastMath.acosh(this.value), 1.0 / FastMath.sqrt(this.value * this.value - 1.0), this.derivatives);
    }

    @Override
    public SparseGradient asinh() {
        return new SparseGradient(FastMath.asinh(this.value), 1.0 / FastMath.sqrt(this.value * this.value + 1.0), this.derivatives);
    }

    @Override
    public SparseGradient atanh() {
        return new SparseGradient(FastMath.atanh(this.value), 1.0 / (1.0 - this.value * this.value), this.derivatives);
    }

    public SparseGradient toDegrees() {
        return new SparseGradient(FastMath.toDegrees(this.value), FastMath.toDegrees(1.0), this.derivatives);
    }

    public SparseGradient toRadians() {
        return new SparseGradient(FastMath.toRadians(this.value), FastMath.toRadians(1.0), this.derivatives);
    }

    public double taylor(double ... delta) {
        double y = this.value;
        for (int i2 = 0; i2 < delta.length; ++i2) {
            y += delta[i2] * this.getDerivative(i2);
        }
        return y;
    }

    public SparseGradient compose(double f0, double f1) {
        return new SparseGradient(f0, f1, this.derivatives);
    }

    public SparseGradient linearCombination(SparseGradient[] a2, SparseGradient[] b2) throws DimensionMismatchException {
        SparseGradient out = a2[0].getField().getZero();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            out = out.add(a2[i2].multiply(b2[i2]));
        }
        double[] aDouble = new double[a2.length];
        for (int i3 = 0; i3 < a2.length; ++i3) {
            aDouble[i3] = a2[i3].getValue();
        }
        double[] bDouble = new double[b2.length];
        for (int i4 = 0; i4 < b2.length; ++i4) {
            bDouble[i4] = b2[i4].getValue();
        }
        out.value = MathArrays.linearCombination(aDouble, bDouble);
        return out;
    }

    public SparseGradient linearCombination(double[] a2, SparseGradient[] b2) {
        SparseGradient out = b2[0].getField().getZero();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            out = out.add(b2[i2].multiply(a2[i2]));
        }
        double[] bDouble = new double[b2.length];
        for (int i3 = 0; i3 < b2.length; ++i3) {
            bDouble[i3] = b2[i3].getValue();
        }
        out.value = MathArrays.linearCombination(a2, bDouble);
        return out;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2));
        out.value = MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value);
        return out;
    }

    @Override
    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2));
        out.value = MathArrays.linearCombination(a1, b1.value, a2, b2.value);
        return out;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2, SparseGradient a3, SparseGradient b3) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3));
        out.value = MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value);
        return out;
    }

    @Override
    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2, double a3, SparseGradient b3) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2)).add(b3.multiply(a3));
        out.value = MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value);
        return out;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2, SparseGradient a3, SparseGradient b3, SparseGradient a4, SparseGradient b4) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3)).add(a4.multiply(b4));
        out.value = MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value);
        return out;
    }

    @Override
    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2, double a3, SparseGradient b3, double a4, SparseGradient b4) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2)).add(b3.multiply(a3)).add(b4.multiply(a4));
        out.value = MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value);
        return out;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SparseGradient) {
            SparseGradient rhs = (SparseGradient)other;
            if (!Precision.equals(this.value, rhs.value, 1)) {
                return false;
            }
            if (this.derivatives.size() != rhs.derivatives.size()) {
                return false;
            }
            for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
                if (!rhs.derivatives.containsKey(entry.getKey())) {
                    return false;
                }
                if (Precision.equals((double)entry.getValue(), (double)rhs.derivatives.get(entry.getKey()), 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 743 + 809 * MathUtils.hash(this.value) + 167 * this.derivatives.hashCode();
    }
}

