/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());

    private FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
            }
            return cl;
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static <T> Object find(String factoryId, Class<T> service) throws ClassNotFoundException {
        block22: {
            block20: {
                block21: {
                    classLoader = FactoryFinder.getContextClassLoader();
                    result = FactoryFinder.findFirstService(factoryId, classLoader, service);
                    if (result != null) {
                        return result;
                    }
                    result = FactoryFinder.findFirstService(factoryId, FactoryFinder.getClassLoader(), service);
                    if (result != null) {
                        return result;
                    }
                    inputStream = null;
                    configFile = null;
                    javah = System.getProperty("java.home");
                    configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                    f = new File(configFile);
                    if (!f.exists()) break block20;
                    props = new Properties();
                    inputStream = new FileInputStream(f);
                    props.load(inputStream);
                    factoryClassName = props.getProperty(factoryId);
                    var10_14 = FactoryFinder.newInstance(factoryClassName, classLoader);
                    if (inputStream == null) break block21;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
                return var10_14;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
            }
            break block22;
            catch (Exception ex) {
                try {
                    FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
                    ** if (inputStream == null) goto lbl-1000
                }
                catch (Throwable var12_16) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                        }
                    }
                    throw var12_16;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
        try {
            systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
        }
        throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            return FactoryFinder.class.getClassLoader();
        }
        return AccessController.doPrivileged(FactoryFinder.class::getClassLoader);
    }

    private static <T> T findFirstService(String factoryId, ClassLoader cl, Class<T> service) {
        PrivilegedAction<Object> action = () -> {
            try {
                ServiceLoader loader = ServiceLoader.load(service, cl);
                if (loader.iterator().hasNext()) {
                    return loader.iterator().next();
                }
            }
            catch (Exception e2) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", e2);
            }
            return null;
        };
        if (System.getSecurityManager() == null) {
            return (T)action.run();
        }
        return (T)AccessController.doPrivileged(action);
    }
}

