/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smibridge;

import com.snmp4j.smi.CompilationMonitor;
import java.awt.Component;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class CompilerProgressMonitor
implements CompilationMonitor {
    private Component parentComponent;
    private ProgressMonitor progressMonitorLoading;
    private ProgressMonitor progressMonitorSorting;
    private ProgressMonitor progressMonitorCompilation;

    public CompilerProgressMonitor(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public boolean loadingProgress(String s2, int current, int maxCount) {
        if (this.progressMonitorLoading == null) {
            if (this.progressMonitorCompilation != null) {
                this.progressMonitorCompilation.close();
            }
            this.progressMonitorLoading = new ProgressMonitor(this.parentComponent, "Loading...", s2, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorLoading, s2, current));
        }
        return !this.progressMonitorLoading.isCanceled();
    }

    @Override
    public boolean sortingProgress(String s2, int current, int maxCount) {
        if (this.progressMonitorSorting == null) {
            this.progressMonitorSorting = new ProgressMonitor(this.parentComponent, "Sorting...", s2, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorSorting, s2, current));
        }
        return !this.progressMonitorSorting.isCanceled();
    }

    @Override
    public boolean compilationProgress(String s2, int current, int maxCount) {
        if (this.progressMonitorCompilation == null) {
            if (this.progressMonitorSorting != null) {
                this.progressMonitorSorting.close();
            }
            this.progressMonitorCompilation = new ProgressMonitor(this.parentComponent, "Compiling...", s2, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorCompilation, s2, current));
        }
        return !this.progressMonitorCompilation.isCanceled();
    }

    public void close() {
        if (this.progressMonitorLoading != null) {
            this.progressMonitorLoading.close();
            this.progressMonitorLoading = null;
        }
        if (this.progressMonitorCompilation != null) {
            this.progressMonitorCompilation.close();
            this.progressMonitorCompilation = null;
        }
        if (this.progressMonitorSorting != null) {
            this.progressMonitorSorting.close();
            this.progressMonitorSorting = null;
        }
    }

    private class SwingUpdater
    implements Runnable {
        private ProgressMonitor progressMonitor;
        private String message;
        private int current;

        private SwingUpdater(ProgressMonitor progressMonitor, String message, int current) {
            this.progressMonitor = progressMonitor;
            this.message = message;
            this.current = current;
        }

        @Override
        public void run() {
            this.progressMonitor.setProgress(this.current);
            this.progressMonitor.setNote(this.message);
        }
    }
}

