/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.arch.Arch;
import com.sitraka.licensing.util.os.Unix;
import java.io.File;

class OS390
extends Unix {
    private static final Logger logger = Logger.getLogger();
    public static final String OS_NAME = "os/390";

    OS390() {
    }

    public String getName() {
        return OS_NAME;
    }

    protected boolean matches(String string, String string2) {
        return string.indexOf("z/os") != -1 || string.indexOf(OS_NAME) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getProcessorsImpl() {
        int n2 = -2;
        File file = null;
        try {
            file = this.extractHostInfo("os390", Arch.getCurrent().getName());
            String[] stringArray = new String[]{file.getAbsolutePath(), "--cpu"};
            String string = OS390.executeCommand(stringArray);
            n2 = Integer.parseInt(string.trim());
            if (n2 <= 0) {
                logger.warning(this, "warn.onlineProcessors.notValid");
                n2 = -2;
            }
        }
        catch (Exception exception) {
            logger.error(this, "error.cpuinfo.exception", exception);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        physicalCPUCount = n2;
        onlineCPUCount = n2;
    }
}

