/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.os.OS;
import com.sitraka.licensing.util.os.Unix;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MacOsX
extends Unix {
    private static Method openURL;
    private static final Logger logger;
    public static final String OS_NAME = "macosx";
    static /* synthetic */ Class class$java$lang$String;

    protected MacOsX() {
        this.setBrowserLaunchStrategy(this.getDefaultBrowserLaunchStrategy());
    }

    public String getName() {
        return OS_NAME;
    }

    protected boolean matches(String string, String string2) {
        if (string.indexOf("mac") != -1) {
            try {
                int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(46)));
                if (n2 >= 10) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug(this, "Ignoring invalid version number " + string2, numberFormatException);
            }
        }
        return false;
    }

    private OS.BrowserLaunchStrategy getDefaultBrowserLaunchStrategy() {
        return new OS.BrowserLaunchStrategy(){

            public boolean displayURL(String string) {
                if (openURL == null) {
                    try {
                        Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                        openURL = clazz.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = MacOsX.class$("java.lang.String")) : class$java$lang$String);
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        logger.debug(this, "Ignoring error, just checking for the class", exceptionInInitializerError);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.debug(this, "Ignoring error, just checking for the class", classNotFoundException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        logger.debug(this, "Ignoring error, just checking for the class", noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        logger.debug(this, "Ignoring error, just checking for the class", securityException);
                    }
                }
                if (openURL != null) {
                    try {
                        openURL.invoke(null, string);
                        return true;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        logger.debug(this, "Ignoring error, can't diplay URL with this Method", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.debug(this, "Ignoring error, can't diplay URL with this Method", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        logger.debug(this, "Ignoring error, can't diplay URL with this Method", invocationTargetException);
                    }
                }
                return false;
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = Logger.getLogger();
    }
}

