/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.arch;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.PropertyUtils;
import com.sitraka.licensing.util.arch.Arch;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

class PowerPC
extends Arch {
    private static final Logger logger = Logger.getLogger();
    private static final String ARCH_NAME = "powerpc";
    private static final String CPU_COMMAND = "/usr/sbin/prtconf";
    private static final String PROC_STRING = "Number Of Processors: ";
    private static final String CORE_STRING = "Full Core: ";
    static /* synthetic */ Class class$com$sitraka$licensing$util$arch$PowerPC;

    PowerPC() {
    }

    public String getName() {
        return ARCH_NAME;
    }

    protected boolean matches(String string) {
        return string.indexOf("ppc") != -1 || string.indexOf(ARCH_NAME) != -1;
    }

    public int[] parseCPUInfo(String string) {
        int[] nArray = new int[]{-2, -2, -2};
        nArray[0] = PropertyUtils.readPropertyInt(string, "OnlineProcessors", "=");
        nArray[1] = PropertyUtils.readPropertyInt(string, "OnlineProcessors", "=");
        nArray[2] = PropertyUtils.readPropertyInt(string, "ConfiguredProcessors", "=");
        int n2 = PowerPC.cpuinfo();
        if (n2 > 0 && nArray[0] > n2) {
            nArray[0] = n2;
        }
        if (nArray[1] <= 0) {
            logger.warning(this, "warn.onlineProcessors.notValid");
            nArray[1] = -2;
        }
        if (nArray[0] <= 0) {
            logger.warning(this, "warn.physicalProcessors.notValid");
            nArray[0] = -2;
        }
        if (nArray[2] <= 0) {
            logger.warning(this, "warn.totalProcessors.notValid");
            nArray[2] = -2;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cpuinfo() {
        String[] stringArray = new String[]{CPU_COMMAND};
        int n2 = 0;
        if (new File(CPU_COMMAND).exists()) {
            Process process = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n3;
                int n4;
                process = Runtime.getRuntime().exec(stringArray);
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                char[] cArray = new char[1024];
                int n5 = 0;
                int n6 = 0;
                while (stringBuffer.length() < 500 && (n4 = inputStreamReader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n4);
                }
                n5 = stringBuffer.indexOf(PROC_STRING);
                if (n5 != -1 && (n3 = Integer.parseInt(stringBuffer.substring(n6 = n5 + PROC_STRING.length(), n6 + 1))) > 0) {
                    n2 = n3;
                    int n7 = 0;
                    try {
                        n7 = Integer.parseInt(stringBuffer.substring(n6 + 1, n6 + 2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n7 > 0) {
                        n2 = n3 * 10 + n7;
                    }
                }
                if (n2 > 1 && (n5 = stringBuffer.indexOf(CORE_STRING)) != -1 && stringBuffer.substring(n6 = n5 + CORE_STRING.length(), n6 + 5).equals("false")) {
                    n2 /= 2;
                }
            }
            catch (IOException iOException) {
                logger.warning((Object)(class$com$sitraka$licensing$util$arch$PowerPC == null ? (class$com$sitraka$licensing$util$arch$PowerPC = PowerPC.class$("com.sitraka.licensing.util.arch.PowerPC")) : class$com$sitraka$licensing$util$arch$PowerPC), "error.os.cannotExecuteCommand", (Throwable)iOException, stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning(class$com$sitraka$licensing$util$arch$PowerPC == null ? (class$com$sitraka$licensing$util$arch$PowerPC = PowerPC.class$("com.sitraka.licensing.util.arch.PowerPC")) : class$com$sitraka$licensing$util$arch$PowerPC, "error.invalid.number", null, stringArray[0], stringBuffer.toString().trim());
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

