/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.arch;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.arch.IA32;
import com.sitraka.licensing.util.arch.IA64;
import com.sitraka.licensing.util.arch.PaRisc;
import com.sitraka.licensing.util.arch.PowerPC;
import com.sitraka.licensing.util.arch.S390;
import com.sitraka.licensing.util.arch.Sparc;
import com.sitraka.licensing.util.arch.Unsupported;

public abstract class Arch {
    private static Arch current;
    public static final int PHYSICAL = 0;
    public static final int ONLINE = 1;
    public static final int TOTAL = 2;
    public static final int INVALID_PROCESSOR_COUNT = -2;
    protected static final String HYPERTHREADING = "HyperThreading";
    protected static final String LOGICALPERPHYSICAL = "LogicalPerPhysical";
    protected static final String CONFIGUREDPROCESSORS = "ConfiguredProcessors";
    protected static final String ONLINEPROCESSORS = "OnlineProcessors";
    private static final Logger logger;
    private static final Arch[] list;
    private static final Arch unsupported;
    static /* synthetic */ Class class$com$sitraka$licensing$util$arch$Arch;

    public static Arch getCurrent() {
        if (current == null) {
            String string = System.getProperty("os.arch");
            current = Arch.getArch(string);
        }
        return current;
    }

    public static Arch getArch(String string) {
        String string2 = string.toLowerCase();
        for (int i2 = 0; i2 < list.length; ++i2) {
            Arch arch = list[i2];
            if (!arch.matches(string2)) continue;
            return arch;
        }
        logger.warning((Object)(class$com$sitraka$licensing$util$arch$Arch == null ? (class$com$sitraka$licensing$util$arch$Arch = Arch.class$("com.sitraka.licensing.util.arch.Arch")) : class$com$sitraka$licensing$util$arch$Arch), "error.arch.notSupported", null, string);
        return unsupported;
    }

    public abstract String getName();

    protected abstract boolean matches(String var1);

    public String toString() {
        return this.getName();
    }

    public abstract int[] parseCPUInfo(String var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = Logger.getLogger();
        list = new Arch[]{new IA32(), new IA64(), new PowerPC(), new PaRisc(), new Sparc(), new S390()};
        unsupported = new Unsupported();
    }
}

