/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.ParameterCheck;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class PropertyUtils {
    private static final Logger logger = Logger.getLogger();
    protected static final String[] MODIFIER_NAMES = new String[]{"second", "seconds", "minute", "minutes", "hour", "hours", "day", "days"};
    protected static final long[] MODIFIER_VALUES = new long[]{1000L, 1000L, 60000L, 60000L, 3600000L, 3600000L, 86400000L, 86400000L};
    protected static final DateFormat[] LONG_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy/MM/dd h:mm:ss a z"), new SimpleDateFormat("yyyy/MM/dd hh:mm:ss z"), new SimpleDateFormat("yyyy/MM/dd hh:mm:ss"), new SimpleDateFormat("yyyy/MM/dd hh:mm z"), new SimpleDateFormat("yyyy/MM/dd hh:mm"), new SimpleDateFormat("yyyy/MM/dd h:mm:ss a"), new SimpleDateFormat("yyyy/MM/dd h:mm a z"), new SimpleDateFormat("yyyy/MM/dd h:mm a"), new SimpleDateFormat("yyyy.MM.dd h:mm:ss a z"), new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z"), new SimpleDateFormat("yyyy.MM.dd hh:mm:ss"), new SimpleDateFormat("yyyy.MM.dd hh:mm z"), new SimpleDateFormat("yyyy.MM.dd hh:mm"), new SimpleDateFormat("yyyy.MM.dd h:mm:ss a"), new SimpleDateFormat("yyyy.MM.dd h:mm a z"), new SimpleDateFormat("yyyy.MM.dd h:mm a")};
    protected static final DateFormat[] SHORT_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("MMM dd, yyyy"), new SimpleDateFormat("yyyy/MMM/dd"), new SimpleDateFormat("yyyy.MM.dd")};
    protected static final String DATE_NOW = "now";
    protected static final String DATE_TODAY = "today";
    protected static final String DATE_TOMORROW = "tomorrow";
    protected static final String[] SPECIAL_DATES = new String[]{"now", "today", "tomorrow"};
    static /* synthetic */ Class class$com$sitraka$licensing$util$PropertyUtils;

    private PropertyUtils() {
    }

    protected static double readBaseInterval(String string) {
        int n2 = string.indexOf(32);
        double d2 = Double.MIN_VALUE;
        String string2 = n2 != -1 ? string.substring(0, n2) : string;
        try {
            d2 = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? (class$com$sitraka$licensing$util$PropertyUtils = PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils")) : class$com$sitraka$licensing$util$PropertyUtils, "Error parsing double '" + string2 + "'", exception);
            d2 = Double.MIN_VALUE;
        }
        return d2;
    }

    protected static long readModifier(String string) {
        long l2 = 1L;
        int n2 = string.lastIndexOf(32);
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            for (int i2 = 0; i2 < MODIFIER_NAMES.length; ++i2) {
                if (!string2.equalsIgnoreCase(MODIFIER_NAMES[i2])) continue;
                l2 = MODIFIER_VALUES[i2];
                break;
            }
        }
        return l2;
    }

    public static long readInterval(Properties properties, String string) {
        long l2 = Long.MIN_VALUE;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
            double d2 = PropertyUtils.readBaseInterval(string2);
            long l3 = PropertyUtils.readModifier(string2);
            if (d2 == Double.MIN_VALUE) {
                l2 = Long.MIN_VALUE;
            } else {
                Double d3 = new Double(d2 * (double)l3);
                l2 = d3.longValue();
            }
        }
        return l2;
    }

    public static long readInterval(Properties properties, String string, long l2) {
        long l3 = PropertyUtils.readInterval(properties, string);
        if (l3 == Long.MIN_VALUE) {
            l3 = l2;
        }
        return l3;
    }

    protected static long checkForSpecialDate(String string) {
        long l2 = 0L;
        ParameterCheck.nonNull(string);
        if (string.equalsIgnoreCase(DATE_NOW)) {
            l2 = System.currentTimeMillis();
        } else if (string.equalsIgnoreCase(DATE_TODAY)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            l2 = calendar.getTime().getTime();
        } else if (string.equalsIgnoreCase(DATE_TOMORROW)) {
            Calendar calendar = Calendar.getInstance();
            calendar.roll(5, true);
            l2 = calendar.getTime().getTime();
        }
        return l2;
    }

    public static DateFormat[] getLongDateFormats() {
        return LONG_DATE_FORMATS;
    }

    public static DateFormat[] getShortDateFormats() {
        return SHORT_DATE_FORMATS;
    }

    public static long parseLongDate(String string) {
        return PropertyUtils.parseDateInternal(string, LONG_DATE_FORMATS);
    }

    public static String writeLongDate(Date date) {
        DateFormat dateFormat = LONG_DATE_FORMATS[0];
        return dateFormat.format(date);
    }

    public static String writeShortDate(Date date) {
        DateFormat dateFormat = SHORT_DATE_FORMATS[0];
        return dateFormat.format(date);
    }

    public static long parseShortDate(String string) {
        return PropertyUtils.parseDateInternal(string, SHORT_DATE_FORMATS);
    }

    protected static long parseDateInternal(String string, DateFormat[] dateFormatArray) {
        long l2 = 0L;
        ParameterCheck.nonNull(dateFormatArray);
        ParameterCheck.nonNull(string);
        string = string.trim();
        l2 = PropertyUtils.checkForSpecialDate(string);
        if (l2 != 0L) {
            return l2;
        }
        for (int i2 = 0; i2 < dateFormatArray.length; ++i2) {
            try {
                DateFormat dateFormat = dateFormatArray[i2];
                Date date = dateFormat.parse(string);
                l2 = date.getTime();
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
            catch (Exception exception) {
                logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils") : class$com$sitraka$licensing$util$PropertyUtils, "Error parsing '" + string + "' against '" + dateFormatArray[i2] + "'", exception);
            }
        }
        return l2;
    }

    public static long readDate(Properties properties, String string) {
        long l2 = 0L;
        ParameterCheck.nonNull(properties);
        ParameterCheck.nonNull(string);
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            l2 = PropertyUtils.parseLongDate(string2);
        }
        return l2;
    }

    public static long readShortDate(Properties properties, String string) {
        long l2 = 0L;
        ParameterCheck.nonNull(properties);
        ParameterCheck.nonNull(string);
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            l2 = PropertyUtils.parseShortDate(string2);
        }
        return l2;
    }

    public static boolean parseLine(String string, String[] stringArray) {
        boolean bl = false;
        char c2 = (string = string.trim()).length() == 0 ? (char)'\u0000' : string.charAt(0);
        int n2 = string.indexOf(61);
        if (c2 != '#' && c2 != '!' && n2 > 0) {
            bl = true;
            stringArray[0] = string.substring(0, n2);
            stringArray[1] = n2 == string.length() - 1 ? "" : PropertyUtils.removeEscapeChars(string.substring(n2 + 1));
        }
        return bl;
    }

    protected static String removeEscapeChars(String string) {
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '\\') {
                stringBuffer.deleteCharAt(n2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean checkLicenseVersion(String string) {
        int n2 = string.indexOf(46);
        return n2 > 0 && n2 < string.length() - 1 && PropertyUtils.onlyDigits(string.substring(0, n2)) && PropertyUtils.onlyDigits(string.substring(n2 + 1));
    }

    public static boolean onlyDigits(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static void loadFromFile(Properties properties, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        fileInputStream.close();
    }

    public static void loadFromReader(Map map, Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String[] stringArray = new String[2];
        while ((string = bufferedReader.readLine()) != null) {
            if (!PropertyUtils.parseLine(string, stringArray)) continue;
            map.put(stringArray[0], stringArray[1]);
        }
        reader.close();
    }

    public static void writeToFile(Properties properties, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, null);
        fileOutputStream.close();
    }

    public static void writeToWriter(Map map, Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            bufferedWriter.write((String)entry.getKey());
            bufferedWriter.write("=");
            bufferedWriter.write((String)entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }

    public static int readPropertyInt(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? (class$com$sitraka$licensing$util$PropertyUtils = PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils")) : class$com$sitraka$licensing$util$PropertyUtils, "readPropertyInt() passed null data or null property name");
            return Integer.MIN_VALUE;
        }
        String string4 = PropertyUtils.readProperty(string, string2, string3);
        int n2 = Integer.MIN_VALUE;
        if (string4 != null) {
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = Integer.MIN_VALUE;
                logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? (class$com$sitraka$licensing$util$PropertyUtils = PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils")) : class$com$sitraka$licensing$util$PropertyUtils, "readPropertyInt(" + string2 + "=" + string4 + ") not an number\n", numberFormatException);
            }
        }
        return n2;
    }

    public static String readProperty(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? (class$com$sitraka$licensing$util$PropertyUtils = PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils")) : class$com$sitraka$licensing$util$PropertyUtils, "readProperty() passed null data or null property name");
            return null;
        }
        String string4 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String string5 = stringTokenizer.nextToken();
            if (string5 == null) continue;
            if (!PropertyUtils.parseLine(string5 = string5.trim(), stringArray = new String[2])) {
                logger.debug(class$com$sitraka$licensing$util$PropertyUtils == null ? PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils") : class$com$sitraka$licensing$util$PropertyUtils, "Skipping invalid property line '" + string5 + "'");
                continue;
            }
            if (!stringArray[0].equals(string2)) continue;
            return stringArray[1];
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println("com.sitraka.util.PropertyUtils: Testing date parsing routines:");
        long l2 = PropertyUtils.parseLongDate("1979/07/13 11:11");
        if (l2 == -1L || l2 != 300726660000L) {
            System.out.println("\tParsing '1979/07/13 11:11' failed. Error!");
        } else {
            System.out.println("\tParsing '1979/07/13 11:11' succeeded as " + PropertyUtils.writeLongDate(new Date(l2)) + " (" + l2 + ")");
        }
        System.out.println("\n\tParsing '2000/03/15 2:50:12 PM EST'");
        l2 = PropertyUtils.parseLongDate("2000/03/15 2:50:12 PM EST");
        Date date = new Date(l2);
        System.out.println("\tParsed to java.util.Date: " + date);
        System.out.println("\tConverted back to: " + PropertyUtils.writeLongDate(date));
        System.out.println("\n\tParsing '2000/03/15 14:50:12 EST'");
        l2 = PropertyUtils.parseLongDate("2000/03/15 14:50:12 EST");
        date = new Date(l2);
        System.out.println("\tParsed to java.util.Date: " + date);
        System.out.println("\tConverted back to: " + PropertyUtils.writeLongDate(date));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

