/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.logging.LicenseLogEvent;
import com.sitraka.licensing.logging.LicenseLogManager;

public final class Logger {
    private static final Logger instance = new Logger();
    private static final LicenseLogManager manager = LicenseLogManager.getLogManager();

    public static synchronized Logger getLogger() {
        return instance;
    }

    private Logger() {
    }

    public boolean isEnabled(int n2) {
        return manager.isEnabled(n2);
    }

    public void log(Object object, int n2, String string, Throwable throwable, Object[] objectArray) {
        if (this.isEnabled(n2)) {
            LicenseLogEvent licenseLogEvent = new LicenseLogEvent(object, n2, string, throwable, objectArray);
            manager.sendLogEvent(licenseLogEvent);
        }
    }

    public void debug(Object object, String string) {
        this.debug(object, string, null);
    }

    public void debug(Object object, String string, Throwable throwable) {
        this.log(object, 4, string, throwable, null);
    }

    public void info(Object object, String string) {
        this.info(object, string, null);
    }

    public void info(Object object, String string, Throwable throwable) {
        this.log(object, 3, string, throwable, null);
    }

    public void info(Object object, String string, Throwable throwable, Object object2) {
        this.log(object, 3, string, throwable, new Object[]{object2});
    }

    public void info(Object object, String string, Throwable throwable, Object object2, Object object3) {
        this.log(object, 3, string, throwable, new Object[]{object2, object3});
    }

    public void info(Object object, String string, Throwable throwable, Object[] objectArray) {
        this.log(object, 3, string, throwable, objectArray);
    }

    public void warning(Object object, String string) {
        this.warning(object, string, null);
    }

    public void warning(Object object, String string, Throwable throwable) {
        this.log(object, 2, string, throwable, null);
    }

    public void warning(Object object, String string, Throwable throwable, Object object2) {
        this.log(object, 2, string, throwable, new Object[]{object2});
    }

    public void warning(Object object, String string, Throwable throwable, Object object2, Object object3) {
        this.log(object, 2, string, throwable, new Object[]{object2, object3});
    }

    public void warning(Object object, String string, Throwable throwable, Object[] objectArray) {
        this.log(object, 2, string, throwable, objectArray);
    }

    public void error(Object object, String string) {
        this.error(object, string, null);
    }

    public void error(Object object, String string, Throwable throwable) {
        this.log(object, 1, string, throwable, null);
    }

    public void error(Object object, String string, Throwable throwable, Object object2) {
        this.log(object, 1, string, throwable, new Object[]{object2});
    }

    public void error(Object object, String string, Throwable throwable, Object object2, Object object3) {
        this.log(object, 1, string, throwable, new Object[]{object2, object3});
    }

    public void error(Object object, String string, Throwable throwable, Object[] objectArray) {
        this.log(object, 1, string, throwable, objectArray);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(4);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(3);
    }

    public boolean isWarningEnabled() {
        return this.isEnabled(2);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(1);
    }
}

