/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.logging;

import com.sitraka.licensing.logging.LicenseLogEvent;
import com.sitraka.licensing.logging.LicenseLogListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class LicenseLogManager {
    private static LicenseLogManager instance = null;
    private Set listeners = new HashSet(5);
    private int level = 3;

    private LicenseLogManager() {
    }

    public static synchronized LicenseLogManager getLogManager() {
        if (instance == null) {
            instance = new LicenseLogManager();
        }
        return instance;
    }

    public boolean addListener(LicenseLogListener licenseLogListener) {
        return this.getListeners().add(licenseLogListener);
    }

    public boolean removeListener(LicenseLogListener licenseLogListener) {
        return this.getListeners().remove(licenseLogListener);
    }

    public void clearListeners() {
        this.getListeners().clear();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n2) {
        this.level = n2;
    }

    public boolean isEnabled(int n2) {
        return n2 <= this.level;
    }

    public void sendLogEvent(LicenseLogEvent licenseLogEvent) {
        this.deliverLogEvent(licenseLogEvent);
    }

    private Set getListeners() {
        return Collections.synchronizedSet(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverLogEvent(LicenseLogEvent licenseLogEvent) {
        Set set;
        Set set2 = set = this.getListeners();
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                LicenseLogListener licenseLogListener = (LicenseLogListener)iterator.next();
                licenseLogListener.logEvent(licenseLogEvent);
            }
        }
    }
}

