/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.logging;

import com.sitraka.licensing.util.I18n;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventObject;
import java.util.Locale;

public class LicenseLogEvent
extends EventObject {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private static final int LOG_FIRST_CONSTANT = 1;
    private static final int LOG_LAST_CONSTANT = 4;
    private int reason;
    private String message;
    private Throwable exception;
    private Object[] args;

    public LicenseLogEvent(Object object, int n2, String string, Throwable throwable, Object[] objectArray) {
        super(object);
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Unknown reason #" + n2);
        }
        if (string == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        this.reason = n2;
        this.message = string;
        this.exception = throwable;
        this.args = objectArray;
    }

    public int getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getTranslatedMessage() {
        return this.getTranslatedMessage(Locale.getDefault());
    }

    public String getTranslatedMessage(Locale locale) {
        String string = this.message;
        if (this.reason != 4) {
            string = I18n.get(this.message, this.args, locale);
        }
        return string;
    }

    public String getExceptionAsText() {
        if (this.exception == null) {
            return null;
        }
        return this.getStackTrace(this.exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.source instanceof Class) {
            stringBuffer.append(((Class)this.source).getName());
        } else {
            stringBuffer.append(this.source.getClass().getName());
        }
        stringBuffer.append("] - ");
        String string = this.getTranslatedMessage();
        if (string.length() == 0) {
            stringBuffer.append("(no message)");
        } else {
            stringBuffer.append(string);
        }
        if (this.exception != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.getStackTrace(this.exception));
        }
        return stringBuffer.toString();
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

