/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.SitrakaPublicKey;
import com.sitraka.licensing.util.Codecs;
import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.SignableBlock;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

final class ValidateSignature {
    private static final PublicKey key = new SitrakaPublicKey();
    private static final Logger logger = Logger.getLogger();
    static /* synthetic */ Class class$com$sitraka$licensing$ValidateSignature;

    private ValidateSignature() {
    }

    private static boolean validate(byte[] byArray, byte[] byArray2) {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "validating from the data: '" + new String(byArray, "UTF-8") + "'");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA/DSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "SHA/DSA algortithm not available. Cannot validate licenses.", noSuchAlgorithmException);
            return false;
        }
        try {
            signature.initVerify(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "Invalid public key", invalidKeyException);
            return false;
        }
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "Could not append data to be validated", signatureException);
            return false;
        }
        boolean bl = false;
        try {
            bl = signature.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "Could not verify signature", signatureException);
        }
        return bl;
    }

    private static boolean validateSignatureBytes(String[] stringArray, byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = SignableBlock.createSignableBlock(stringArray);
        return ValidateSignature.validate(byArray2, byArray);
    }

    public static boolean validateSignature(String[] stringArray, String string) throws UnsupportedEncodingException {
        byte[] byArray;
        try {
            byArray = Codecs.base64Decode(string.getBytes("UTF-8"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.debug(class$com$sitraka$licensing$ValidateSignature == null ? (class$com$sitraka$licensing$ValidateSignature = ValidateSignature.class$("com.sitraka.licensing.ValidateSignature")) : class$com$sitraka$licensing$ValidateSignature, "Error decoding license", arrayIndexOutOfBoundsException);
            return false;
        }
        return ValidateSignature.validateSignatureBytes(stringArray, byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

