/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.AbstractLicenses;
import com.sitraka.licensing.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class Licenses
extends AbstractLicenses {
    private File licensesFile;
    private File backupFile;
    private File licensingHome;

    public Licenses(File file) throws IOException {
        this.licensesFile = file;
        this.licensingHome = file.getAbsoluteFile().getParentFile();
        this.backupFile = new File(this.licensesFile.getPath() + "-backup");
        if (this.licensesFile.exists()) {
            FileInputStream fileInputStream = new FileInputStream(this.licensesFile);
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
    }

    public Licenses(URL uRL) throws IOException {
        if (uRL != null) {
            InputStream inputStream = uRL.openStream();
            this.load(inputStream);
            inputStream.close();
        }
    }

    public void store() throws IOException {
        File file = File.createTempFile("tmp", ".dat", this.licensingHome);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.store(fileOutputStream);
        fileOutputStream.close();
        FileUtil.backupAndMove(file, this.licensesFile, this.backupFile);
    }
}

