/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.InvalidLicenseException;
import com.sitraka.licensing.ValidateSignature;
import com.sitraka.licensing.util.HostUtils;
import com.sitraka.licensing.util.I18n;
import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.Platform;
import com.sitraka.licensing.util.PropertyUtils;
import com.sitraka.licensing.util.StringIterator;
import com.sitraka.licensing.util.StringSort;
import com.sitraka.licensing.util.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;

public final class LicenseProperties {
    public static final int VALID = 1;
    public static final int HOSTNAME_INVALID = 2;
    public static final int NUMBER_CPU_EXCEEDED = 3;
    public static final int OS_INVALID = 4;
    public static final int NULL_PARAMETER = 11;
    public static final int HOSTS_PROPERTY_NOT_FOUND = 12;
    public static final int GETLOCALHOST_FAILED = 13;
    public static final int OS_PROPERTY_NOT_FOUND = 14;
    public static final int UNABLE_TO_IDENTIFY_OS = 15;
    public static final int ARCH_INVALID = 16;
    public static final int ARCH_PROPERTY_NOT_FOUND = 17;
    public static final int UNABLE_TO_IDENTIFY_ARCH = 18;
    private static final char COLON_SEPARATOR = ':';
    private static final String EXTENSION = ".license";
    private HashMap properties = new HashMap();
    private boolean fValid = false;
    private boolean everValidated = false;
    private String errorMessage = null;
    private static final Logger logger = Logger.getLogger();

    public static String getStandardFilename(String string) {
        String string2 = string;
        if (!string.endsWith(EXTENSION)) {
            int n2 = string.lastIndexOf(46);
            int n3 = string.lastIndexOf(File.separatorChar);
            string2 = n2 == -1 || n3 > n2 ? string + EXTENSION : string.substring(0, n2) + EXTENSION;
        }
        return string2;
    }

    private synchronized void load(InputStream inputStream) throws IOException, InvalidLicenseException {
        if (this.everValidated) {
            throw new IllegalStateException("The license can not be loaded: it was already validated");
        }
        this.properties.clear();
        if (Platform.isAscii()) {
            PropertyUtils.loadFromReader(this.properties, new InputStreamReader(inputStream, "8859_1"));
        } else {
            byte[] byArray = LicenseProperties.loadStream(inputStream);
            PropertyUtils.loadFromReader(this.properties, new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "8859_1"));
            if (!this.properties.containsKey("sitraka.license.version")) {
                this.properties.clear();
                PropertyUtils.loadFromReader(this.properties, new InputStreamReader(new ByteArrayInputStream(byArray)));
            }
        }
        if (!this.validate()) {
            throw new InvalidLicenseException(this.errorMessage);
        }
    }

    public void loadFromStream(InputStream inputStream) throws IOException, InvalidLicenseException {
        this.load(inputStream);
    }

    public void loadFromClasspath(String string) throws IOException, InvalidLicenseException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        this.load(inputStream);
        inputStream.close();
    }

    public void loadFromURL(URL uRL) throws IOException, InvalidLicenseException {
        InputStream inputStream = uRL.openStream();
        this.load(inputStream);
        inputStream.close();
    }

    public void loadFromFile(File file) throws IOException, InvalidLicenseException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public synchronized void loadFromMap(Map map) {
        if (this.everValidated) {
            throw new IllegalStateException("The license can not be loaded: it was already validated");
        }
        this.properties.clear();
        this.properties.putAll(map);
    }

    public void store(OutputStream outputStream) throws IOException {
        PropertyUtils.writeToWriter(this.properties, new OutputStreamWriter(outputStream));
    }

    public void store(Writer writer) throws IOException {
        PropertyUtils.writeToWriter(this.properties, writer);
    }

    public void setProperty(String string, String string2) {
        if (this.everValidated) {
            throw new IllegalStateException("The license can not be changed: it was already validated");
        }
        this.properties.put(string, string2);
    }

    public boolean isValid() {
        if (!this.everValidated) {
            this.validate();
        }
        return this.fValid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int size() {
        return this.properties.size();
    }

    public Enumeration keys() {
        return Collections.enumeration(this.properties.keySet());
    }

    public Iterator getProperties() {
        return Collections.unmodifiableMap(this.properties).entrySet().iterator();
    }

    public boolean containsKey(String string) {
        return this.properties.containsKey(string);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public String getProduct() {
        return (String)this.properties.get("product");
    }

    public String getSerialNumber() {
        return (String)this.properties.get("serial_number");
    }

    public String getMaximumUsers() {
        return (String)this.properties.get("maximum_users");
    }

    public String getType() {
        return (String)this.properties.get("type");
    }

    public String getExpiryDate() {
        return (String)this.properties.get("expiry");
    }

    public String getIssueDate() {
        return (String)this.properties.get("issued");
    }

    public String getOs() {
        return (String)this.properties.get("os");
    }

    public String getLicenseVersion() {
        return (String)this.properties.get("license_version");
    }

    boolean containsProduct(String string, String string2) {
        String string3 = LicenseProperties.getProductString(string, string2);
        if (string3 == null) {
            return false;
        }
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string4.indexOf(string3) == -1) continue;
            return true;
        }
        return false;
    }

    private String getExpiryDateString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.properties.get(string);
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private String getIssueDateString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.properties.get(string);
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public boolean isEvalCopy(String string) {
        String string2 = this.getExpiryDateString(string);
        return string2 != null;
    }

    public boolean isDateExpired(String string) {
        String string2 = this.getExpiryDateString(string);
        if (string2 != null) {
            long l2 = PropertyUtils.parseShortDate((String)this.properties.get(string));
            return l2 <= 0L || l2 <= System.currentTimeMillis();
        }
        return false;
    }

    public boolean isIssueDateValid(String string) {
        long l2;
        String string2 = this.getIssueDateString(string);
        return string2 == null || (l2 = PropertyUtils.parseShortDate((String)this.properties.get(string))) > 0L && System.currentTimeMillis() > l2;
    }

    public String getValidationMessage(int n2, String string) {
        switch (n2) {
            case 1: {
                return null;
            }
            case 2: {
                return I18n.get("error.host.notLicensed", this.getProperty(string), HostUtils.getBestHostName());
            }
            case 3: {
                return I18n.get("error.cpus.exceeded");
            }
            case 4: {
                return I18n.get("error.os.notLicensed", this.getProperty(string), System.getProperty("os.name"));
            }
            case 11: {
                return I18n.get("error.parameter.null");
            }
            case 12: {
                return I18n.get("error.license.missingProperty", string);
            }
            case 13: {
                return I18n.get("error.localhost.notValid");
            }
            case 14: {
                return I18n.get("error.license.missingProperty", string);
            }
            case 15: {
                return I18n.get("error.os.notSupported", System.getProperty("os.name"));
            }
            case 16: {
                return I18n.get("error.arch.notLicensed", this.getProperty(string), System.getProperty("os.arch"));
            }
            case 17: {
                return I18n.get("error.license.missingProperty", string);
            }
            case 18: {
                return I18n.get("error.arch.notSupported", System.getProperty("os.arch"));
            }
        }
        return I18n.get("error.status.unknown", new Integer(n2));
    }

    public int validateOperatingSystem(String string) {
        if (string == null) {
            return 11;
        }
        String string2 = (String)this.properties.get(string);
        if (string2 == null) {
            logger.debug(this, "validateOperatingSystem(): Unable to get OS from license properties file.");
            return 14;
        }
        if ((string2 = string2.toLowerCase()).indexOf("(any)") != -1) {
            return 1;
        }
        String string3 = Platform.getOSName();
        if (string3 == null) {
            return 15;
        }
        logger.debug(this, "validateOperatingSystem(): actualOS = " + string3);
        StringIterator stringIterator = new StringIterator(string2);
        while (stringIterator.hasNext()) {
            String string4 = (String)stringIterator.next();
            logger.debug(this, "validateOperatingSystem(): licensed OS = " + string4);
            if (!string4.equals(string3)) continue;
            return 1;
        }
        return 4;
    }

    public int validateArchitecture(String string) {
        if (string == null) {
            return 11;
        }
        String string2 = (String)this.properties.get(string);
        if (string2 == null) {
            logger.debug(this, "validateArchitecture(): Unable to get arch from license properties file.");
            return 17;
        }
        if ((string2 = string2.toLowerCase()).indexOf("(any)") != -1) {
            return 1;
        }
        String string3 = Platform.getArchName();
        if (string3 == null) {
            return 18;
        }
        logger.debug(this, "validateArchitecture(): actualArch = " + string3);
        StringIterator stringIterator = new StringIterator(string2);
        while (stringIterator.hasNext()) {
            String string4 = (String)stringIterator.next();
            logger.debug(this, "validateArchitecture(): licensed arch = " + string4);
            if (!string4.equals(string3)) continue;
            return 1;
        }
        return 16;
    }

    public int validateHost(String string) {
        String string2;
        if (string == null) {
            return 11;
        }
        String string3 = (String)this.properties.get(string);
        if (string3 == null) {
            return 12;
        }
        int n2 = 0;
        StringIterator stringIterator = new StringIterator(string3);
        while (stringIterator.hasNext() && (n2 = this.validateHostInfo(string2 = (String)stringIterator.next())) != 1 && n2 != 3) {
        }
        return n2;
    }

    private int validateHostInfo(String string) {
        if (string == null) {
            return 11;
        }
        if (string.compareTo("(unlimited)") == 0) {
            return 1;
        }
        SortedSet sortedSet = HostUtils.getValidHostNames();
        if (sortedSet == null || sortedSet.size() == 0) {
            logger.debug(this, "HostUtils.getValidHostNames() did not return any valid names for this machine.");
            return 13;
        }
        String string2 = null;
        String string3 = null;
        int n2 = string.lastIndexOf(58);
        if (n2 > 0) {
            string2 = string.substring(0, n2).trim().toLowerCase();
            string3 = string.substring(n2 + 1, string.length()).trim();
            logger.debug(this, "validateHostInfo(): nameLicensedHost = " + string2 + ", numberCPU = " + string3);
        } else {
            string2 = string.toLowerCase();
            logger.debug(this, "validateHostInfo(): nameLicensedHost = " + string2);
        }
        int n3 = 2;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            logger.debug(this, "checking licensedHost=" + string2);
            if (!HostUtils.compareHosts(string2, string4)) continue;
            n3 = 1;
            if (string3 == null) break;
            try {
                int n4 = Integer.parseInt(string3);
                if (LicenseProperties.isNumberProcessorsValid(n4)) break;
                n3 = 3;
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 3;
                logger.debug(this, "CPU count parse error", numberFormatException);
            }
            break;
        }
        return n3;
    }

    private static boolean isNumberProcessorsValid(int n2) {
        return n2 >= Platform.getPhysicalProcessors();
    }

    private boolean validate() {
        this.fValid = false;
        try {
            Iterator iterator = this.properties.keySet().iterator();
            String[] stringArray = new String[this.properties.size()];
            String string = null;
            int n2 = 0;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.indexOf("sitraka.license.signature") == -1) {
                    stringArray[n2] = string2;
                } else {
                    stringArray[n2] = "";
                    string = string2;
                }
                ++n2;
            }
            StringSort.sort(stringArray);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].equals("")) continue;
                int n3 = n2;
                stringArray[n3] = stringArray[n3] + this.getProperty(stringArray[n2]);
            }
            if (string != null) {
                string = this.getProperty(string);
                this.fValid = ValidateSignature.validateSignature(stringArray, string);
            }
        }
        catch (RuntimeException runtimeException) {
            logger.debug(this, "validate(): RuntimeException caught", runtimeException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.debug(this, "validate(): UnsupportedEncodingException caught", unsupportedEncodingException);
        }
        if (!this.fValid) {
            this.errorMessage = I18n.get("error.license.badSignature");
        } else if (this.getProperty("serial_number") == null) {
            this.errorMessage = I18n.get("error.license.missingProperty", "serial_number");
            this.fValid = false;
        } else if (this.getProperty("product") == null) {
            this.errorMessage = I18n.get("error.license.missingProperty", "product");
            this.fValid = false;
        }
        this.everValidated = true;
        return this.fValid;
    }

    private static String getProductString(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = string;
            if (string2 != null) {
                string3 = string3 + "." + string2;
            }
        } else if (string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    private static byte[] loadStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return this.properties.toString();
    }

    public static void main(String[] stringArray) {
        Version.main(stringArray);
    }
}

