/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.InvalidLicenseException;
import com.sitraka.licensing.LicenseProperties;
import com.sitraka.licensing.util.Debug;
import com.sitraka.licensing.util.HostUtils;
import com.sitraka.licensing.util.I18n;
import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.Platform;
import com.sitraka.licensing.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.SortedSet;

public final class Diagnostics {
    private static final Logger logger = Logger.getLogger();
    private final PrintStream out = System.out;

    private Diagnostics() {
        this.title(I18n.get("diag.title"));
        this.out.println("");
    }

    private void title(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        if (n3 < 80) {
            n4 = (80 - n3) / 2;
            n5 = 80 - n3 - n4;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.out.print(" ");
        }
        this.out.print(string);
        for (n2 = 0; n2 < n5; ++n2) {
            this.out.print(" ");
        }
        this.out.println("");
        for (n2 = 0; n2 < n4; ++n2) {
            this.out.print(" ");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.out.print("-");
        }
        this.out.println("");
    }

    private void checkVersion() {
        this.title(I18n.get("diag.version.title"));
        Package package_ = Package.getPackage("com.sitraka.licensing");
        Object var2_2 = null;
        Object var3_3 = null;
        if (package_ != null) {
            this.out.println(I18n.get("diag.implementation.title", package_.getImplementationTitle()));
            this.out.println(I18n.get("diag.implementation.version", package_.getImplementationVersion()));
            this.out.println(I18n.get("diag.specification.version", package_.getSpecificationVersion()));
        }
        Version version = Version.VERSION;
        Object[] objectArray = new Object[]{new Integer(version.getMajor()), new Integer(version.getMinor()), new Integer(version.getMicro())};
        this.out.println(I18n.get("diag.version.versionbits", objectArray));
        this.out.println(I18n.get("diag.version.buildnumber", version.getBuildNumber()));
        this.out.println(I18n.get("diag.version.shortversion", version.getShortString()));
        this.out.println("");
    }

    private void checkPlatform() {
        this.title(I18n.get("diag.platform.title"));
        Platform.getOSName();
        Platform.getArchName();
        Platform.getPhysicalProcessors();
        Platform.getOnlineProcessors();
        Platform.getTotalProcessors();
        this.out.println(I18n.get("diag.platform.osname", Platform.getOSName()));
        this.out.println(I18n.get("diag.platform.archname", Platform.getArchName()));
        this.out.println(I18n.get("diag.platform.physicalcpu", new Integer(Platform.getPhysicalProcessors())));
        this.out.println(I18n.get("diag.platform.onlinecpu", new Integer(Platform.getOnlineProcessors())));
        this.out.println(I18n.get("diag.platform.totalcpu", new Integer(Platform.getTotalProcessors())));
        this.out.println("");
    }

    private void checkHosts() {
        this.title(I18n.get("diag.hostname.title"));
        HostUtils.getValidIpAddresses();
        HostUtils.getValidHostNames();
        HostUtils.getBestHostName();
        this.out.println(I18n.get("diag.hostname.best", HostUtils.getBestHostName()));
        this.out.println(I18n.get("diag.hostname.allnames"));
        SortedSet sortedSet = HostUtils.getValidHostNames();
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            this.out.print("\t");
            this.out.println(iterator.next());
        }
        this.out.println(I18n.get("diag.hostname.allips"));
        sortedSet = HostUtils.getValidIpAddresses();
        iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            this.out.print("\t");
            this.out.println(iterator.next());
        }
        this.out.println("");
    }

    private void checkLicenseFile(String string) {
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            this.out.println(I18n.get("diag.license.filenotfound", file.getAbsolutePath()));
            return;
        }
        this.out.println(I18n.get("diag.license.checkingfile", file.getAbsolutePath()));
        LicenseProperties licenseProperties = new LicenseProperties();
        try {
            licenseProperties.loadFromFile(file);
        }
        catch (IOException iOException) {
            logger.error(this, "diag.license.fileioerror", iOException);
            return;
        }
        catch (InvalidLicenseException invalidLicenseException) {
            logger.error(this, "diag.license.fileparseerror", invalidLicenseException);
            return;
        }
        if (licenseProperties.isValid()) {
            this.out.println(I18n.get("diag.license.valid"));
        } else {
            this.out.println(I18n.get("diag.license.notvalid", licenseProperties.getErrorMessage()));
        }
        int n2 = licenseProperties.validateArchitecture("architecture");
        if (n2 == 1) {
            this.out.println(I18n.get("diag.license.arch.valid"));
        } else {
            this.out.println(I18n.get("diag.license.arch.notvalid", new Integer(n2)));
        }
        n2 = licenseProperties.validateOperatingSystem("os");
        if (n2 == 1) {
            this.out.println(I18n.get("diag.license.os.valid"));
        } else {
            this.out.println(I18n.get("diag.license.os.notvalid", new Integer(n2)));
        }
        n2 = licenseProperties.validateHost("hosts");
        if (n2 == 1) {
            this.out.println(I18n.get("diag.license.host.valid"));
        } else {
            this.out.println(I18n.get("diag.license.host.notvalid", new Integer(n2)));
        }
        if (licenseProperties.isIssueDateValid("issued")) {
            this.out.println(I18n.get("diag.license.issue.date.valid"));
        } else {
            this.out.println(I18n.get("diag.license.issue.date.notvalid", new Integer(n2)));
        }
        if (!licenseProperties.isDateExpired("expiry")) {
            this.out.println(I18n.get("diag.license.expiry.valid"));
        } else {
            this.out.println(I18n.get("diag.license.expiry.notvalid", new Integer(n2)));
        }
        this.out.println("");
    }

    private void checkLicense(String[] stringArray) {
        this.title(I18n.get("diag.license.title"));
        if (stringArray.length == 0) {
            this.out.println(I18n.get("diag.license.nofiles"));
            this.out.println("");
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.checkLicenseFile(stringArray[i2]);
        }
        this.out.println("");
    }

    public static void main(String[] stringArray) {
        Debug.setEnabled(true);
        Diagnostics diagnostics = new Diagnostics();
        diagnostics.checkVersion();
        diagnostics.checkPlatform();
        diagnostics.checkHosts();
        diagnostics.checkLicense(stringArray);
    }
}

