/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Copying;
import com.objectspace.jgl.algorithms.Reversing;
import com.objectspace.jgl.algorithms.Swapping;

public final class Rotating {
    private Rotating() {
    }

    public static void rotate(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, ForwardIterator forwardIterator3) {
        if (!forwardIterator.isCompatibleWith(forwardIterator3)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(forwardIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        if (forwardIterator.clone().equals(forwardIterator2) || forwardIterator2.clone().equals(forwardIterator3)) {
            return;
        }
        if (forwardIterator instanceof RandomAccessIterator) {
            Rotating.rotateRandomAccess((RandomAccessIterator)forwardIterator, (RandomAccessIterator)forwardIterator2, (RandomAccessIterator)forwardIterator3);
            return;
        }
        if (forwardIterator instanceof BidirectionalIterator) {
            BidirectionalIterator bidirectionalIterator = (BidirectionalIterator)forwardIterator;
            BidirectionalIterator bidirectionalIterator2 = (BidirectionalIterator)forwardIterator2;
            BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)forwardIterator3;
            Reversing.reverse(bidirectionalIterator, bidirectionalIterator2);
            Reversing.reverse(bidirectionalIterator2, bidirectionalIterator3);
            Reversing.reverse(bidirectionalIterator, bidirectionalIterator3);
            return;
        }
        Rotating.rotateForward(forwardIterator, forwardIterator2, forwardIterator3);
    }

    public static OutputIterator rotateCopy(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, ForwardIterator forwardIterator3, OutputIterator outputIterator) {
        return Copying.copy(forwardIterator, forwardIterator2, Copying.copy(forwardIterator2, forwardIterator3, outputIterator));
    }

    static void rotateBidirectional(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BidirectionalIterator bidirectionalIterator3) {
        Reversing.reverse(bidirectionalIterator, bidirectionalIterator2);
        Reversing.reverse(bidirectionalIterator2, bidirectionalIterator3);
        Reversing.reverse(bidirectionalIterator, bidirectionalIterator3);
    }

    static void rotateForward(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, ForwardIterator forwardIterator3) {
        ForwardIterator forwardIterator4 = (ForwardIterator)forwardIterator.clone();
        ForwardIterator forwardIterator5 = (ForwardIterator)forwardIterator2.clone();
        ForwardIterator forwardIterator6 = (ForwardIterator)forwardIterator2.clone();
        while (true) {
            Swapping.iterSwap(forwardIterator4, forwardIterator6);
            forwardIterator4.advance();
            forwardIterator6.advance();
            if (forwardIterator4.equals(forwardIterator5)) {
                if (forwardIterator6.equals(forwardIterator3)) {
                    return;
                }
                forwardIterator5 = (ForwardIterator)forwardIterator6.clone();
                continue;
            }
            if (!forwardIterator6.equals(forwardIterator3)) continue;
            forwardIterator6 = (ForwardIterator)forwardIterator5.clone();
        }
    }

    static void rotateRandomAccess(RandomAccessIterator randomAccessIterator, RandomAccessIterator randomAccessIterator2, RandomAccessIterator randomAccessIterator3) {
        int n2 = Rotating.gcd(randomAccessIterator.distance(randomAccessIterator3), randomAccessIterator.distance(randomAccessIterator2));
        while (n2-- != 0) {
            RandomAccessIterator randomAccessIterator4 = (RandomAccessIterator)randomAccessIterator.clone();
            randomAccessIterator4.advance(n2);
            Rotating.cycle(randomAccessIterator, randomAccessIterator3, randomAccessIterator4, randomAccessIterator.distance(randomAccessIterator2));
        }
    }

    static int gcd(int n2, int n3) {
        while (n3 != 0) {
            int n4 = n2 % n3;
            n2 = n3;
            n3 = n4;
        }
        return n2;
    }

    static void cycle(RandomAccessIterator randomAccessIterator, RandomAccessIterator randomAccessIterator2, RandomAccessIterator randomAccessIterator3, int n2) {
        Object object = randomAccessIterator3.get();
        RandomAccessIterator randomAccessIterator4 = (RandomAccessIterator)randomAccessIterator3.clone();
        RandomAccessIterator randomAccessIterator5 = (RandomAccessIterator)randomAccessIterator4.clone();
        randomAccessIterator5.advance(n2);
        while (!randomAccessIterator5.equals(randomAccessIterator3)) {
            randomAccessIterator4.put(randomAccessIterator5.get());
            randomAccessIterator4 = (RandomAccessIterator)randomAccessIterator5.clone();
            if (randomAccessIterator5.distance(randomAccessIterator2) > n2) {
                randomAccessIterator5.advance(n2);
                continue;
            }
            int n3 = n2 - randomAccessIterator5.distance(randomAccessIterator2);
            randomAccessIterator5 = (RandomAccessIterator)randomAccessIterator.clone();
            randomAccessIterator5.advance(n3);
        }
        randomAccessIterator4.put(object);
    }
}

