/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ShortArray;
import com.objectspace.jgl.adapters.ShortBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ShortIterator
implements RandomAccessIterator,
Serializable {
    short[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -9054943108350905562L;

    public static ShortIterator begin(short[] sArray) {
        return new ShortIterator(sArray, 0);
    }

    public static ShortIterator end(short[] sArray) {
        return new ShortIterator(sArray, sArray.length);
    }

    public ShortIterator() {
        this(new ShortArray(), 0);
    }

    public ShortIterator(ShortIterator shortIterator) {
        this.buffer = shortIterator.buffer;
        this.original = shortIterator.original;
        this.index = shortIterator.index;
    }

    public ShortIterator(short[] sArray, int n2) {
        this(new ShortArray(sArray), n2);
    }

    public ShortIterator(ShortArray shortArray, int n2) {
        this.buffer = shortArray.array;
        this.original = shortArray;
        this.index = n2;
    }

    public ShortIterator(ShortBuffer shortBuffer, int n2) {
        this.buffer = shortBuffer.storage;
        this.original = shortBuffer;
        this.index = n2;
    }

    public Object clone() {
        return new ShortIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof ShortIterator)) break block2;
                ShortIterator shortIterator = (ShortIterator)object;
                if (shortIterator.index == this.index && (shortIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(ShortIterator shortIterator) {
        return shortIterator.index == this.index && shortIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ShortIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Short s2 = new Short(this.buffer[this.index]);
            ++this.index;
            return s2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ShortIterator");
        }
    }

    public Object get() {
        return new Short(this.buffer[this.index]);
    }

    public short getShort() {
        return this.buffer[this.index];
    }

    public Object get(int n2) {
        return new Short(this.buffer[this.index + n2]);
    }

    public short getShort(int n2) {
        return this.buffer[this.index + n2];
    }

    public void put(Object object) {
        short s2;
        this.buffer[this.index] = s2 = ((Number)object).shortValue();
    }

    public void put(short s2) {
        this.buffer[this.index] = s2;
    }

    public void put(int n2, Object object) {
        short s2;
        this.buffer[this.index + n2] = s2 = ((Number)object).shortValue();
    }

    public void put(int n2, short s2) {
        this.buffer[this.index + n2] = s2;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof ShortIterator) || this.buffer != ((ShortIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ShortIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ShortIterator && this.buffer == ((ShortIterator)inputIterator).buffer;
    }
}

