/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.ShortBuffer;
import com.objectspace.jgl.adapters.ShortIterator;
import java.util.Enumeration;

public class ShortArray
extends ArrayAdapter {
    short[] array;
    static final long serialVersionUID = 7732606095528017874L;

    public ShortArray() {
        this(new short[0]);
    }

    public ShortArray(ShortArray shortArray) {
        this(shortArray.array);
    }

    public ShortArray(ShortBuffer shortBuffer) {
        this(shortBuffer.get());
    }

    public ShortArray(short[] sArray) {
        this.array = sArray;
    }

    public synchronized Object clone() {
        return new ShortArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "short[]");
    }

    public boolean equals(Object object) {
        return object instanceof ShortArray && this.equals((ShortArray)object) || object instanceof ShortBuffer && this.equals((ShortBuffer)object);
    }

    public boolean equals(ShortArray shortArray) {
        return this.equals(shortArray.array);
    }

    public boolean equals(ShortBuffer shortBuffer) {
        return this.equals(shortBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(short[] sArray) {
        short[] sArray2 = sArray;
        synchronized (sArray2) {
            if (this.array.length != sArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < sArray.length) {
                if (this.array[n2] != sArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public short[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized ShortIterator begin() {
        return new ShortIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized ShortIterator end() {
        return new ShortIterator(this, this.array.length);
    }

    public Object at(int n2) {
        return new Short(this.shortAt(n2));
    }

    public synchronized short shortAt(int n2) {
        return this.array[n2];
    }

    public void put(int n2, Object object) {
        this.put(n2, ((Number)object).shortValue());
    }

    public synchronized void put(int n2, short s2) {
        this.array[n2] = s2;
    }
}

