/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.DoubleBuffer;
import com.objectspace.jgl.adapters.DoubleIterator;
import java.util.Enumeration;

public class DoubleArray
extends ArrayAdapter {
    double[] array;
    static final long serialVersionUID = -8532185493786913102L;

    public DoubleArray() {
        this(new double[0]);
    }

    public DoubleArray(DoubleArray doubleArray) {
        this(doubleArray.array);
    }

    public DoubleArray(DoubleBuffer doubleBuffer) {
        this(doubleBuffer.get());
    }

    public DoubleArray(double[] dArray) {
        this.array = dArray;
    }

    public synchronized Object clone() {
        return new DoubleArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "double[]");
    }

    public boolean equals(Object object) {
        return object instanceof DoubleArray && this.equals((DoubleArray)object) || object instanceof DoubleBuffer && this.equals((DoubleBuffer)object);
    }

    public boolean equals(DoubleArray doubleArray) {
        return this.equals(doubleArray.array);
    }

    public boolean equals(DoubleBuffer doubleBuffer) {
        return this.equals(doubleBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(double[] dArray) {
        double[] dArray2 = dArray;
        synchronized (dArray2) {
            if (this.array.length != dArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < dArray.length) {
                if (this.array[n2] != dArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public double[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized DoubleIterator begin() {
        return new DoubleIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized DoubleIterator end() {
        return new DoubleIterator(this, this.array.length);
    }

    public Object at(int n2) {
        return new Double(this.doubleAt(n2));
    }

    public synchronized double doubleAt(int n2) {
        return this.array[n2];
    }

    public void put(int n2, Object object) {
        this.put(n2, ((Number)object).doubleValue());
    }

    public synchronized void put(int n2, double d2) {
        this.array[n2] = d2;
    }
}

