/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ByteArray;
import com.objectspace.jgl.adapters.ByteBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ByteIterator
implements RandomAccessIterator,
Serializable {
    byte[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 4883976831804292945L;

    public static ByteIterator begin(byte[] byArray) {
        return new ByteIterator(byArray, 0);
    }

    public static ByteIterator end(byte[] byArray) {
        return new ByteIterator(byArray, byArray.length);
    }

    public ByteIterator() {
        this(new ByteArray(), 0);
    }

    public ByteIterator(ByteIterator byteIterator) {
        this.buffer = byteIterator.buffer;
        this.original = byteIterator.original;
        this.index = byteIterator.index;
    }

    public ByteIterator(byte[] byArray, int n2) {
        this(new ByteArray(byArray), n2);
    }

    public ByteIterator(ByteArray byteArray, int n2) {
        this.buffer = byteArray.array;
        this.original = byteArray;
        this.index = n2;
    }

    public ByteIterator(ByteBuffer byteBuffer, int n2) {
        this.buffer = byteBuffer.storage;
        this.original = byteBuffer;
        this.index = n2;
    }

    public Object clone() {
        return new ByteIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof ByteIterator)) break block2;
                ByteIterator byteIterator = (ByteIterator)object;
                if (byteIterator.index == this.index && (byteIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(ByteIterator byteIterator) {
        return byteIterator.index == this.index && byteIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ByteIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Byte by = new Byte(this.buffer[this.index]);
            ++this.index;
            return by;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ByteIterator");
        }
    }

    public Object get() {
        return new Byte(this.buffer[this.index]);
    }

    public byte getByte() {
        return this.buffer[this.index];
    }

    public Object get(int n2) {
        return new Byte(this.buffer[this.index + n2]);
    }

    public byte getByte(int n2) {
        return this.buffer[this.index + n2];
    }

    public void put(Object object) {
        byte by;
        this.buffer[this.index] = by = ((Number)object).byteValue();
    }

    public void put(byte by) {
        this.buffer[this.index] = by;
    }

    public void put(int n2, Object object) {
        byte by;
        this.buffer[this.index + n2] = by = ((Number)object).byteValue();
    }

    public void put(int n2, byte by) {
        this.buffer[this.index + n2] = by;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof ByteIterator) || this.buffer != ((ByteIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ByteIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ByteIterator && this.buffer == ((ByteIterator)inputIterator).buffer;
    }
}

