/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import java.util.Enumeration;

public abstract class ArrayAdapter
implements Sequence {
    static final int DEFAULT_SIZE = 10;
    static final int THRESHOLD = 2000;
    static final int MULTIPLIER = 2;
    static final long serialVersionUID = 6128010853760609317L;

    public Object clone() {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.start(), this.size());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int count(Object object) {
        return this.count(0, this.size() - 1, object);
    }

    public synchronized int count(int n2, int n3, Object object) {
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            if (this.at(n5).equals(object)) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public int replace(Object object, Object object2) {
        return this.replace(0, this.size() - 1, object, object2);
    }

    public synchronized int replace(int n2, int n3, Object object, Object object2) {
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            if (this.at(n5).equals(object)) {
                this.put(n5, object2);
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int indexOf(Object object) {
        return this.indexOf(0, this.size() - 1, object);
    }

    public synchronized int indexOf(int n2, int n3, Object object) {
        int n4 = n2;
        while (n4 <= n3) {
            if (this.at(n4).equals(object)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public void clear() {
        throw new InvalidOperationException("cannot execute clear() on a native array");
    }

    public Object add(Object object) {
        throw new InvalidOperationException("cannot execute add() on a native array");
    }

    public void pushFront(Object object) {
        throw new InvalidOperationException("cannot execute pushFront() on a native array");
    }

    public Object popFront() {
        throw new InvalidOperationException("cannot execute popFront() on a native array");
    }

    public void pushBack(Object object) {
        throw new InvalidOperationException("cannot execute pushBack() on a native array");
    }

    public Object popBack() {
        throw new InvalidOperationException("cannot execute popBack() on a native array");
    }

    public Object remove(Enumeration enumeration) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Object object) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(Object object, int n2) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int remove(int n2, int n3, Object object) {
        throw new InvalidOperationException("cannot execute remove() on a native array");
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    protected static final void checkIndex(int n2, int n3) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + "; valid range is 0.." + (n3 - 1));
        }
    }

    protected static final void checkRange(int n2, int n3, int n4) {
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
    }

    static final int getNextSize(int n2) {
        int n3 = n2 > 2000 ? n2 + 2000 : n2 * 2;
        return Math.max(1, n3);
    }

    public abstract Object at(int var1);

    public abstract void put(int var1, Object var2);

    public abstract int size();

    public abstract Enumeration elements();

    public abstract ForwardIterator start();

    public abstract ForwardIterator finish();
}

