/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.Map;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Tree;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class OrderedMap
extends Map {
    Tree myTree;
    int version = 30100;
    static final long serialVersionUID = -8187379858339202062L;

    public OrderedMap() {
        this.myTree = new Tree(true, false, this);
    }

    public OrderedMap(boolean bl) {
        this.myTree = new Tree(true, bl, this);
    }

    public OrderedMap(BinaryPredicate binaryPredicate) {
        this.myTree = new Tree(true, false, binaryPredicate, this);
    }

    public OrderedMap(BinaryPredicate binaryPredicate, boolean bl) {
        this.myTree = new Tree(true, bl, binaryPredicate, this);
    }

    public OrderedMap(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            this.myTree = new Tree(orderedMap.myTree, this);
            return;
        }
    }

    public boolean allowsDuplicates() {
        return this.myTree.myInsertAlways;
    }

    public synchronized Object clone() {
        return new OrderedMap(this);
    }

    public synchronized void copy(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            Tree tree = this.myTree;
            Tree tree2 = orderedMap.myTree;
            if (tree != tree2) {
                tree.clear();
                tree.copyTree(tree2);
            }
            return;
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "OrderedMap");
    }

    public synchronized Enumeration elements() {
        Tree tree = this.myTree;
        return new OrderedMapIterator(tree, tree.myHeader.left, (OrderedMap)tree.myContainer, 3);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized OrderedMapIterator begin() {
        Tree tree = this.myTree;
        return new OrderedMapIterator(tree, tree.myHeader.left, (OrderedMap)tree.myContainer, 1);
    }

    public synchronized OrderedMapIterator end() {
        Tree tree = this.myTree;
        return new OrderedMapIterator(tree, tree.myHeader, (OrderedMap)tree.myContainer, 1);
    }

    public boolean isEmpty() {
        return this.myTree.size == 0;
    }

    public int size() {
        return this.myTree.size;
    }

    public int maxSize() {
        Tree tree = this.myTree;
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        return object instanceof OrderedMap && this.equals((OrderedMap)object);
    }

    public synchronized boolean equals(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            boolean bl = Algos.Comparing.equal(this, orderedMap);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        Object object = this.myTree;
        object = new OrderedMapIterator((Tree)object, ((Tree)object).myHeader.left, (OrderedMap)((Tree)object).myContainer, 2);
        return Algos.Hashing.orderedHash((ForwardIterator)object, this.myTree.size);
    }

    public synchronized void swap(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            Tree tree = this.myTree;
            this.myTree = orderedMap.myTree;
            orderedMap.myTree = tree;
            return;
        }
    }

    public synchronized void clear() {
        this.myTree.clear();
    }

    public synchronized Object remove(Object object) {
        return this.myTree.remove((Object)object).first;
    }

    public synchronized int remove(Object object, int n2) {
        Pair pair = this.myTree.remove(object, n2);
        return ((Number)pair.second).intValue();
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof OrderedMapIterator)) {
            throw new IllegalArgumentException("Enumeration not an OrderedMapIterator");
        }
        if (((OrderedMapIterator)enumeration).myOrderedMap != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedMap");
        }
        Tree.TreeNode treeNode = this.myTree.remove(((OrderedMapIterator)enumeration).myNode);
        if (treeNode == null) {
            return null;
        }
        return treeNode.object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof OrderedMapIterator) || !(enumeration2 instanceof OrderedMapIterator)) {
            throw new IllegalArgumentException("Enumeration not an OrderedMapIterator");
        }
        if (((OrderedMapIterator)enumeration).myOrderedMap != this || ((OrderedMapIterator)enumeration2).myOrderedMap != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedMap");
        }
        Serializable serializable = this.myTree;
        Tree.TreeNode treeNode = ((OrderedMapIterator)enumeration).myNode;
        Tree.TreeNode treeNode2 = ((OrderedMapIterator)enumeration2).myNode;
        serializable = serializable.remove(treeNode, treeNode2, serializable.size);
        return ((Number)((Pair)serializable).second).intValue();
    }

    public synchronized OrderedMapIterator find(Object object) {
        return new OrderedMapIterator(this.myTree, this.myTree.find(object), this, 1);
    }

    public synchronized int count(Object object) {
        return this.myTree.count(object);
    }

    public synchronized int countValues(Object object) {
        Tree tree = this.myTree;
        OrderedMapIterator orderedMapIterator = new OrderedMapIterator(tree, tree.myHeader.left, (OrderedMap)tree.myContainer, 3);
        tree = this.myTree;
        return Algos.Counting.count(orderedMapIterator, new OrderedMapIterator(tree, tree.myHeader, (OrderedMap)tree.myContainer, 3), object);
    }

    public synchronized OrderedMapIterator lowerBound(Object object) {
        Tree tree = this.myTree;
        return new OrderedMapIterator(this.myTree, (Tree.TreeNode)tree.equalRange((Object)object).first, this, 1);
    }

    public synchronized OrderedMapIterator upperBound(Object object) {
        Tree tree = this.myTree;
        return new OrderedMapIterator(this.myTree, (Tree.TreeNode)tree.equalRange((Object)object).second, this, 1);
    }

    public synchronized Range equalRange(Object object) {
        Pair pair = this.myTree.equalRange(object);
        return new Range(new OrderedMapIterator(this.myTree, (Tree.TreeNode)pair.first, this, 1), new OrderedMapIterator(this.myTree, (Tree.TreeNode)pair.second, this, 1));
    }

    public BinaryPredicate getComparator() {
        return this.myTree.myComparator;
    }

    public synchronized Object get(Object object) {
        return this.myTree.get(object);
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Object object3 = this.myTree;
        Pair pair = new Pair(object, object2);
        object3 = ((Tree)object3).insertAux(pair, false);
        if (((Tree.InsertResult)object3).ok) {
            return null;
        }
        pair = (Pair)((Tree.InsertResult)object3).node.object;
        Object object4 = pair.second;
        pair.second = object2;
        return object4;
    }

    public Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Pair)) {
            throw new IllegalArgumentException("object is not Pair");
        }
        if (((Pair)object).first == null || ((Pair)object).second == null) {
            throw new NullPointerException();
        }
        Pair pair = (Pair)object;
        return this.add(pair.first, pair.second);
    }

    public synchronized Object add(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Object object3 = this.myTree;
        Pair pair = new Pair(object, object2);
        object3 = ((Tree)object3).insertAux(pair, true);
        if (((Tree.InsertResult)object3).ok) {
            return null;
        }
        return ((Pair)((Tree.InsertResult)object3).node.object).second;
    }

    public synchronized Enumeration keys() {
        Tree tree = this.myTree;
        return new OrderedMapIterator(tree, tree.myHeader.left, (OrderedMap)tree.myContainer, 2);
    }

    public synchronized Enumeration keys(Object object) {
        return this.myTree.keys(object).elements();
    }

    public synchronized Enumeration values(Object object) {
        return this.myTree.values(object).elements();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.version == 0) {
            boolean bl = objectInputStream.readBoolean();
            BinaryPredicate binaryPredicate = (BinaryPredicate)objectInputStream.readObject();
            this.myTree = new Tree(true, bl, binaryPredicate, this);
            int n2 = objectInputStream.readInt();
            while (n2-- > 0) {
                this.add(objectInputStream.readObject());
            }
        }
    }
}

