/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWithSortableChildren
implements JCTreeTableModel,
JCRowSortModel,
Serializable {
    protected JCTreeTableModel treeTableModel = null;
    protected int sortColumn = -1;
    protected int sortOrder = 1;
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = new RowIntComparator();
    protected boolean autoSort = true;
    protected boolean needsResorting = true;
    protected boolean needsReordering = false;
    protected JCListenerList listeners = null;
    protected Listener l = new Listener();
    protected HashMap<HashObject, int[]> nodeChildIndexMaps = null;
    protected JCRowComparator rowComparator = new DefaultRowComparator(1);

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel, JCRowComparator jCRowComparator) {
        this(jCTreeTableModel);
        this.rowComparator = jCRowComparator;
    }

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel) {
        this.setModel(jCTreeTableModel);
    }

    public JCTreeTableModel getModel() {
        return this.treeTableModel;
    }

    public void setModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == this.treeTableModel) {
            return;
        }
        if (this.treeTableModel != null) {
            this.treeTableModel.removeTreeModelListener(this.l);
        }
        this.treeTableModel = jCTreeTableModel;
        this.treeTableModel.addTreeModelListener(this.l);
        this.needsResorting = true;
        this.needsReordering = false;
        this.nodeChildIndexMaps = this.autoSort ? new HashMap() : null;
        this.sortColumn = -1;
        if (this.treeTableModel == null) {
            this.keyColumnsArray = null;
        } else {
            int n2;
            int n3 = this.treeTableModel.getColumnCount();
            int n4 = n2 = this.keyColumnsArray == null ? 0 : this.keyColumnsArray.length;
            if (n2 != n3) {
                int[][] nArrayArray = new int[n3][];
                if (this.keyColumnsArray != null) {
                    System.arraycopy(this.keyColumnsArray, 0, nArrayArray, 0, Math.min(n3, n2));
                }
                this.keyColumnsArray = nArrayArray;
            }
        }
    }

    @Override
    public boolean getAutoSort() {
        return this.autoSort;
    }

    @Override
    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    @Override
    public void setKeyColumns(int n2, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treeTableModel.getColumnCount()][];
        }
        this.keyColumnsArray[n2] = nArray;
        this.needsResorting = true;
    }

    @Override
    public int[] getKeyColumns(int n2) {
        return this.keyColumnsArray[n2];
    }

    @Override
    public boolean isDataSorted() {
        return this.nodeChildIndexMaps != null;
    }

    @Override
    public void setDataSorted(boolean bl) {
        if (bl && this.sortColumn == -1) {
            return;
        }
        if (!bl && this.isDataSorted()) {
            this.needsReordering = true;
            this.sortColumn = -1;
        }
        if (this.needsResorting || this.needsReordering) {
            if (this.needsResorting) {
                this.nodeChildIndexMaps = new HashMap();
                this.needsReordering = false;
            }
            this.postTreeStructureChanged(null, false);
            this.needsResorting = false;
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int n2) {
        if (this.sortColumn == n2) {
            return;
        }
        if (this.treeTableModel != null && this.treeTableModel.getColumnCount() <= n2) {
            throw new IllegalArgumentException("index value greater than number of columns");
        }
        this.sortColumn = n2;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(int n2) {
        this.sortOrder = n2;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    @Override
    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    protected int[] getIndices(Object object) {
        int n2 = this.treeTableModel.getChildCount(object);
        if (this.sortColumn == -1 || n2 == 0) {
            return null;
        }
        if (this.nodeChildIndexMaps == null) {
            return null;
        }
        HashObject hashObject = new HashObject(object);
        int[] nArray = this.nodeChildIndexMaps.get(hashObject);
        if (nArray == null) {
            nArray = new int[n2];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = i2;
            }
            this.rowIntComparator.parent = object;
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.treeTableModel.getColumnCount()][];
            }
            int[] nArray2 = new int[]{this.sortColumn};
            this.rowComparator.setKeyColumns(this.keyColumnsArray[this.sortColumn] != null ? this.keyColumnsArray[this.sortColumn] : nArray2);
            JCMappingSort.sort(this.rowIntComparator, nArray);
            this.nodeChildIndexMaps.put(hashObject, nArray);
        }
        return nArray;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.add(this.listeners, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n2) {
        int[] nArray = this.getIndices(object);
        if (nArray != null) {
            n2 = this.sortOrder == 1 ? nArray[n2] : nArray[nArray.length - n2 - 1];
        }
        return this.treeTableModel.getChild(object, n2);
    }

    @Override
    public int getChildCount(Object object) {
        return this.treeTableModel.getChildCount(object);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n2 = this.treeTableModel.getIndexOfChild(object, object2);
        if (n2 < 0) {
            return n2;
        }
        int[] nArray = this.getIndices(object);
        if (nArray == null) {
            return n2;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            if (this.sortOrder == 1) {
                return i2;
            }
            return nArray.length - i2 - 1;
        }
        throw new IllegalArgumentException("Node not child of specified parent");
    }

    @Override
    public Object getRoot() {
        return this.treeTableModel.getRoot();
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.treeTableModel.isLeaf(object);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.treeTableModel.valueForPathChanged(treePath, object);
    }

    @Override
    public Object getValueAt(Object object, int n2) {
        return this.treeTableModel.getValueAt(object, n2);
    }

    @Override
    public boolean isCellEditable(Object object, int n2) {
        return this.treeTableModel.isCellEditable(object, n2);
    }

    @Override
    public void setValueAt(Object object, Object object2, int n2) {
        this.treeTableModel.setValueAt(object, object2, n2);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.treeTableModel.getColumnClass(n2);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.treeTableModel.getColumnName(n2);
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    protected void postTreeStructureChanged(TreeModelEvent treeModelEvent) {
        this.postTreeStructureChanged(treeModelEvent, true);
    }

    protected void postTreeStructureChanged(TreeModelEvent treeModelEvent, boolean bl) {
        if (treeModelEvent == null) {
            treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.treeTableModel.getRoot()), null, null);
        }
        if (bl) {
            this.nodeChildIndexMaps = this.autoSort ? new HashMap() : null;
            this.needsResorting = true;
        }
        Enumeration<Object> enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        protected ComparableRow r1;
        protected ComparableRow r2;
        public Object parent;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
            this.parent = null;
        }

        public int compare(int n2, int n3) {
            this.r1.row = n2;
            this.r1.node = TreeWithSortableChildren.this.treeTableModel.getChild(this.parent, n2);
            this.r2.row = n3;
            this.r2.node = TreeWithSortableChildren.this.treeTableModel.getChild(this.parent, n3);
            return TreeWithSortableChildren.this.rowComparator.compare(this.r1, this.r2);
        }
    }

    class ComparableRow
    implements JCComparableRow {
        public Object node = null;
        public int row;

        ComparableRow() {
        }

        public Object getValueAt(int n2) {
            return TreeWithSortableChildren.this.treeTableModel.getValueAt(this.node, n2);
        }

        public int getRowIndex() {
            return this.row;
        }
    }

    public static class HashObject {
        WeakReference<Object> weak;

        public HashObject(Object object) {
            this.weak = new WeakReference<Object>(object);
        }

        public boolean equals(Object object) {
            Object t = this.weak.get();
            Object var3_3 = null;
            if (object != null) {
                var3_3 = ((HashObject)object).weak.get();
            }
            return t != null && t == var3_3;
        }

        public int hashCode() {
            Object t = this.weak.get();
            if (t == null) {
                return 0;
            }
            return t.hashCode();
        }
    }

    class Listener
    implements TreeModelListener {
        Listener() {
        }

        protected TreeModelEvent convertTreeEvent(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return null;
            }
            return new TreeModelEvent((Object)TreeWithSortableChildren.this, treeModelEvent.getTreePath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = null;
            if (treeModelEvent == null) {
                treeModelEvent2 = new TreeModelEvent((Object)TreeWithSortableChildren.this, new TreePath(TreeWithSortableChildren.this.treeTableModel.getRoot()), null, null);
            }
            if (TreeWithSortableChildren.this.nodeChildIndexMaps == null && (treeModelEvent2 = this.convertTreeEvent(treeModelEvent)) == null) {
                return;
            }
            if (treeModelEvent2 != null) {
                Enumeration<Object> enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
                while (enumeration.hasMoreElements()) {
                    TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                    treeModelListener.treeNodesChanged(treeModelEvent2);
                }
            } else {
                TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
                TreeWithSortableChildren.this.needsResorting = true;
                this.treeNodesChanged(null);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
            TreeWithSortableChildren.this.needsResorting = true;
            Enumeration<Object> enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent2);
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
            TreeWithSortableChildren.this.needsResorting = true;
            Enumeration<Object> enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent2);
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeWithSortableChildren.this.postTreeStructureChanged(treeModelEvent);
        }
    }
}

