/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFromTreeTable
implements TableModel {
    protected JCTreeTableModel treetable = null;
    protected ArrayList<TreePath> rowMap = null;
    protected int hashInt = 0;
    protected Hashtable<TreePath, Integer> treeMap = null;

    public TableFromTreeTable(JCTreeTableModel jCTreeTableModel) {
        this.treetable = jCTreeTableModel;
    }

    protected void addKids(TreePath treePath, Object object) {
        int n2 = this.treetable.getChildCount(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.treetable.getChild(object, i2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            this.rowMap.add(treePath2);
            this.treeMap.put(treePath2, new Integer(this.hashInt++));
            if (this.treetable.isLeaf(object2)) continue;
            this.addKids(treePath2, object2);
        }
    }

    protected void initMappings() {
        this.rowMap = new ArrayList();
        this.treeMap = new Hashtable();
        this.hashInt = 0;
        TreePath treePath = new TreePath(this.treetable.getRoot());
        this.rowMap.add(treePath);
        this.treeMap.put(treePath, new Integer(this.hashInt++));
        this.addKids(treePath, this.treetable.getRoot());
    }

    protected void resetMappings() {
        this.rowMap = null;
        this.treeMap = null;
        this.hashInt = 0;
    }

    protected Object rowToNode(int n2) {
        return this.rowToTreePath(n2).getLastPathComponent();
    }

    protected TreePath rowToTreePath(int n2) {
        if (this.rowMap == null) {
            this.initMappings();
        }
        if (n2 > this.rowMap.size()) {
            throw new IndexOutOfBoundsException("row = " + n2 + " > " + this.rowMap.size());
        }
        return this.rowMap.get(n2);
    }

    protected int treePathToRow(TreePath treePath) {
        Integer n2;
        if (this.treeMap == null) {
            this.initMappings();
        }
        if (treePath != null && (n2 = this.treeMap.get(treePath)) != null) {
            return n2;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this.rowMap == null) {
            this.initMappings();
        }
        return this.rowMap.size();
    }

    @Override
    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.treetable.getColumnName(n2);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.treetable.getColumnClass(n2);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.treetable.isCellEditable(this.rowToNode(n2), n3);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.treetable.getValueAt(this.rowToNode(n2), n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.treetable.setValueAt(object, this.rowToNode(n2), n3);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }
}

