/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCSpinBoxEditor;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import com.klg.jclass.util.value.AbstractValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class JCSpinNumberBox
extends AbstractSpinBox {
    public static final int INTEGER = 1;
    public static final int FLOATING_POINT = 2;
    protected int operation = 1;
    protected NumberFormat format = NumberFormat.getNumberInstance();
    protected Number step = new Integer(1);
    protected Number max = new Long(Long.MAX_VALUE);
    protected Number min = new Long(Long.MIN_VALUE);

    public JCSpinNumberBox() {
        this.setEditor(new NumberEditor());
        this.setValueModel(new NumberModel());
    }

    public void setOperation(int n2) {
        if (n2 != 1 && n2 != 2) {
            String string = LocaleBundle.string("operation must be one of INTEGER or FLOATING_POINT");
            throw new IllegalArgumentException(string);
        }
        if (this.operation == n2) {
            return;
        }
        int n3 = this.operation;
        this.operation = n2;
        this.firePropertyChange("operation", n3, n2);
    }

    public int getOperation() {
        return this.operation;
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setSpinStep(Number number) {
        this.step = number;
    }

    public Number getSpinStep() {
        return this.step;
    }

    public void setValue(Object object) {
        if (!(object instanceof Number)) {
            String string = LocaleBundle.string("Value for JCSpinNumberBox must be of type Number");
            throw new IllegalArgumentException(string);
        }
        this.setValue((Number)object);
    }

    public void setValue(Number number) {
        if (number != null && (this.compare(number, this.max) > 0 || this.compare(number, this.min) < 0)) {
            return;
        }
        Number number2 = (Number)this.valueModel.getValue();
        if (number2 != null && this.compare(number, number2) == 0) {
            return;
        }
        this.valueModel.setValue(number);
    }

    public Number getValue() {
        return (Number)this.valueModel.getValue();
    }

    public void setValueRange(Number number, Number number2) {
        if (this.compare(number, number2) > 0) {
            String string = LocaleBundle.string("Min must be less than Max");
            throw new IllegalArgumentException(string);
        }
        this.max = number2;
        this.min = number;
    }

    public void setValueRange(Range range) {
        this.setValueRange(range.min, range.max);
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            String string = LocaleBundle.string("NumberFormat must be non-null");
            throw new NullPointerException(string);
        }
        this.format = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    protected void checkArrowButtons() {
        Number number = (Number)this.spinUp();
        if (this.compare(number, this.max) > 0) {
            this.setArrowEnabled(this.upArrow, false);
        } else {
            this.setArrowEnabled(this.upArrow, true);
        }
        number = (Number)this.spinDown();
        if (this.compare(number, this.min) < 0) {
            this.setArrowEnabled(this.downArrow, false);
        } else {
            this.setArrowEnabled(this.downArrow, true);
        }
    }

    protected String format(Number number) {
        if (number == null) {
            return "";
        }
        String string = this.operation == 1 ? this.format.format(number.longValue()) : this.format.format(number.doubleValue());
        return string;
    }

    protected Number parse(String string) {
        Number number = null;
        if (this.operation == 1) {
            this.format.setParseIntegerOnly(true);
        } else {
            this.format.setParseIntegerOnly(false);
        }
        try {
            number = this.format.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return number;
    }

    protected int preferredWidthOfView() {
        int n2;
        if (this.isEditable()) {
            Component component = this.editor.getEditorComponent();
            this.editor.setItem(this.max);
            n2 = component.getPreferredSize().width;
            this.editor.setItem(this.min);
            n2 = Math.max(n2, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.editor.setItem(new Double(this.min.doubleValue() + this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
                this.editor.setItem(new Double(this.max.doubleValue() - this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            this.editor.setItem(this.getValue());
        } else {
            Component component = this.renderer.getComponent(this, this.max);
            n2 = component.getPreferredSize().width;
            this.renderer.getComponent(this, this.min);
            n2 = Math.max(n2, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.renderer.getComponent(this, new Double(this.min.doubleValue() + this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
                this.renderer.getComponent(this, new Double(this.max.doubleValue() - this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            this.renderer.getComponent(this, this.getValue());
        }
        return n2 += JCEnvironment.isWorking("MotifPreferedWidthAjustment");
    }

    protected Object spinUp() {
        Number number;
        Number number2 = (Number)this.valueModel.getValue();
        if (number2 == null) {
            number = this.step;
        } else if (this.operation == 1) {
            long l2 = number2.longValue() + this.step.longValue();
            number = new Long(l2);
        } else {
            double d2 = number2.doubleValue() + this.step.doubleValue();
            number = new Double(d2);
        }
        return number;
    }

    protected Object spinDown() {
        Number number;
        Number number2 = (Number)this.valueModel.getValue();
        if (number2 == null) {
            number = this.step;
        } else if (this.operation == 1) {
            long l2 = number2.longValue() - this.step.longValue();
            number = new Long(l2);
        } else {
            double d2 = number2.doubleValue() - this.step.doubleValue();
            number = new Double(d2);
        }
        return number;
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        this.editor.setItem(jCValueEvent.getNewValue());
        this.renderer.getComponent(this, jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    protected int compare(Number number, Number number2) {
        double d2;
        if (number == null) {
            if (number2 == null) {
                return 0;
            }
            return -1;
        }
        if (number2 == null) {
            return 1;
        }
        if (this.operation == 1) {
            long l2;
            long l3 = number.longValue();
            return l3 < (l2 = number2.longValue()) ? -1 : (l3 == l2 ? 0 : 1);
        }
        double d3 = number.doubleValue();
        return d3 < (d2 = number2.doubleValue()) ? -1 : (d3 == d2 ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NumberModel
    extends AbstractValueModel
    implements JCValueModel,
    Serializable {
        NumberModel() {
        }

        @Override
        public Class<?> getValueClass() {
            return Number.class;
        }
    }

    class NumberEditor
    extends JTextField
    implements JCSpinBoxEditor {
        NumberEditor() {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            if (object == null) {
                this.setText("");
            } else {
                this.setText(JCSpinNumberBox.this.format((Number)object));
            }
        }

        public Object getItem() {
            Number number = JCSpinNumberBox.this.parse(this.getText());
            if (number == null) {
                number = (Number)JCSpinNumberBox.this.valueModel.getValue();
                this.setItem(number);
            }
            return number;
        }
    }

    public static class Range
    implements Serializable {
        public Number min;
        public Number max;

        public Range(Number number, Number number2) {
            this.max = number2;
            this.min = number;
        }
    }
}

