/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTable;
import com.klg.jclass.cell.swing.JCCellRendererToJTable;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.swing.JCTableColumn;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCSortableTable
extends JTable {
    protected Icon upIcon = new SortIcon(true);
    protected Icon downIcon = new SortIcon(false);
    protected JCRowSortTableModel sortModel;
    protected MouseListener tableHeaderMouseListener;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public JCSortableTable() {
        if (JCEnvironment.isDesignTime()) {
            Vector<String> vector = new Vector<String>();
            vector.addElement("Row 1, Column 1");
            vector.addElement("Row 1, Column 2");
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("Row 2, Column 1");
            vector2.addElement("Row 2, Column 2");
            Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
            vector3.addElement(vector);
            vector3.addElement(vector2);
            Vector<String> vector4 = new Vector<String>();
            vector4.addElement("Column 1");
            vector4.addElement("Column 2");
            this.setModel(new DefaultTableModel(vector3, vector4));
        }
    }

    public JCSortableTable(TableModel tableModel) {
        super(tableModel);
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException(LocaleBundle.string("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns."));
        }
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException(LocaleBundle.string("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns."));
        }
    }

    public JCSortableTable(int n2, int n3) {
        super(n2, n3);
    }

    public JCSortableTable(Vector<Object> vector, Vector<Object> vector2) {
        super(vector, vector2);
    }

    public JCSortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            return new Dimension(200, 200);
        }
        return super.getPreferredSize();
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel instanceof JCRowSortTableModel) {
            this.sortModel = (JCRowSortTableModel)((Object)tableModel);
            super.setModel(tableModel);
        } else {
            this.sortModel = new DefaultRowSortTableModel(tableModel);
            super.setModel((TableModel)((Object)this.sortModel));
        }
        this.removeTableHeaderMouseListener();
        this.addTableHeaderMouseListener();
    }

    public int getSortedRow(int n2) {
        return this.sortModel.getSortedRow(n2);
    }

    public int getUnsortedRow(int n2) {
        return this.sortModel.getUnsortedRow(n2);
    }

    public boolean getAutoSort() {
        return this.sortModel.getAutoSort();
    }

    public void setAutoSort(boolean bl) {
        this.sortModel.setAutoSort(bl);
    }

    public void setKeyColumns(int n2, int[] nArray) {
        ((JCRowSortTableModel)((Object)this.dataModel)).setKeyColumns(n2, nArray);
    }

    public int[] getKeyColumns(int n2) {
        return ((JCRowSortTableModel)((Object)this.dataModel)).getKeyColumns(n2);
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setUpIcon(Icon icon) {
        this.upIcon = icon;
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setDownIcon(Icon icon) {
        this.downIcon = icon;
    }

    @Override
    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.getTableHeaderMouseListener() != null) {
            this.removeTableHeaderMouseListener();
        }
        super.setTableHeader(jTableHeader);
        this.addTableHeaderMouseListener();
    }

    @Override
    public TableCellEditor getCellEditor(int n2, int n3) {
        Object object;
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null && tableColumn instanceof JCTableColumn) {
            String string;
            Class<?> clazz;
            object = EditorRendererRegistry.getCentralRegistry();
            JCCellEditor jCCellEditor = ((EditorRendererRegistry)object).getCellEditorInstance(clazz = this.getColumnClass(n3), string = ((JCTableColumn)tableColumn).getRegistryType());
            tableCellEditor = jCCellEditor == null ? null : new JCCellEditorToJTable(jCCellEditor);
        }
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n3));
        }
        object = tableCellEditor.getTableCellEditorComponent(this, null, false, n2, n3);
        JCSortableTable.setComponentOrientation((Component)object, componentOrientation, false);
        return tableCellEditor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        Object object;
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null && tableColumn instanceof JCTableColumn) {
            String string;
            Class<?> clazz;
            object = EditorRendererRegistry.getCentralRegistry();
            JCCellRenderer jCCellRenderer = ((EditorRendererRegistry)object).getCellRendererInstance(clazz = this.getColumnClass(n3), string = ((JCTableColumn)tableColumn).getRegistryType());
            if (jCCellRenderer == null) {
                tableCellRenderer = null;
            } else {
                JCCellRendererToJTable jCCellRendererToJTable = new JCCellRendererToJTable(jCCellRenderer);
                int n4 = componentOrientation.isLeftToRight() ? 2 : 4;
                jCCellRendererToJTable.setHorizontalAlignment(n4);
                tableCellRenderer = jCCellRendererToJTable;
            }
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n3));
        }
        object = tableCellRenderer.getTableCellRendererComponent(this, null, false, false, n2, n3);
        JCSortableTable.setComponentOrientation((Component)object, componentOrientation, false);
        return tableCellRenderer;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        this.removeTableHeaderMouseListener();
        super.configureEnclosingScrollPane();
        this.addTableHeaderMouseListener();
    }

    protected void addTableHeaderMouseListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            if (this.getTableHeaderMouseListener() == null) {
                this.setTableHeaderMouseListener(this.createTableHeaderMouseListener());
            }
            MouseListener mouseListener = this.getTableHeaderMouseListener();
            jTableHeader.addMouseListener(mouseListener);
            if (mouseListener instanceof MouseMotionListener) {
                jTableHeader.addMouseMotionListener((MouseMotionListener)((Object)mouseListener));
            }
        }
    }

    protected void removeTableHeaderMouseListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            MouseListener mouseListener = this.getTableHeaderMouseListener();
            jTableHeader.removeMouseListener(mouseListener);
            if (mouseListener instanceof MouseMotionListener) {
                jTableHeader.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener));
            }
        }
    }

    protected MouseListener getTableHeaderMouseListener() {
        return this.tableHeaderMouseListener;
    }

    protected void setTableHeaderMouseListener(MouseListener mouseListener) {
        this.tableHeaderMouseListener = mouseListener;
    }

    protected MouseAdapter createTableHeaderMouseListener() {
        return new TableHeaderMouseListener();
    }

    public void sort(int n2) {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            String string = LocaleBundle.string("TableModel is not an instance of JCRowSortTableModel");
            throw new IllegalArgumentException(string);
        }
        if (this.isEditing() && this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            String string = LocaleBundle.string("Sort cannot be performed while a cell is editing.");
            JCMessageHelper.showError("Error", string);
            return;
        }
        n2 = this.convertColumnIndexToModel(n2);
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.dataModel);
        if (jCRowSortTableModel.getSortColumn() == n2) {
            jCRowSortTableModel.toggleSortOrder();
        } else {
            jCRowSortTableModel.setSortColumn(n2);
        }
        if (!jCRowSortTableModel.isDataSorted()) {
            jCRowSortTableModel.setDataSorted(true);
        }
    }

    public void unsort() {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            String string = LocaleBundle.string("TableModel is not an instance of JCRowSortTableModel");
            throw new IllegalArgumentException(string);
        }
        ((JCRowSortTableModel)((Object)this.dataModel)).setDataSorted(false);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n2;
        this.clearSortIcons();
        if (this.sortModel.isDataSorted() && (n2 = ((JCRowSortTableModel)((Object)this.dataModel)).getSortColumn()) >= 0) {
            this.setSortIcon(this.convertColumnIndexToView(n2), ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
        }
        super.tableChanged(tableModelEvent);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.removeColumnModelListener(this);
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                TableColumn tableColumn = this.createSortableTableColumn(i2);
                this.addColumn(tableColumn);
            }
            tableColumnModel.addColumnModelListener(this);
        }
    }

    protected boolean checkColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel != null) {
            TableColumn tableColumn;
            int n2;
            for (n2 = 0; n2 < tableColumnModel.getColumnCount(); ++n2) {
                tableColumn = tableColumnModel.getColumn(n2);
                if (tableColumn instanceof JCTableColumn) continue;
                return false;
            }
            for (n2 = 0; n2 < tableColumnModel.getColumnCount(); ++n2) {
                tableColumn = tableColumnModel.getColumn(n2);
                if (tableColumn instanceof SortableTableColumn || tableColumn.getHeaderRenderer() != null) continue;
                boolean bl = this.getComponentOrientation().isLeftToRight();
                tableColumn.setHeaderRenderer(new SortableHeaderRenderer(bl));
            }
        }
        return true;
    }

    @Override
    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (!this.checkColumnModel(tableColumnModel)) {
            throw new IllegalArgumentException(LocaleBundle.string("Column model incompatible with JCSortableTable.  Use createSortableTableColumn() to create table columns."));
        }
        super.setColumnModel(tableColumnModel);
    }

    public TableColumn createSortableTableColumn(int n2) {
        return new SortableTableColumn(n2);
    }

    protected void clearSortIcons() {
        for (int i2 = 0; i2 < this.columnModel.getColumnCount(); ++i2) {
            this.setSortIcon(i2, 0);
        }
    }

    protected void setSortIcon(int n2) {
        this.setSortIcon(n2, ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
    }

    protected void setSortIcon(Component component, Icon icon) {
        if (component instanceof SortableColumnHeader) {
            ((SortableColumnHeader)((Object)component)).setSortIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JLabel) {
            ((JLabel)component).setHorizontalTextPosition(10);
            ((JLabel)component).setIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JButton) {
            ((JButton)component).setHorizontalTextPosition(10);
            ((JButton)component).setIcon(icon);
            ((AbstractTableModel)this.dataModel).fireTableDataChanged();
            this.tableHeader.repaint();
        } else if (component instanceof Container && ((Container)component).getComponentCount() != 0) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                this.setSortIcon(component2, icon);
            }
        }
    }

    protected void setSortIcon(int n2, int n3) {
        Icon icon = null;
        if (n3 == 1) {
            icon = this.getDownIcon();
        } else if (n3 == -1) {
            icon = this.getUpIcon();
        }
        TableColumn tableColumn = this.columnModel.getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, n2);
            this.setSortIcon(component, icon);
        }
    }

    protected static void setComponentOrientation(Component component, ComponentOrientation componentOrientation, boolean bl) {
        if (component == null || componentOrientation == null) {
            return;
        }
        ComponentOrientation componentOrientation2 = component.getComponentOrientation();
        if (componentOrientation.isLeftToRight() != componentOrientation2.isLeftToRight() && (bl || componentOrientation2 == ComponentOrientation.UNKNOWN)) {
            component.setComponentOrientation(componentOrientation);
            component.repaint();
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.reLayoutColumnRenderers();
        if (this.isEditing()) {
            Component component = this.getEditorComponent();
            JCSortableTable.setComponentOrientation(component, componentOrientation, false);
        }
        this.revalidate();
        this.getTableHeader().repaint();
        this.repaint();
    }

    protected void reLayoutColumnRenderers() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (!(tableCellRenderer instanceof JCCellRendererToJTable)) continue;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n2 = bl ? 2 : 4;
            ((JCCellRendererToJTable)tableCellRenderer).setHorizontalAlignment(n2);
        }
    }

    public static interface SortableColumnHeader {
        public void setSortIcon(Icon var1);
    }

    protected class SortableHeaderRenderer
    extends JPanel
    implements TableCellRenderer,
    SortableColumnHeader,
    Serializable {
        protected JLabel label = new JLabel("label");
        protected JButton sortButton = new JButton();
        protected JCBrace brace = JCBrace.createHorizontalBrace(3);
        protected Icon sortIcon = null;
        protected boolean currentLayoutLeft;

        public SortableHeaderRenderer() {
            this(true);
        }

        public SortableHeaderRenderer(boolean bl) {
            JCElasticLayout jCElasticLayout = new JCElasticLayout(0);
            jCElasticLayout.setAlignment(0);
            this.setLayout(jCElasticLayout);
            this.sortButton.setBorder(emptyBorder);
            this.sortButton.setVerticalAlignment(0);
            this.currentLayoutLeft = this.label.getComponentOrientation().isLeftToRight();
            this.reLayout(bl);
        }

        public boolean isCurrentLayoutLeft() {
            return this.currentLayoutLeft;
        }

        protected void setProperties(JTable jTable) {
            if (jTable == null) {
                return;
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                this.label.setForeground(jTableHeader.getForeground());
                this.label.setBackground(jTableHeader.getBackground());
                this.label.setFont(jTableHeader.getFont());
                this.sortButton.setBackground(jTableHeader.getBackground());
                this.sortButton.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setForeground(jTableHeader.getForeground());
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            Serializable serializable;
            if (jTable != null) {
                JCTableColumn jCTableColumn;
                int n4;
                serializable = jTable.getColumnModel().getColumn(n3);
                if (serializable != null && serializable instanceof JCTableColumn && (n4 = (jCTableColumn = (JCTableColumn)serializable).getHeaderLabelHorizontalAlignment()) >= 0) {
                    this.label.setHorizontalAlignment(n4);
                }
                this.setProperties(jTable);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.label.setText(object == null ? "" : object.toString());
            serializable = this.getComponentOrientation();
            boolean bl3 = jTable == null || serializable != ComponentOrientation.UNKNOWN ? ((ComponentOrientation)serializable).isLeftToRight() : jTable.getComponentOrientation().isLeftToRight();
            if (bl3 != this.currentLayoutLeft) {
                this.reLayout(bl3);
            }
            return this;
        }

        public void setSortIcon(Icon icon) {
            this.sortIcon = icon;
            if (icon != null) {
                this.sortButton.setIcon(icon);
            }
            this.reLayout(this.currentLayoutLeft);
        }

        public void reLayout(boolean bl) {
            this.removeAll();
            if (bl != this.currentLayoutLeft) {
                ComponentOrientation componentOrientation = bl ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
                JCSortableTable.setComponentOrientation(this.label, componentOrientation, true);
            }
            if (bl) {
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
            }
            if (this.sortIcon != null) {
                this.add(this.sortButton);
                this.add(this.brace);
            }
            if (!bl) {
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
                this.add(JCBrace.createHorizontalBrace(1));
            }
            this.currentLayoutLeft = bl;
        }
    }

    protected class SortableTableColumn
    extends JCTableColumn
    implements Serializable {
        public SortableTableColumn(int n2) {
            super(n2);
            this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        }

        protected TableCellRenderer createDefaultHeaderRenderer() {
            boolean bl = ComponentOrientation.UNKNOWN.isLeftToRight();
            if (JCSortableTable.this != null) {
                bl = JCSortableTable.this.getComponentOrientation().isLeftToRight();
            }
            return new SortableHeaderRenderer(bl);
        }
    }

    public class SortIcon
    implements Icon,
    Serializable {
        protected boolean isUp;
        protected Color color = Color.black;
        protected Color outlineColor = Color.gray;
        protected int width = 6;
        protected int height = 6;
        protected int[] xpoints = new int[3];
        protected int[] ypoints = new int[3];

        public SortIcon(boolean bl) {
            this.isUp = bl;
        }

        public SortIcon(boolean bl, Color color, Color color2) {
            this.isUp = bl;
            this.color = color;
            this.outlineColor = color2;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            if (color != null) {
                this.color = color;
            }
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color color) {
            if (color != null) {
                this.outlineColor = color;
            }
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.isUp) {
                this.xpoints[0] = n2;
                this.ypoints[0] = n3 + this.height;
                this.xpoints[1] = n2 + this.width / 2;
                this.ypoints[1] = n3;
                this.xpoints[2] = n2 + this.width;
                this.ypoints[2] = n3 + this.height;
            } else {
                this.xpoints[0] = n2;
                this.ypoints[0] = n3;
                this.xpoints[1] = n2 + this.width / 2;
                this.ypoints[1] = n3 + this.height;
                this.xpoints[2] = n2 + this.width;
                this.ypoints[2] = n3;
            }
            graphics.setColor(this.color);
            graphics.fillPolygon(this.xpoints, this.ypoints, 3);
            graphics.setColor(this.outlineColor);
            graphics.drawPolygon(this.xpoints, this.ypoints, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    protected class TableHeaderMouseListener
    extends MouseAdapter
    implements Serializable {
        protected boolean isPopupTrigger;

        protected TableHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.isPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.isPopupTrigger = this.isPopupTrigger || mouseEvent.isPopupTrigger();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            if (!this.isPopupTrigger && (n2 = JCSortableTable.this.columnAtPoint(mouseEvent.getPoint())) >= 0) {
                JCSortableTable.this.sort(n2);
            }
        }
    }
}

