/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRectUtil {
    public static final int LEFTTORIGHT = 0;
    public static final int TOPTOBOTTOM = 1;

    static void normalizeRectangles(Vector<Rectangle> vector) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Rectangle rectangle = vector.elementAt(i2);
            if (rectangle.width < 0) {
                rectangle.x += rectangle.width;
                rectangle.width = -rectangle.width;
            }
            if (rectangle.height >= 0) continue;
            rectangle.y += rectangle.height;
            rectangle.height = -rectangle.height;
        }
    }

    static Vector<Rectangle>[] makeRectangleGroups(Vector<Rectangle> vector) {
        int n2;
        Vector[] vectorArray = null;
        if (vector.size() == 0) {
            return vectorArray;
        }
        int n3 = vector.elementAt((int)0).y;
        int n4 = 1;
        for (n2 = 1; n2 < vector.size(); ++n2) {
            Rectangle rectangle = vector.elementAt(n2);
            if (rectangle.y == n3) continue;
            n3 = rectangle.y;
            ++n4;
        }
        n2 = n4 + 1;
        vectorArray = new Vector[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            vectorArray[n4] = new Vector();
        }
        int n5 = 0;
        Vector vector2 = vectorArray[n5];
        Rectangle rectangle = vector.elementAt(0);
        JCRectUtil.rectangleInit(rectangle, vector2);
        n3 = rectangle.y;
        for (int i2 = 1; i2 < vector.size(); ++i2) {
            Rectangle rectangle2 = vector.elementAt(i2);
            if (rectangle2.y == n3) {
                vector2.addElement(new Rectangle(rectangle2));
                continue;
            }
            Collections.sort(vector2, new RectSortLR());
            vector2 = vectorArray[++n5];
            n3 = rectangle2.y;
            JCRectUtil.rectangleInit(rectangle2, vector2);
        }
        Collections.sort(vector2, new RectSortLR());
        return vectorArray;
    }

    static double lgMetric(PointRect pointRect) {
        return (double)(pointRect.x2 - pointRect.x1) * (double)(pointRect.y2 - pointRect.y1);
    }

    static void calcLgRect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        PointRect pointRect = new PointRect();
        pointRect.x1 = rectangle2.x;
        pointRect.x2 = rectangle2.width + rectangle2.x - 1;
        pointRect.y1 = rectangle2.y;
        pointRect.y2 = rectangle2.height + rectangle2.y - 1;
        PointRect pointRect2 = new PointRect();
        pointRect2.x1 = rectangle3.x;
        pointRect2.x2 = rectangle3.width + rectangle3.x - 1;
        pointRect2.y1 = rectangle3.y;
        pointRect2.y2 = rectangle3.height + rectangle3.y - 1;
        PointRect pointRect3 = new PointRect();
        pointRect3.x1 = rectangle.x;
        pointRect3.x2 = rectangle.width + rectangle.x - 1;
        pointRect3.y1 = rectangle.y;
        pointRect3.y2 = rectangle.height + rectangle.y - 1;
        double d2 = JCRectUtil.lgMetric(pointRect3);
        if (pointRect.x1 == pointRect2.x1 && pointRect.x2 == pointRect2.x2 && pointRect.y1 == pointRect2.y1 && pointRect.y2 == pointRect2.y2) {
            double d3 = JCRectUtil.lgMetric(pointRect);
            if (d3 > d2) {
                rectangle.x = rectangle2.x;
                rectangle.y = rectangle2.y;
                rectangle.width = rectangle2.width;
                rectangle.height = rectangle2.height;
            }
        } else if (Math.abs(pointRect.y2 - pointRect2.y1) == 1) {
            PointRect pointRect4 = new PointRect();
            pointRect4.x1 = Math.max(pointRect.x1, pointRect2.x1);
            pointRect4.x2 = Math.min(pointRect.x2, pointRect2.x2);
            pointRect4.y1 = pointRect.y1;
            pointRect4.y2 = pointRect2.y2;
            if (pointRect4.x1 <= pointRect4.x2) {
                rectangle2.x = pointRect4.x1;
                rectangle2.y = pointRect4.y1;
                rectangle2.width = pointRect4.x2 - pointRect4.x1 + 1;
                rectangle2.height = pointRect4.y2 - pointRect4.y1 + 1;
                double d4 = JCRectUtil.lgMetric(pointRect4);
                if (d4 > d2) {
                    rectangle.x = rectangle2.x;
                    rectangle.y = rectangle2.y;
                    rectangle.width = rectangle2.width;
                    rectangle.height = rectangle2.height;
                }
            }
        } else if (Math.abs(pointRect.x2 - pointRect2.x1) == 1) {
            PointRect pointRect5 = new PointRect();
            pointRect5.x1 = pointRect.x1;
            pointRect5.x2 = pointRect2.x2;
            pointRect5.y1 = Math.max(pointRect.y1, pointRect2.y1);
            pointRect5.y2 = Math.min(pointRect.y2, pointRect2.y2);
            if (pointRect5.y1 <= pointRect5.y2) {
                rectangle2.x = pointRect5.x1;
                rectangle2.y = pointRect5.y1;
                rectangle2.width = pointRect5.x2 - pointRect5.x1 + 1;
                rectangle2.height = pointRect5.y2 - pointRect5.y1 + 1;
                double d5 = JCRectUtil.lgMetric(pointRect5);
                if (d5 > d2) {
                    rectangle.x = rectangle2.x;
                    rectangle.y = rectangle2.y;
                    rectangle.width = rectangle2.width;
                    rectangle.height = rectangle2.height;
                }
            }
        }
    }

    static void searchLgRect(Vector<Rectangle>[] vectorArray, int n2, Vector<Rectangle> vector, int n3, Rectangle rectangle, Rectangle rectangle2) {
        int n4;
        if (vector == null) {
            return;
        }
        for (n4 = n3; n4 < vector.size(); ++n4) {
            JCRectUtil.calcLgRect(rectangle, rectangle2, vector.elementAt(n4));
        }
        n4 = n2 + 1;
        Vector<Rectangle> vector2 = vectorArray[n4];
        while (vector2.size() > 0) {
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                JCRectUtil.calcLgRect(rectangle, rectangle3, vector2.elementAt(i2));
                JCRectUtil.searchLgRect(vectorArray, n4, vector2, i2, rectangle, rectangle3);
            }
            vector2 = vectorArray[++n4];
        }
    }

    static void appendRemaining(Rectangle rectangle, Rectangle rectangle2, Vector<Rectangle> vector) {
        int n2;
        int n3;
        int n4;
        if (rectangle.contains(rectangle2)) {
            return;
        }
        if (!rectangle.intersects(rectangle2)) {
            vector.addElement(new Rectangle(rectangle2));
            return;
        }
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = new Rectangle();
        int n5 = rectangle.y - rectangle3.y;
        if (n5 > 0) {
            rectangle4.x = rectangle3.x;
            rectangle4.y = rectangle3.y;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n5;
            vector.addElement(new Rectangle(rectangle4));
            rectangle3.y += n5;
            rectangle3.height -= n5;
        }
        if ((n5 = rectangle3.y + rectangle3.height - (n4 = rectangle.y + rectangle.height)) > 0) {
            rectangle4.x = rectangle3.x;
            rectangle4.y = n4;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n5;
            vector.addElement(new Rectangle(rectangle4));
            rectangle3.height -= n5;
        }
        if ((n3 = rectangle.x - rectangle3.x) > 0) {
            rectangle4.x = rectangle3.x;
            rectangle4.y = rectangle3.y;
            rectangle4.width = n3;
            rectangle4.height = rectangle3.height;
            vector.addElement(new Rectangle(rectangle4));
            rectangle3.x += n3;
            rectangle3.width -= n3;
        }
        if ((n3 = rectangle3.x + rectangle3.width - (n2 = rectangle.x + rectangle.width)) > 0) {
            rectangle4.x = n2;
            rectangle4.y = rectangle3.y;
            rectangle4.width = n3;
            rectangle4.height = rectangle3.height;
            vector.addElement(new Rectangle(rectangle4));
            rectangle3.width -= n3;
        }
    }

    static Rectangle bounding(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = new Rectangle();
        if (rectangle.isEmpty()) {
            rectangle3 = rectangle2;
        } else if (rectangle2.isEmpty()) {
            rectangle3 = rectangle;
        } else {
            rectangle3.x = Math.min(rectangle.x, rectangle2.x);
            rectangle3.y = Math.min(rectangle.y, rectangle2.y);
            rectangle3.width = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - rectangle3.x;
            rectangle3.height = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - rectangle3.y;
        }
        return rectangle3;
    }

    public static void rectangleInit(Rectangle rectangle, Vector<Rectangle> vector) {
        vector.clear();
        vector.addElement(new Rectangle(rectangle));
    }

    public static void rectangleRemove(Rectangle rectangle, Vector<Rectangle> vector, Vector<Rectangle> vector2) {
        Vector<Rectangle> vector3 = new Vector<Rectangle>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            JCRectUtil.appendRemaining(rectangle, vector.elementAt(i2), vector3);
        }
        vector2.clear();
        vector2.addAll(vector3);
    }

    public static Rectangle largestRect(Vector<Rectangle> vector) {
        JCRectUtil.normalizeRectangles(vector);
        Collections.sort(vector, new RectSortTB());
        Vector<Rectangle>[] vectorArray = JCRectUtil.makeRectangleGroups(vector);
        Rectangle rectangle = vectorArray[0].elementAt(0);
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = 0;
        Vector<Rectangle> vector2 = vectorArray[n2];
        while (vector2.size() > 0) {
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                Rectangle rectangle3 = new Rectangle(vector2.elementAt(i2));
                JCRectUtil.searchLgRect(vectorArray, n2, vector2, i2, rectangle2, rectangle3);
            }
            vector2 = vectorArray[++n2];
        }
        return rectangle2;
    }

    static class PointRect {
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;

        PointRect() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RectSortTB
    implements Comparator<Rectangle> {
        RectSortTB() {
        }

        @Override
        public int compare(Rectangle rectangle, Rectangle rectangle2) {
            int n2 = rectangle.y - rectangle2.y;
            if (n2 > 0) {
                return 1;
            }
            if (n2 < 0) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RectSortLR
    implements Comparator<Rectangle> {
        RectSortLR() {
        }

        @Override
        public int compare(Rectangle rectangle, Rectangle rectangle2) {
            int n2 = rectangle.x - rectangle2.x;
            if (n2 > 0) {
                return 1;
            }
            if (n2 < 0) {
                return -1;
            }
            return 0;
        }
    }
}

